/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.jdbc;

import java.sql.SQLException;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObject;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.DcmServiceException;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.common.SPSStatus;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.jdbc.BaseDSQueryCmd;

public class MWLQueryCmd
extends BaseDSQueryCmd {
    private static final String[] FROM = new String[]{"Patient", "MWLItem"};
    private static final String[] SELECT = new String[]{"Patient.encodedAttributes", "MWLItem.encodedAttributes"};
    private static final String[] RELATIONS = new String[]{"Patient.pk", "MWLItem.patient_fk"};
    private static final int[] MATCHING_KEYS = new int[]{0x401001, 524368, 0x20000D, 0x100020, 0x100021, 0x100010, 0x400100};
    private static final int[] MATCHING_SPS_SQ_KEYS = new int[]{0x400020, 0x400009, 0x400002, 0x400003, 524384, 0x400006, 0x400001, 0x400010};
    public static int transactionIsolationLevel = 0;
    public static int blobAccessType = -4;
    protected static final DcmObjectFactory dof = DcmObjectFactory.getInstance();

    public MWLQueryCmd(Dataset keys, boolean fuzzyMatchingOfPN, boolean noMatchForNoValue) throws SQLException, DcmServiceException {
        super(keys, true, noMatchForNoValue, transactionIsolationLevel);
        AttributeFilter patAttrFilter = AttributeFilter.getPatientAttributeFilter();
        this.defineColumnTypes(new int[]{blobAccessType, blobAccessType});
        if (!keys.contains(524293)) {
            keys.putCS(524293);
        }
        this.sqlBuilder.setSelect(SELECT);
        this.sqlBuilder.setFrom(FROM);
        this.sqlBuilder.setRelations(RELATIONS);
        Dataset spsItem = keys.getItem(0x400100);
        if (spsItem != null) {
            this.sqlBuilder.addListOfIntMatch(null, "MWLItem.spsStatusAsInt", false, SPSStatus.toInts((String[])spsItem.getStrings(0x400020)));
            this.sqlBuilder.addWildCardMatch(null, "MWLItem.spsId", false, spsItem.getStrings(0x400009));
            this.sqlBuilder.addRangeMatch(null, "MWLItem.spsStartDateTime", false, spsItem.getDateTimeRange(0x400002, 0x400003));
            this.sqlBuilder.addWildCardMatch(null, "MWLItem.modality", false, spsItem.getStrings(524384));
            this.sqlBuilder.addWildCardMatch(null, "MWLItem.scheduledStationAET", false, spsItem.getStrings(0x400001));
            this.sqlBuilder.addWildCardMatch(null, "MWLItem.scheduledStationName", this.type2, spsItem.getStrings(0x400010));
            if (fuzzyMatchingOfPN) {
                try {
                    this.sqlBuilder.addPNFuzzyMatch(new String[]{"MWLItem.performingPhysicianFamilyNameSoundex", "MWLItem.performingPhysicianGivenNameSoundex"}, this.type2, keys.getString(0x400006));
                }
                catch (IllegalArgumentException ex) {
                    throw new DcmServiceException(43264, ex.getMessage() + ": " + keys.get(0x400006));
                }
            } else {
                this.sqlBuilder.addPNMatch(new String[]{"MWLItem.performingPhysicianName", "MWLItem.performingPhysicianIdeographicName", "MWLItem.performingPhysicianPhoneticName"}, true, this.type2, spsItem.getString(0x400006));
            }
        }
        this.sqlBuilder.addWildCardMatch(null, "MWLItem.requestedProcedureId", false, keys.getStrings(0x401001));
        this.sqlBuilder.addWildCardMatch(null, "MWLItem.accessionNumber", this.type2, keys.getStrings(524368));
        this.sqlBuilder.addListOfStringMatch(null, "MWLItem.studyIuid", false, keys.getStrings(0x20000D));
        if (this.sqlBuilder.addWildCardMatch(null, "Patient.patientId", false, patAttrFilter.getStrings(keys, 0x100020)) != null) {
            this.sqlBuilder.addSingleValueMatch(null, "Patient.issuerOfPatientId", this.type2, patAttrFilter.getString(keys, 0x100021));
        }
        if (fuzzyMatchingOfPN) {
            try {
                this.sqlBuilder.addPNFuzzyMatch(new String[]{"Patient.patientFamilyNameSoundex", "Patient.patientGivenNameSoundex"}, this.type2, keys.getString(0x100010));
            }
            catch (IllegalArgumentException ex) {
                throw new DcmServiceException(43264, ex.getMessage() + ": " + keys.get(0x100010));
            }
        } else {
            this.sqlBuilder.addPNMatch(new String[]{"Patient.patientName", "Patient.patientIdeographicName", "Patient.patientPhoneticName"}, this.type2, patAttrFilter.isICase(0x100010), keys.getString(0x100010));
        }
    }

    public Dataset getDataset() throws SQLException {
        Dataset ds = DcmObjectFactory.getInstance().newDataset();
        Dataset dsPat = DcmObjectFactory.getInstance().newDataset();
        DatasetUtils.fromByteArray((byte[])this.rs.getBytes(1), (Dataset)dsPat);
        DatasetUtils.fromByteArray((byte[])this.rs.getBytes(2), (Dataset)ds);
        ds.putAll((DcmObject)dsPat);
        this.adjustDataset(ds, this.keys);
        return ds.subSet(this.keys);
    }
}

