/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.jdbc.BaseReadCmd;
import org.dcm4chex.archive.ejb.jdbc.JdbcProperties;
import org.dcm4chex.archive.ejb.jdbc.SqlBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPPSQueryCmd
extends BaseReadCmd {
    public static int transactionIsolationLevel = 0;
    public static int blobAccessType = -4;
    private static final String[] FROM = new String[]{"Patient", "MPPS"};
    private static final String[] SELECT = new String[]{"Patient.encodedAttributes", "MPPS.encodedAttributes"};
    private static final String[] RELATIONS = new String[]{"Patient.pk", "MPPS.patient_fk"};
    private static final int[] PATIENT_ATTRS = new int[]{528672, 0x100010, 0x100020, 0x100021, 0x100030, 0x100040};
    private final SqlBuilder sqlBuilder = new SqlBuilder();

    public MPPSQueryCmd(Dataset keys, boolean emptyAccNo) throws SQLException {
        super(JdbcProperties.getInstance().getDataSource(), transactionIsolationLevel);
        AttributeFilter patAttrFilter = AttributeFilter.getPatientAttributeFilter();
        this.defineColumnTypes(new int[]{blobAccessType, blobAccessType});
        this.sqlBuilder.setFrom(FROM);
        this.sqlBuilder.setRelations(RELATIONS);
        this.sqlBuilder.addListOfStringMatch(null, "MPPS.sopIuid", false, keys.getStrings(524312));
        if (emptyAccNo) {
            this.sqlBuilder.addNULLValueMatch(null, "MPPS.accessionNumber", false);
        } else {
            this.sqlBuilder.addListOfStringMatch(null, "MPPS.accessionNumber", true, keys.getStrings(524368));
        }
        this.sqlBuilder.addListOfStringMatch(null, "Patient.patientId", false, keys.getStrings(0x100020));
        this.sqlBuilder.addPNMatch(new String[]{"Patient.patientName", "Patient.patientIdeographicName", "Patient.patientPhoneticName"}, true, patAttrFilter.isICase(0x100010), keys.getString(0x100010));
        this.sqlBuilder.addListOfStringMatch(null, "MPPS.modality", false, keys.getStrings(524384));
        this.sqlBuilder.addListOfStringMatch(null, "MPPS.performedStationAET", false, keys.getStrings(4194881));
        this.sqlBuilder.addRangeMatch(null, "MPPS.ppsStartDateTime", false, keys.getDateTimeRange(0x400244, 4194885));
        this.sqlBuilder.addListOfStringMatch(null, "MPPS.ppsStatusAsInt", false, keys.getStrings(4194898));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count() throws SQLException {
        try {
            this.sqlBuilder.setSelectCount(new String[]{"MPPS.pk"}, true);
            this.execute(this.sqlBuilder.getSql());
            this.next();
            int n = this.rs.getInt(1);
            return n;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Dataset> list(int offset, int limit) {
        this.sqlBuilder.setSelect(SELECT);
        this.sqlBuilder.addOrderBy("MPPS.ppsStartDateTime", " DESC");
        this.sqlBuilder.setOffset(offset);
        this.sqlBuilder.setLimit(limit);
        this.setFetchSize(limit);
        ArrayList<Dataset> resp = null;
        try {
            resp = new ArrayList<Dataset>();
            this.execute(this.sqlBuilder.getSql());
            while (this.next()) {
                resp.add(this.getDataset());
            }
        }
        catch (Exception x) {
            log.error((Object)("Exception occured in getMWLEntries: " + x.getMessage()), (Throwable)x);
        }
        finally {
            this.close();
        }
        return resp;
    }

    public Dataset getDataset() throws SQLException {
        Dataset ds = DcmObjectFactory.getInstance().newDataset();
        DatasetUtils.fromByteArray((byte[])this.rs.getBytes(2), (Dataset)ds);
        DatasetUtils.fromByteArray((byte[])this.rs.getBytes(1), (Dataset)ds);
        return ds;
    }
}

