/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.jdbc;

import java.io.InputStream;
import java.util.Properties;

public class JdbcProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    public static final int HSQL = 0;
    public static final int PSQL = 1;
    public static final int MYSQL = 2;
    public static final int DB2 = 3;
    public static final int ORACLE = 4;
    public static final int MSSQL = 5;
    public static final int FIREBIRD = 6;
    private static final String DATASOURCE_KEY = "datasource";
    private static final String DS_TYPE_KEY = "datasource-type";
    private static final JdbcProperties instance = new JdbcProperties();
    private final String datasource;
    private final int database;

    public static JdbcProperties getInstance() {
        return instance;
    }

    public String[] getProperties(String[] keys) {
        String[] values = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            values[i] = this.getProperty(keys[i]);
        }
        return values;
    }

    public String getProperty(String key) {
        if (key == null || Character.isLowerCase(key.charAt(0))) {
            return key;
        }
        String value = super.getProperty(key);
        if (value == null) {
            throw new IllegalArgumentException("key: " + key);
        }
        return value;
    }

    public final int getDatabase() {
        return this.database;
    }

    public final String getDataSource() {
        return this.datasource;
    }

    public final String getEscape() {
        return this.database == 2 || this.database == 1 ? "" : " ESCAPE '\\'";
    }

    private JdbcProperties() {
        try {
            InputStream in = JdbcProperties.class.getResourceAsStream("Jdbc.properties");
            this.load(in);
            in.close();
            this.database = Integer.parseInt(super.getProperty(DS_TYPE_KEY));
            this.datasource = super.getProperty(DATASOURCE_KEY);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load jdbc properties", e);
        }
    }
}

