/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.ejb.CreateException;
import javax.sql.DataSource;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCInsertPKCreateCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData;

public class JDBCFirebirdSequenceCreateCommand
extends JDBCInsertPKCreateCommand {
    private String sequence_name;
    private String sequenceSQL;
    protected JDBCCMPFieldBridge pkField;

    protected void initGeneratedFields() throws DeploymentException {
        super.initGeneratedFields();
        this.pkField = this.getGeneratedPKField();
    }

    public void init(JDBCStoreManager manager) throws DeploymentException {
        super.init(manager);
    }

    protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) throws DeploymentException {
        super.initEntityCommand(entityCommand);
        this.sequence_name = entityCommand.getAttribute("sequence_name");
        if (this.sequence_name == null) {
            throw new DeploymentException("sequence_name attribute must be specified inside <entity-command>");
        }
        String sequence_name_inst = JDBCFirebirdSequenceCreateCommand.replaceTable(this.sequence_name, this.entity.getTableName());
        this.sequenceSQL = "SELECT GEN_ID(" + sequence_name_inst + ",1) FROM RDB$DATABASE;";
        if (this.debug) {
            this.log.debug((Object)("SEQUENCE SQL is :" + this.sequenceSQL));
        }
    }

    private static String replaceTable(String in, String table) {
        int pos = in.indexOf("%%t");
        if (pos == -1) {
            return in;
        }
        String first = in.substring(0, pos);
        String last = in.substring(pos + 3);
        return first + table + last;
    }

    protected void generateFields(EntityEnterpriseContext ctx) throws CreateException {
        super.generateFields(ctx);
        Connection con = null;
        Statement s = null;
        ResultSet rs = null;
        try {
            DataSource dataSource;
            if (this.debug) {
                this.log.debug((Object)("Executing SQL: " + this.sequenceSQL));
            }
            if (!(rs = (s = (con = (dataSource = this.entity.getDataSource()).getConnection()).createStatement()).executeQuery(this.sequenceSQL)).next()) {
                throw new CreateException("Error fetching next primary key value: result set contains no rows");
            }
            this.pkField.loadInstanceResults(rs, 1, ctx);
        }
        catch (SQLException e) {
            try {
                this.log.error((Object)"Error fetching the next primary key value", (Throwable)e);
                throw new CreateException("Error fetching the next primary key value:" + e);
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(rs);
                JDBCUtil.safeClose(s);
                JDBCUtil.safeClose(con);
                throw throwable;
            }
        }
        JDBCUtil.safeClose((ResultSet)rs);
        JDBCUtil.safeClose((Statement)s);
        JDBCUtil.safeClose((Connection)con);
    }
}

