/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.common.HPLevel;
import org.dcm4chex.archive.ejb.jdbc.BaseDSQueryCmd;
import org.dcm4chex.archive.ejb.jdbc.Match;
import org.dcm4chex.archive.ejb.jdbc.SqlBuilder;

public class HPQueryCmd
extends BaseDSQueryCmd {
    public static int transactionIsolationLevel = 0;
    public static int blobAccessType = -4;
    private static final String[] FROM = new String[]{"HP"};
    private static final String[] SELECT = new String[]{"HP.encodedAttributes"};
    private static final String USER_CODE = "user_code";
    private static final String[] REGION_CODE = new String[]{"region_code", "rel_hpdef_region", "rel_hpdef_region.hpdef_fk", "rel_hpdef_region.region_fk"};
    private static final String[] PROC_CODE = new String[]{"proc_code", "rel_hpdef_proc", "rel_hpdef_proc.hpdef_fk", "rel_hpdef_proc.proc_fk"};
    private static final String[] REASON_CODE = new String[]{"reason_code", "rel_hpdef_reason", "rel_hpdef_reason.hpdef_fk", "rel_hpdef_reason.reason_fk"};

    public HPQueryCmd(Dataset keys) throws SQLException {
        super(keys, true, false, transactionIsolationLevel);
        int i;
        this.defineColumnTypes(new int[]{blobAccessType});
        if (!keys.contains(524293)) {
            keys.putCS(524293);
        }
        this.sqlBuilder.setSelect(SELECT);
        this.sqlBuilder.setFrom(FROM);
        this.sqlBuilder.setLeftJoin(this.getLeftJoin());
        this.sqlBuilder.addListOfUidMatch(null, "HP.sopIuid", false, keys.getStrings(524312));
        this.sqlBuilder.addListOfUidMatch(null, "HP.sopCuid", false, keys.getStrings(524310));
        this.sqlBuilder.addWildCardMatch(null, "HP.hangingProtocolName", true, keys.getStrings(0x720002));
        String s = keys.getString(7471110);
        if (s != null) {
            this.sqlBuilder.addIntValueMatch(null, "HP.hangingProtocolLevelAsInt", false, HPLevel.toInt((String)s));
        }
        if ((i = keys.getInt(7471124, -1)) != -1) {
            this.sqlBuilder.addIntValueMatch(null, "HP.numberOfPriorsReferenced", false, i);
        }
        if ((i = keys.getInt(7471360, -1)) != -1) {
            this.sqlBuilder.addIntValueMatch(null, "HP.numberOfScreens", true, i);
        }
        this.sqlBuilder.addWildCardMatch(null, "HP.hangingProtocolUserGroupName", true, keys.getStrings(7471120));
        this.addCodeMatch(keys.getItem(7471118), USER_CODE);
        Dataset item = keys.getItem(7471116);
        if (item != null) {
            this.sqlBuilder.addWildCardMatch(null, "HPDefinition.modality", true, item.getStrings(524384));
            this.sqlBuilder.addWildCardMatch(null, "HPDefinition.laterality", true, item.getStrings(0x200060));
            this.addCodeMatch(item.getItem(533016), REGION_CODE);
            this.addCodeMatch(item.getItem(528434), PROC_CODE);
            this.addCodeMatch(item.getItem(4198410), REASON_CODE);
        }
    }

    private void addCodeMatch(Dataset item, String alias) {
        if (item != null) {
            this.sqlBuilder.addSingleValueMatch(alias, "Code.codeValue", true, item.getString(524544));
            this.sqlBuilder.addSingleValueMatch(alias, "Code.codingSchemeDesignator", true, item.getString(524546));
        }
    }

    private void addCodeMatch(Dataset item, String[] codeQuery) {
        if (this.isMatchCode(item)) {
            SqlBuilder subQuery = new SqlBuilder();
            subQuery.setSelect(new String[]{"HPDefinition.pk"});
            subQuery.setFrom(new String[]{"HPDefinition", codeQuery[1], "Code"});
            subQuery.addFieldValueMatch(null, "HP.pk", false, null, "HPDefinition.hp_fk");
            subQuery.addFieldValueMatch(null, "HPDefinition.pk", false, null, codeQuery[2]);
            subQuery.addFieldValueMatch(null, "Code.pk", false, null, codeQuery[3]);
            subQuery.addSingleValueMatch(null, "Code.codeValue", true, item.getString(524544));
            subQuery.addSingleValueMatch(null, "Code.codingSchemeDesignator", true, item.getString(524546));
            Match.Node node0 = this.sqlBuilder.addNodeMatch("OR", false);
            node0.addMatch(new Match.Subquery(subQuery, null, null));
        }
    }

    private boolean isMatchCode(Dataset code) {
        return code != null && (code.containsValue(524544) || code.containsValue(524546));
    }

    private String[] getLeftJoin() {
        Dataset item;
        ArrayList<String> list = new ArrayList<String>();
        if (this.isMatchCode(this.keys.getItem(7471118))) {
            list.add("Code");
            list.add(USER_CODE);
            list.add("HP.user_fk");
            list.add("Code.pk");
        }
        if ((item = this.keys.getItem(7471116)) != null && !item.isEmpty()) {
            list.add("HPDefinition");
            list.add(null);
            list.add("HP.pk");
            list.add("HPDefinition.hp_fk");
        }
        return list.isEmpty() ? null : list.toArray(new String[list.size()]);
    }

    public Dataset getDataset() throws SQLException {
        Dataset ds = DcmObjectFactory.getInstance().newDataset();
        DatasetUtils.fromByteArray((byte[])this.rs.getBytes(1), (Dataset)ds);
        this.adjustDataset(ds, this.keys);
        return ds.subSet(this.keys);
    }
}

