/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.DcmServiceException;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.common.GPSPSStatus;
import org.dcm4chex.archive.common.InputAvailabilityFlag;
import org.dcm4chex.archive.common.Priority;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.jdbc.BaseDSQueryCmd;

public class GPWLQueryCmd
extends BaseDSQueryCmd {
    public static int transactionIsolationLevel = 0;
    public static int blobAccessType = -4;
    private static final String[] FROM = new String[]{"Patient", "GPSPS"};
    private static final String[] SELECT = new String[]{"Patient.encodedAttributes", "GPSPS.encodedAttributes"};
    private static final String[] RELATIONS = new String[]{"Patient.pk", "GPSPS.patient_fk"};
    private static final String ITEM_CODE = "item_code";
    private static final String APP_CODE = "app_code";
    private static final String DEVNAME_CODE = "devname_code";
    private static final String DEVCLASS_CODE = "devclass_code";
    private static final String DEVLOC_CODE = "devloc_code";
    private static final String PERF_CODE = "perf_code";

    public GPWLQueryCmd(Dataset keys, boolean fuzzyMatchingOfPN) throws SQLException, DcmServiceException {
        super(keys, true, false, transactionIsolationLevel);
        AttributeFilter patAttrFilter = AttributeFilter.getPatientAttributeFilter();
        this.defineColumnTypes(new int[]{blobAccessType, blobAccessType});
        if (!keys.contains(524293)) {
            keys.putCS(524293);
        }
        this.sqlBuilder.setSelect(SELECT);
        this.sqlBuilder.setFrom(FROM);
        this.sqlBuilder.setRelations(RELATIONS);
        this.sqlBuilder.setLeftJoin(this.getLeftJoin());
        this.sqlBuilder.addListOfUidMatch(null, "GPSPS.sopIuid", false, keys.getStrings(524312));
        String s = keys.getString(0x404001);
        if (s != null) {
            this.sqlBuilder.addIntValueMatch(null, "GPSPS.gpspsStatusAsInt", false, GPSPSStatus.toInt((String)s));
        }
        if ((s = keys.getString(0x404020)) != null) {
            this.sqlBuilder.addIntValueMatch(null, "GPSPS.inputAvailabilityFlagAsInt", false, InputAvailabilityFlag.toInt((String)s));
        }
        if ((s = keys.getString(0x404003)) != null) {
            this.sqlBuilder.addIntValueMatch(null, "GPSPS.gpspsPriorityAsInt", false, Priority.toInt((String)s));
        }
        this.sqlBuilder.addRangeMatch(null, "GPSPS.spsStartDateTime", false, keys.getDateRange(0x404005));
        this.sqlBuilder.addRangeMatch(null, "GPSPS.expectedCompletionDateTime", true, keys.getDateRange(0x404011));
        this.addCodeMatch(4210712, ITEM_CODE);
        this.addCodeMatch(0x404004, APP_CODE);
        this.addCodeMatch(4210725, DEVNAME_CODE);
        this.addCodeMatch(4210726, DEVCLASS_CODE);
        this.addCodeMatch(4210727, DEVLOC_CODE);
        Dataset item = keys.getItem(0x404034);
        if (item != null) {
            if (fuzzyMatchingOfPN) {
                try {
                    this.sqlBuilder.addPNFuzzyMatch(new String[]{"GPSPSPerformer.humanPerformerFamilyNameSoundex", "GPSPSPerformer.humanPerformerGivenNameSoundex"}, true, keys.getString(4210743));
                }
                catch (IllegalArgumentException ex) {
                    throw new DcmServiceException(43264, ex.getMessage() + ": " + keys.get(4210743));
                }
            } else {
                this.sqlBuilder.addPNMatch(new String[]{"GPSPSPerformer.humanPerformerName", "GPSPSPerformer.humanPerformerIdeographicName", "GPSPSPerformer.humanPerformerPhoneticName"}, true, true, item.getString(4210743));
            }
            this.addCodeMatch(item.getItem(0x404009), PERF_CODE);
        }
        if ((item = keys.getItem(4236144)) != null) {
            this.sqlBuilder.addListOfStringMatch(null, "GPSPSRequest.requestedProcedureId", true, item.getStrings(0x401001));
            this.sqlBuilder.addListOfStringMatch(null, "GPSPSRequest.accessionNumber", true, item.getStrings(524368));
        }
        if (this.sqlBuilder.addListOfStringMatch(null, "Patient.patientId", false, patAttrFilter.getStrings(keys, 0x100020)) != null) {
            this.sqlBuilder.addSingleValueMatch(null, "Patient.issuerOfPatientId", true, patAttrFilter.getString(keys, 0x100021));
        }
        if (fuzzyMatchingOfPN) {
            try {
                this.sqlBuilder.addPNFuzzyMatch(new String[]{"Patient.patientFamilyNameSoundex", "Patient.patientGivenNameSoundex"}, true, keys.getString(0x100010));
            }
            catch (IllegalArgumentException ex) {
                throw new DcmServiceException(43264, ex.getMessage() + ": " + keys.get(0x100010));
            }
        } else {
            this.sqlBuilder.addPNMatch(new String[]{"Patient.patientName", "Patient.patientIdeographicName", "Patient.patientPhoneticName"}, true, patAttrFilter.isICase(0x100010), keys.getString(0x100010));
        }
    }

    private void addCodeMatch(int tag, String alias) {
        this.addCodeMatch(this.keys.getItem(tag), alias);
    }

    private void addCodeMatch(Dataset item, String alias) {
        if (item != null) {
            this.sqlBuilder.addSingleValueMatch(alias, "Code.codeValue", true, item.getString(524544));
            this.sqlBuilder.addSingleValueMatch(alias, "Code.codingSchemeDesignator", true, item.getString(524546));
        }
    }

    private boolean isMatchCode(int tag) {
        return this.isMatchCode(this.keys.getItem(tag));
    }

    private boolean isMatchCode(Dataset code) {
        return code != null && (code.containsValue(524544) || code.containsValue(524546));
    }

    private boolean isMatchRefRequest() {
        Dataset refrq = this.keys.getItem(4236144);
        return refrq != null && (refrq.containsValue(0x401001) || refrq.containsValue(524368));
    }

    private String[] getLeftJoin() {
        boolean matchCode;
        Dataset item;
        ArrayList<String> list = new ArrayList<String>();
        if (this.isMatchCode(4210712)) {
            list.add("Code");
            list.add(ITEM_CODE);
            list.add("GPSPS.code_fk");
            list.add("Code.pk");
        }
        if (this.isMatchCode(0x404004)) {
            this.sqlBuilder.setDistinct(true);
            list.add("rel_gpsps_appcode");
            list.add(null);
            list.add("GPSPS.pk");
            list.add("rel_gpsps_appcode.gpsps_fk");
            list.add("Code");
            list.add(APP_CODE);
            list.add("rel_gpsps_appcode.appcode_fk");
            list.add("Code.pk");
        }
        if (this.isMatchCode(4210725)) {
            this.sqlBuilder.setDistinct(true);
            list.add("rel_gpsps_devname");
            list.add(null);
            list.add("GPSPS.pk");
            list.add("rel_gpsps_devname.gpsps_fk");
            list.add("Code");
            list.add(DEVNAME_CODE);
            list.add("rel_gpsps_devname.devname_fk");
            list.add("Code.pk");
        }
        if (this.isMatchCode(4210726)) {
            this.sqlBuilder.setDistinct(true);
            list.add("rel_gpsps_devclass");
            list.add(null);
            list.add("GPSPS.pk");
            list.add("rel_gpsps_devclass.gpsps_fk");
            list.add("Code");
            list.add(DEVCLASS_CODE);
            list.add("rel_gpsps_devclass.devclass_fk");
            list.add("Code.pk");
        }
        if (this.isMatchCode(4210727)) {
            this.sqlBuilder.setDistinct(true);
            list.add("rel_gpsps_devloc");
            list.add(null);
            list.add("GPSPS.pk");
            list.add("rel_gpsps_devloc.gpsps_fk");
            list.add("Code");
            list.add(DEVLOC_CODE);
            list.add("rel_gpsps_devloc.devloc_fk");
            list.add("Code.pk");
        }
        if ((item = this.keys.getItem(0x404034)) != null && ((matchCode = this.isMatchCode(item.getItem(0x404009))) || item.containsValue(4210743))) {
            this.sqlBuilder.setDistinct(true);
            list.add("GPSPSPerformer");
            list.add(null);
            list.add("GPSPS.pk");
            list.add("GPSPSPerformer.gpsps_fk");
            if (matchCode) {
                list.add("Code");
                list.add(PERF_CODE);
                list.add("GPSPSPerformer.code_fk");
                list.add("Code.pk");
            }
        }
        if (this.isMatchRefRequest()) {
            this.sqlBuilder.setDistinct(true);
            list.add("GPSPSRequest");
            list.add(null);
            list.add("GPSPS.pk");
            list.add("GPSPSRequest.gpsps_fk");
        }
        return list.isEmpty() ? null : list.toArray(new String[list.size()]);
    }

    public Dataset getDataset() throws SQLException {
        Dataset ds = DcmObjectFactory.getInstance().newDataset();
        DatasetUtils.fromByteArray((byte[])this.rs.getBytes(1), (Dataset)ds);
        DatasetUtils.fromByteArray((byte[])this.rs.getBytes(2), (Dataset)ds);
        this.adjustDataset(ds, this.keys);
        return ds.subSet(this.keys);
    }
}

