/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.jdbc;

import java.sql.SQLException;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.jdbc.BaseDSQueryCmd;

public class GPPPSQueryCmd
extends BaseDSQueryCmd {
    public static int transactionIsolationLevel = 0;
    public static int blobAccessType = -4;
    private static final String[] FROM = new String[]{"Patient", "GPPPS"};
    private static final String[] SELECT = new String[]{"Patient.encodedAttributes", "GPPPS.encodedAttributes"};
    private static final String[] RELATIONS = new String[]{"Patient.pk", "GPPPS.patient_fk"};

    public GPPPSQueryCmd(Dataset keys) throws SQLException {
        super(keys, false, true, transactionIsolationLevel);
        AttributeFilter patAttrFilter = AttributeFilter.getPatientAttributeFilter();
        this.defineColumnTypes(new int[]{blobAccessType, blobAccessType});
        this.sqlBuilder.setSelect(SELECT);
        this.sqlBuilder.setFrom(FROM);
        this.sqlBuilder.setRelations(RELATIONS);
        this.sqlBuilder.addListOfStringMatch(null, "GPPPS.sopIuid", false, keys.getStrings(524312));
        this.sqlBuilder.addListOfStringMatch(null, "Patient.patientId", false, patAttrFilter.getStrings(keys, 0x100020));
        this.sqlBuilder.addPNMatch(new String[]{"Patient.patientName", "Patient.patientIdeographicName", "Patient.patientPhoneticName"}, true, patAttrFilter.isICase(0x100010), keys.getString(0x100010));
        this.sqlBuilder.addRangeMatch(null, "GPPPS.ppsStartDateTime", false, keys.getDateTimeRange(0x400244, 4194885));
        this.sqlBuilder.addListOfStringMatch(null, "GPPPS.ppsStatusAsInt", false, keys.getStrings(4194898));
    }

    public Dataset getDataset() throws SQLException {
        Dataset ds = DcmObjectFactory.getInstance().newDataset();
        DatasetUtils.fromByteArray((byte[])this.rs.getBytes(1), (Dataset)ds);
        DatasetUtils.fromByteArray((byte[])this.rs.getBytes(2), (Dataset)ds);
        return ds;
    }
}

