/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.dcm4chex.archive.ejb.jdbc.BaseCmd;

public abstract class BaseUpdateCmd
extends BaseCmd {
    protected BaseUpdateCmd(String dsJndiName, int transactionIsolationLevel, String sql) throws SQLException {
        super(dsJndiName, transactionIsolationLevel, sql);
    }

    public int execute() throws SQLException {
        Throwable lastException = null;
        for (int i = 0; i < this.updateDatabaseMaxRetries; ++i) {
            try {
                return ((PreparedStatement)this.stmt).executeUpdate();
            }
            catch (SQLException e) {
                if (lastException == null || !lastException.getMessage().equals(e.getMessage())) {
                    log.warn((Object)("failed to execute sql: " + this.sql + " - retry: " + (i + 1) + " of " + this.updateDatabaseMaxRetries), (Throwable)e);
                } else {
                    log.warn((Object)("failed to execute sql: " + this.sql + ". Got the same exception as above - retry: " + (i + 1) + " of " + this.updateDatabaseMaxRetries));
                }
                lastException = e;
                this.close();
                try {
                    Thread.sleep(this.updateDatabaseRetryInterval);
                }
                catch (InterruptedException e1) {
                    log.warn((Object)e1);
                }
                try {
                    this.open();
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                continue;
            }
        }
        throw new SQLException("give up executing SQL statement after all retries: " + this.sql);
    }
}

