/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.StringTokenizer;
import org.dcm4chex.archive.ejb.jdbc.BaseReadCmd;
import org.dcm4chex.archive.ejb.jdbc.JdbcProperties;
import org.dcm4chex.archive.ejb.jdbc.SqlBuilder;

public class BaseSQLCmd
extends BaseReadCmd {
    private static final int SELECT_LEN = 7;
    public static int transactionIsolationLevel = 0;

    protected BaseSQLCmd(String sql, int fetchSize, int limit, String checkPkTable) throws SQLException {
        super(JdbcProperties.getInstance().getDataSource(), transactionIsolationLevel, BaseSQLCmd.prepareSql(sql, limit, checkPkTable));
        this.setFetchSize(fetchSize < 0 ? limit : fetchSize);
        try {
            this.close();
        }
        catch (Throwable t) {
            log.warn((Object)("Initial close failed:" + t.getLocalizedMessage()));
        }
    }

    public static BaseSQLCmd getInstance(String sql, int limit, int fetchSize, String checkPkTable) throws SQLException {
        return new BaseSQLCmd(sql, fetchSize, limit, checkPkTable);
    }

    public static String prepareSql(String sql, int limit, String checkPkTable) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        if ((sql = sql.trim()).endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        sql = sql.replaceAll("\\s\\s+", " ");
        log.debug((Object)("Original SQL (formatted):" + sql));
        if (limit > 0) {
            String sql1;
            int pos0;
            if (checkPkTable != null) {
                sql = BaseSQLCmd.addPkCheck(sql, checkPkTable);
            }
            if ((pos0 = (sql1 = sql.toUpperCase()).indexOf("DISTINCT")) != -1) {
                sqlBuilder.setDistinct(true);
                pos0 += 9;
            } else {
                pos0 = 7;
            }
            int pos1 = sql1.indexOf("FROM");
            StringBuffer sb = new StringBuffer(sql.length() + 30);
            sb.append(sql.substring(0, 7));
            sqlBuilder.setLimit(limit);
            String[] fields = BaseSQLCmd.toFields(sql.substring(pos0, pos1));
            sqlBuilder.setFieldNamesForSelect(fields);
            sqlBuilder.addOrderBy(fields[0], " ASC");
            sqlBuilder.appendLimitbeforeFrom(sb);
            sb.append(' ');
            int pos2 = sql1.indexOf("FOR READ ONLY", pos1);
            if (pos2 > 0) {
                sb.append(sql.substring(pos1, pos2));
                sqlBuilder.appendLimitAtEnd(sb);
                sb.append(' ').append(sql.substring(pos2));
            } else {
                sb.append(sql.substring(pos1));
                sqlBuilder.appendLimitAtEnd(sb);
            }
            log.debug((Object)("SQL with LIMIT:" + sb));
            return sb.toString();
        }
        return sql;
    }

    private static String addPkCheck(String sql, String checkPkTable) {
        checkPkTable = checkPkTable.toUpperCase();
        log.debug((Object)("Add " + checkPkTable + ".pk check to sql:" + sql));
        String sqlUC = sql.toUpperCase();
        int posFrom = sqlUC.indexOf("FROM");
        int posTable = sqlUC.indexOf(checkPkTable, posFrom += 5);
        if (posTable == -1) {
            log.warn((Object)(checkPkTable + " table not found is SELECT statement! pk check not added!"));
            return sql;
        }
        int posWhere = sqlUC.indexOf("WHERE", posTable);
        if (sqlUC.indexOf("PK > ?", posWhere += 6) != -1) {
            log.info((Object)"'pk > ?' found in WHERE clause! Use this as pk check!");
            return sql;
        }
        String alias = sql.substring(posTable, posTable += 6);
        while (sqlUC.charAt(posTable) == ' ') {
            ++posTable;
        }
        if (sqlUC.charAt(posTable++) == 'A' && sqlUC.charAt(posTable++) == 'S') {
            int posEndAlias = ++posTable;
            while (sqlUC.charAt(posEndAlias) != ',' && sqlUC.charAt(posEndAlias) != ' ') {
                ++posEndAlias;
            }
            alias = sql.substring(posTable, posEndAlias);
        }
        StringBuffer sb = new StringBuffer(sql.length() + alias.length() + 10);
        sb.append(sql.substring(0, posWhere)).append(alias).append(".pk > ? AND ");
        if (sqlUC.lastIndexOf("ORDER BY") == -1) {
            int posDB2 = sqlUC.indexOf("FOR READ ONLY", posWhere);
            if (posDB2 == -1) {
                sb.append(sql.substring(posWhere)).append(" ORDER BY ").append(alias).append(".pk ");
            } else {
                sb.append(sql.subSequence(posWhere, posDB2)).append(" ORDER BY ").append(alias).append(".pk ").append(sql.substring(posDB2));
            }
        } else {
            sb.append(sql.substring(posWhere));
        }
        log.debug((Object)("SQL with " + checkPkTable + ".pk check:" + sb));
        return sb.toString();
    }

    private static String[] toFields(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        String[] fields = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            fields[i++] = st.nextToken();
        }
        return fields;
    }

    protected void setParams(Long updatedBefore, long lastPk) throws SQLException {
        if (updatedBefore != null) {
            int paraIdx = 1;
            if (new StringTokenizer(this.sql, "?").countTokens() > 2) {
                log.debug((Object)("Set parameter 1 (pk > lastPk) to:" + lastPk));
                ((PreparedStatement)this.stmt).setLong(paraIdx++, lastPk);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set parameter (updatedBefore) to:" + updatedBefore + " Date:" + new Date(updatedBefore)));
            }
            ((PreparedStatement)this.stmt).setDate(paraIdx, new java.sql.Date(updatedBefore));
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Use of updatedBefore WHERE clause disabled! Dont set parameter of prepared statement");
            }
            if (this.sql.indexOf(63) != -1) {
                log.debug((Object)("Set parameter 1 (pk > lastPk) to:" + lastPk));
                ((PreparedStatement)this.stmt).setLong(1, lastPk);
            }
        }
    }

    public String getSQL() {
        return this.sql;
    }

    public String formatSql() {
        if (this.sql == null) {
            return "SQL not set!";
        }
        String sqlUC = this.sql.toUpperCase();
        StringBuilder sb = new StringBuilder(this.sql.length() + 10);
        int[] pos = new int[]{0, 0};
        this.appendAndSplit(sb, pos, this.sql, sqlUC, "FROM", null);
        this.appendAndSplit(sb, pos, this.sql, sqlUC, "WHERE", null);
        while (this.appendAndSplit(sb, pos, this.sql, sqlUC, "EXISTS", "NOT EXISTS")) {
        }
        this.appendAndSplit(sb, pos, this.sql, sqlUC, "ORDER", null);
        sb.append(this.sql.substring(pos[0]));
        return sb.toString();
    }

    private boolean appendAndSplit(StringBuilder sb, int[] pos, String sql, String sqlUC, String splitAt, String altSplitAt) {
        int pos2;
        pos[1] = sqlUC.indexOf(splitAt, pos[0]);
        if (altSplitAt != null && (pos2 = sqlUC.indexOf(altSplitAt, pos[0])) != -1 && (pos[1] == -1 || pos2 < pos[1])) {
            pos[1] = pos2;
            splitAt = altSplitAt;
        }
        if (pos[1] != -1) {
            sb.append(sql.substring(pos[0], pos[1])).append("\n");
            pos[0] = pos[1];
            pos[1] = pos[1] + splitAt.length();
            sb.append(sql.subSequence(pos[0], pos[1]));
            pos[0] = pos[1];
            return true;
        }
        return false;
    }
}

