/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dcm4chex.archive.ejb.jdbc.BaseCmd;

public abstract class BaseReadCmd
extends BaseCmd {
    protected ResultSet rs = null;
    protected int fetchSize;

    protected BaseReadCmd(String dsJndiName, int transactionIsolationLevel, int resultSetType) throws SQLException {
        super(dsJndiName, transactionIsolationLevel, null, resultSetType);
    }

    protected BaseReadCmd(String dsJndiName, int transactionIsolationLevel) throws SQLException {
        super(dsJndiName, transactionIsolationLevel, null);
    }

    protected BaseReadCmd(String dsJndiName, int transactionIsolationLevel, String sql) throws SQLException {
        super(dsJndiName, transactionIsolationLevel, sql);
    }

    public BaseReadCmd setFetchSize(int size) {
        this.fetchSize = size;
        return this;
    }

    public void execute(String sql) throws SQLException {
        if (this.rs != null) {
            throw new IllegalStateException();
        }
        log.debug((Object)("SQL: " + sql));
        Throwable lastException = null;
        for (int i = 0; i < this.updateDatabaseMaxRetries; ++i) {
            try {
                if (this.fetchSize > 0) {
                    this.stmt.setFetchSize(this.fetchSize);
                }
                this.rs = this.stmt.executeQuery(sql);
                if (i > 0) {
                    log.info((Object)("execute sql successfully after retry: " + (i + 1)));
                }
                return;
            }
            catch (Exception e) {
                if (lastException == null || !lastException.getMessage().equals(e.getMessage())) {
                    log.warn((Object)("failed to execute sql: " + sql + " - retry: " + (i + 1) + " of " + this.updateDatabaseMaxRetries), (Throwable)e);
                } else {
                    log.warn((Object)("failed to execute sql: " + sql + ", got the same exception as above - retry: " + (i + 1) + " of " + this.updateDatabaseMaxRetries));
                }
                lastException = e;
                this.close();
                try {
                    Thread.sleep(this.updateDatabaseRetryInterval);
                }
                catch (InterruptedException e1) {
                    log.warn((Object)e1);
                }
                try {
                    this.open();
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                continue;
            }
        }
        throw new SQLException("give up executing SQL statement after all retries: " + sql);
    }

    public void execute() throws SQLException {
        if (this.rs != null) {
            throw new IllegalStateException();
        }
        Throwable lastException = null;
        for (int i = 0; i < this.updateDatabaseMaxRetries; ++i) {
            try {
                if (this.fetchSize > 0) {
                    this.stmt.setFetchSize(this.fetchSize);
                }
                this.rs = ((PreparedStatement)this.stmt).executeQuery();
                if (i > 0) {
                    log.info((Object)("execute sql successfully after retry: " + (i + 1)));
                }
                return;
            }
            catch (Exception e) {
                if (lastException == null || !lastException.getMessage().equals(e.getMessage())) {
                    log.warn((Object)("failed to execute sql: " + this.sql + " - retry: " + (i + 1) + " of " + this.updateDatabaseMaxRetries), (Throwable)e);
                } else {
                    log.warn((Object)("failed to execute sql: " + this.sql + ", got the same exception as above - retry: " + (i + 1) + " of " + this.updateDatabaseMaxRetries));
                }
                lastException = e;
                this.close();
                try {
                    Thread.sleep(this.updateDatabaseRetryInterval);
                }
                catch (InterruptedException e1) {
                    log.warn((Object)e1);
                }
                try {
                    this.open();
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                continue;
            }
        }
        throw (SQLException)new SQLException("give up executing SQL statement after all retries: " + this.sql).initCause(lastException);
    }

    public boolean next() throws SQLException {
        if (this.rs == null) {
            throw new IllegalStateException();
        }
        return this.rs.next();
    }

    public void close() {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.rs = null;
        }
        super.close();
    }
}

