/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.jdbc;

import java.sql.SQLException;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.dict.Tags;
import org.dcm4chex.archive.ejb.jdbc.BaseReadCmd;
import org.dcm4chex.archive.ejb.jdbc.JdbcProperties;
import org.dcm4chex.archive.ejb.jdbc.SqlBuilder;

public abstract class BaseDSQueryCmd
extends BaseReadCmd {
    protected final Dataset keys;
    protected final SqlBuilder sqlBuilder = new SqlBuilder();
    protected final boolean filterResult;
    protected final boolean type2;

    protected BaseDSQueryCmd(Dataset keys, boolean filterResult, boolean noMatchForNoValue, int transactionIsolationLevel) throws SQLException {
        super(JdbcProperties.getInstance().getDataSource(), transactionIsolationLevel);
        this.keys = keys;
        this.filterResult = filterResult;
        this.type2 = !noMatchForNoValue;
    }

    public void execute() throws SQLException {
        try {
            this.execute(this.sqlBuilder.getSql());
        }
        catch (RuntimeException re) {
            this.close();
            throw re;
        }
    }

    protected void adjustDataset(Dataset ds, Dataset keys) {
        for (DcmElement key : keys) {
            int tag = key.tag();
            if (tag == 524293 || Tags.isPrivate((int)tag)) continue;
            int vr = key.vr();
            DcmElement el = ds.get(tag);
            if (el == null) {
                ds.putXX(tag, vr);
                continue;
            }
            if (vr != 21329) continue;
            DcmElement filteredEl = null;
            Dataset keyItem = key.getItem();
            if (keyItem == null) continue;
            if (el.isEmpty()) {
                el.addNewItem();
            } else if (this.filterResult && !keyItem.isEmpty()) {
                filteredEl = ds.putSQ(tag);
            }
            int n = el.countItems();
            for (int i = 0; i < n; ++i) {
                Dataset item = el.getItem(i);
                this.adjustDataset(item, keyItem);
                if (filteredEl == null) continue;
                item = item.subSet(keyItem);
                filteredEl.addItem(item);
            }
        }
    }
}

