/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.jdbc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.dcm4che.util.SystemUtils;
import org.dcm4chex.archive.ejb.jdbc.JdbcProperties;
import org.dcm4chex.archive.exceptions.ConfigurationException;
import org.jboss.resource.adapter.jdbc.WrappedStatement;

public abstract class BaseCmd {
    protected static final Logger log = Logger.getLogger(BaseCmd.class);
    protected static final Method defineColumnType;
    protected DataSource ds;
    protected Connection con;
    protected Statement stmt;
    protected int prevLevel = 0;
    protected String sql = null;
    protected int transactionIsolationLevel;
    protected int updateDatabaseMaxRetries = 20;
    protected long updateDatabaseRetryInterval = 500L;
    protected final int resultSetType;
    protected final int resultSetConcurrency = 1007;

    protected BaseCmd(String dsJndiName, int transactionIsolationLevel, String sql) throws SQLException {
        this(dsJndiName, transactionIsolationLevel, sql, 1003);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseCmd(String dsJndiName, int transactionIsolationLevel, String sql, int resultSetType) throws SQLException {
        this.sql = sql;
        this.transactionIsolationLevel = transactionIsolationLevel;
        this.resultSetType = resultSetType;
        if (sql != null) {
            log.debug((Object)("SQL: " + sql));
        }
        try {
            InitialContext jndiCtx = new InitialContext();
            try {
                this.ds = (DataSource)jndiCtx.lookup(dsJndiName);
            }
            finally {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
        catch (NamingException ne) {
            throw new RuntimeException("Failed to access Data Source: " + dsJndiName, ne);
        }
        this.open();
    }

    public static String transactionIsolationLevelAsString(int level) {
        switch (level) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "READ_UNCOMMITTED";
            }
            case 2: {
                return "READ_COMMITTED";
            }
            case 4: {
                return "REPEATABLE_READ";
            }
            case 8: {
                return "SERIALIZABLE";
            }
        }
        throw new IllegalArgumentException("level:" + level);
    }

    public static int transactionIsolationLevelOf(String s) {
        String uc = s.trim().toUpperCase();
        if ("READ_UNCOMMITTED".equals(uc)) {
            return 1;
        }
        if ("READ_COMMITTED".equals(uc)) {
            return 2;
        }
        if ("REPEATABLE_READ".equals(uc)) {
            return 4;
        }
        if ("SERIALIZABLE".equals(uc)) {
            return 8;
        }
        return 0;
    }

    protected void defineColumnTypes(int[] types) throws SQLException {
        if (defineColumnType == null) {
            return;
        }
        try {
            WrappedStatement wstmt = (WrappedStatement)this.stmt;
            Statement oracleStmt = wstmt.getUnderlyingStatement();
            for (int i = 0; i < types.length; ++i) {
                defineColumnType.invoke((Object)oracleStmt, i + 1, types[i]);
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof SQLException) {
                throw (SQLException)cause;
            }
            SQLException sqlEx = new SQLException();
            sqlEx.initCause(cause);
            throw sqlEx;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void open() throws SQLException {
        Throwable lastException = null;
        for (int i = 0; i < this.updateDatabaseMaxRetries; ++i) {
            try {
                this.con = this.ds.getConnection();
                this.prevLevel = this.con.getTransactionIsolation();
                if (this.transactionIsolationLevel > 0) {
                    this.con.setTransactionIsolation(this.transactionIsolationLevel);
                }
                this.stmt = this.sql != null ? this.con.prepareStatement(this.sql, this.resultSetType, 1007) : this.con.createStatement(this.resultSetType, 1007);
                if (i > 0) {
                    log.info((Object)("open connection successfully after retries: " + (i + 1)));
                }
                return;
            }
            catch (Exception e) {
                if (lastException == null || !lastException.getMessage().equals(e.getMessage())) {
                    log.warn((Object)("failed to open connection - retry: " + (i + 1) + " of " + this.updateDatabaseMaxRetries), (Throwable)e);
                } else {
                    log.warn((Object)("failed to open connection: got the same exception as above - retry: " + (i + 1) + " of " + this.updateDatabaseMaxRetries));
                }
                lastException = e;
                this.close();
                try {
                    Thread.sleep(this.updateDatabaseRetryInterval);
                }
                catch (InterruptedException e1) {
                    log.warn((Object)e1);
                }
                continue;
            }
        }
        throw new SQLException("give up openning connection after all retries");
    }

    public void close() {
        if (this.stmt != null) {
            try {
                this.stmt.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
            this.stmt = null;
        }
        if (this.con != null) {
            try {
                this.con.setTransactionIsolation(this.prevLevel);
            }
            catch (SQLException ignore) {
                // empty catch block
            }
            try {
                this.con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.con = null;
        }
    }

    public final int getUpdateDatabaseMaxRetries() {
        return this.updateDatabaseMaxRetries;
    }

    public final void setUpdateDatabaseMaxRetries(int updateDatabaseMaxRetries) {
        this.updateDatabaseMaxRetries = updateDatabaseMaxRetries;
    }

    public final long getUpdateDatabaseRetryInterval() {
        return this.updateDatabaseRetryInterval;
    }

    public final void setUpdateDatabaseRetryInterval(long interval) {
        this.updateDatabaseRetryInterval = interval;
    }

    static {
        if (JdbcProperties.getInstance().getDatabase() == 4 && Boolean.valueOf(SystemUtils.getSystemProperty((String)"enabledOracleDefinedColumnType", (String)"true")).booleanValue()) {
            try {
                Class<?> clazz = Class.forName("oracle.jdbc.OracleStatement");
                defineColumnType = clazz.getMethod("defineColumnType", Integer.TYPE, Integer.TYPE);
            }
            catch (Exception e) {
                throw new ConfigurationException((Throwable)e);
            }
        } else {
            defineColumnType = null;
        }
    }
}

