/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.jdbc;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4chex.archive.common.PIDWithIssuer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AdjustPatientID {
    private final Pattern pidPattern;
    private final String requestedIssuer;
    private final boolean includeOtherPIDs;
    private final Set<PIDWithIssuer> pidWithIssuers;

    public AdjustPatientID(Dataset keys, Set<PIDWithIssuer> pidWithIssuers) {
        this.includeOtherPIDs = keys.contains(0x101002);
        this.pidPattern = this.toPattern(keys.getString(0x100020));
        this.requestedIssuer = keys.getString(0x100021);
        this.pidWithIssuers = new HashSet<PIDWithIssuer>(pidWithIssuers);
    }

    private Pattern toPattern(String pid) {
        if (pid == null || pid.equals("*")) {
            return null;
        }
        StringBuilder regex = new StringBuilder();
        StringTokenizer stk = new StringTokenizer(pid, "*?", true);
        while (stk.hasMoreTokens()) {
            String tk = stk.nextToken();
            if (tk.equals("*")) {
                regex.append(".*");
                continue;
            }
            if (tk.equals("?")) {
                regex.append('.');
                continue;
            }
            regex.append("\\Q").append(tk).append("\\E");
        }
        return Pattern.compile(regex.toString());
    }

    public void adjust(Dataset ds) {
        String pid = ds.getString(0x100020);
        String issuer = ds.getString(0x100021);
        this.pidWithIssuers.add(new PIDWithIssuer(pid, issuer));
        DcmElement opidsq = ds.get(0x101002);
        if (opidsq != null) {
            int n = opidsq.countItems();
            for (int i = 0; i < n; ++i) {
                Dataset item = opidsq.getItem(i);
                this.pidWithIssuers.add(new PIDWithIssuer(item.getString(0x100020), item.getString(0x100021)));
            }
            ds.remove(0x101002);
        }
        ds.putLO(0x100020);
        ds.putLO(0x100021, this.requestedIssuer);
        boolean foundMatching = false;
        for (PIDWithIssuer pwi : this.pidWithIssuers) {
            if (foundMatching || !this.matchIssuer(pwi.issuer) || !this.matchPID(pwi.pid)) {
                this.addOtherPatientID(ds, pwi.pid, pwi.issuer);
                continue;
            }
            ds.putLO(0x100020, pwi.pid);
            ds.putLO(0x100021, pwi.issuer);
            foundMatching = true;
        }
    }

    private boolean matchPID(String pid) {
        return this.pidPattern == null || pid == null || this.pidPattern.matcher(pid).matches();
    }

    private boolean matchIssuer(String issuer) {
        return this.requestedIssuer == null || issuer == null || this.requestedIssuer.equals(issuer);
    }

    private void addOtherPatientID(Dataset ds, String pid, String issuer) {
        if (!this.includeOtherPIDs) {
            return;
        }
        DcmElement opidsq = ds.get(0x101002);
        if (opidsq == null) {
            opidsq = ds.putSQ(0x101002);
        }
        Dataset item = opidsq.addNewItem();
        item.putLO(0x100020, pid);
        item.putLO(0x100021, issuer);
    }
}

