/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.giop.GIOPConnectionManager;
import org.jacorb.orb.giop.MessageReceptorPool;
import org.jacorb.orb.giop.NoBiDirServerReplyListener;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.ServerGIOPConnection;
import org.jacorb.orb.giop.ServerRequestListener;
import org.jacorb.orb.giop.TransportManager;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPListener;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.poa.except.ParentIsHolding;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.ETF.Connection;
import org.omg.ETF.Factories;
import org.omg.ETF.Listener;
import org.omg.ETF.Profile;
import org.omg.ETF._HandleLocalBase;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.WrongAdapter;

public class BasicAdapter
extends _HandleLocalBase
implements Configurable {
    private final List listeners = new ArrayList();
    private MessageReceptorPool receptor_pool = null;
    private final ServerRequestListener request_listener;
    private ReplyListener reply_listener = null;
    private final TransportManager transport_manager;
    private final GIOPConnectionManager giop_connection_manager;
    private org.jacorb.config.Configuration configuration = null;
    private Logger logger = null;
    private final ORB orb;

    BasicAdapter(ORB oRB, org.jacorb.poa.POA pOA, TransportManager transportManager, GIOPConnectionManager gIOPConnectionManager) {
        this.orb = oRB;
        this.transport_manager = transportManager;
        this.giop_connection_manager = gIOPConnectionManager;
        this.request_listener = new ServerRequestListener(oRB, pOA);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)configuration;
        this.logger = this.configuration.getNamedLogger("jacorb.orb.basic");
        this.receptor_pool = new MessageReceptorPool("server", "ServerMessageReceptor", configuration);
        this.request_listener.configure(this.configuration);
        this.reply_listener = new NoBiDirServerReplyListener();
        Iterator iterator = this.getListenerFactories().iterator();
        while (iterator.hasNext()) {
            Factories factories = (Factories)iterator.next();
            Listener listener = factories.create_listener(null, 0, (short)0);
            listener.set_handle(this);
            this.listeners.add(listener);
        }
        iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((Listener)iterator.next()).listen();
        }
    }

    private List getListenerFactories() {
        ArrayList<Factories> arrayList = new ArrayList<Factories>();
        List list = this.configuration.getAttributeList("jacorb.transport.server.listeners");
        if (list.isEmpty()) {
            arrayList.addAll(this.transport_manager.getFactoriesList());
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                int n = -1;
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("could not parse profile tag for listener: " + string + " (should have been a number)");
                }
                Factories factories = this.transport_manager.getFactories(n);
                if (factories == null) {
                    throw new IllegalArgumentException("could not find Factories for profile tag: " + n);
                }
                arrayList.add(factories);
            }
        }
        return arrayList;
    }

    public RequestListener getRequestListener() {
        return this.request_listener;
    }

    public List getEndpointProfiles() {
        ArrayList<Profile> arrayList = new ArrayList<Profile>();
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            Listener listener = (Listener)iterator.next();
            arrayList.add(listener.endpoint());
        }
        return arrayList;
    }

    private IIOPListener getIIOPListener() {
        if (this.listeners.size() == 1) {
            Listener listener = (Listener)this.listeners.get(0);
            if (listener instanceof IIOPListener) {
                return (IIOPListener)listener;
            }
            return null;
        }
        return null;
    }

    public int getPort() {
        IIOPListener iIOPListener = this.getIIOPListener();
        if (iIOPListener != null) {
            IIOPProfile iIOPProfile = (IIOPProfile)iIOPListener.endpoint();
            return ((IIOPAddress)iIOPProfile.getAddress()).getPort();
        }
        throw new RuntimeException("Cannot find server port for non-IIOP transport");
    }

    public int getSSLPort() {
        IIOPListener iIOPListener = this.getIIOPListener();
        if (iIOPListener != null) {
            return ((IIOPProfile)iIOPListener.endpoint()).getSSLPort();
        }
        throw new RuntimeException("Non-IIOP transport does not have an SSL port");
    }

    public boolean hasSSLListener() {
        return this.getSSLPort() != -1;
    }

    public String getAddress() {
        IIOPListener iIOPListener = this.getIIOPListener();
        if (iIOPListener != null) {
            IIOPProfile iIOPProfile = (IIOPProfile)iIOPListener.endpoint();
            return ((IIOPAddress)iIOPProfile.getAddress()).getHostname();
        }
        throw new RuntimeException("Cannot find server address for non-IIOP transport");
    }

    public void deliverRequest(ServerRequest serverRequest, POA pOA) {
        org.jacorb.poa.POA pOA2 = (org.jacorb.poa.POA)pOA;
        String[] stringArray = serverRequest.remainingPOAName();
        try {
            for (int i = 0; i < stringArray.length - 1; ++i) {
                if (stringArray[i].equals("")) {
                    serverRequest.setRemainingPOAName(null);
                    break;
                }
                try {
                    pOA2 = pOA2._getChildPOA(stringArray[i]);
                    continue;
                }
                catch (ParentIsHolding parentIsHolding) {
                    String[] stringArray2 = new String[stringArray.length - i];
                    for (int j = 0; j < i; ++j) {
                        stringArray2[j] = stringArray[j + i];
                    }
                    serverRequest.setRemainingPOAName(stringArray2);
                    break;
                }
            }
            if (pOA2 == null) {
                throw new INTERNAL("Request POA null!");
            }
            pOA2._invoke(serverRequest);
        }
        catch (WrongAdapter wrongAdapter) {
            serverRequest.setSystemException(new OBJECT_NOT_EXIST("unknown oid"));
            serverRequest.reply();
        }
        catch (SystemException systemException) {
            serverRequest.setSystemException(systemException);
            serverRequest.reply();
        }
        catch (RuntimeException runtimeException) {
            serverRequest.setSystemException(new UNKNOWN(runtimeException.toString()));
            serverRequest.reply();
            this.logger.warn("unexpected exception", (Throwable)runtimeException);
        }
        catch (Throwable throwable) {
            serverRequest.setSystemException(new UNKNOWN(throwable.toString()));
            serverRequest.reply();
            this.logger.error("unexpected exception", throwable);
        }
    }

    public void return_result(ServerRequest serverRequest) {
        serverRequest.reply();
    }

    public void stopListeners() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((Listener)iterator.next()).destroy();
        }
        this.receptor_pool.shutdown();
    }

    public void renewSSLServerSockets() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof IIOPListener)) continue;
            ((IIOPListener)e).renewSSLServerSocket();
        }
    }

    public boolean add_input(Connection connection) {
        ServerGIOPConnection serverGIOPConnection = this.giop_connection_manager.createServerGIOPConnection(connection.get_server_profile(), connection, this.request_listener, this.reply_listener);
        this.receptor_pool.connectionCreated(serverGIOPConnection);
        return true;
    }

    public void closed_by_peer(Connection connection) {
        throw new NO_IMPLEMENT();
    }

    public void signal_data_available(Connection connection) {
        throw new NO_IMPLEMENT();
    }

    public ORB getORB() {
        return this.orb;
    }
}

