/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.swarm.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.security.actions.Access;
import org.apache.wicket.security.actions.ActionFactory;
import org.apache.wicket.security.actions.Actions;
import org.apache.wicket.security.actions.AllActions;
import org.apache.wicket.security.actions.Enable;
import org.apache.wicket.security.actions.Inherit;
import org.apache.wicket.security.actions.RegistrationException;
import org.apache.wicket.security.actions.Render;
import org.apache.wicket.security.actions.WaspAction;
import org.apache.wicket.security.actions.WaspActionFactory;
import org.apache.wicket.security.swarm.actions.SwarmAction;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwarmActionFactory
implements WaspActionFactory {
    private static final Logger log = LoggerFactory.getLogger(SwarmActionFactory.class);
    protected static final int maxAssingableAction = (int)Math.pow(2.0, 30.0);
    private Map<Integer, String> stringValues = new HashMap<Integer, String>(10);
    private Map<String, SwarmAction> cachedStringActions = new HashMap<String, SwarmAction>();
    private Map<Integer, SwarmAction> cachedIntActions = new HashMap<Integer, SwarmAction>();
    private Map<Integer, SwarmAction> registeredIntActions = new HashMap<Integer, SwarmAction>();
    private Map<Class<? extends WaspAction>, SwarmAction> registeredClassActions = new HashMap<Class<? extends WaspAction>, SwarmAction>();
    private int power = -1;
    private int maxAction = 0;
    private final Object factoryKey;

    public SwarmActionFactory(Object key) {
        this.factoryKey = key;
        Actions.registerActionFactory((Object)key, (ActionFactory)this);
        try {
            this.register(Access.class, "access");
            this.register(Inherit.class, "inherit");
            this.register(Render.class, "render");
            this.register(Enable.class, new ImpliesOtherAction("enable", this, (Class<? extends WaspAction>)Render.class));
        }
        catch (RegistrationException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public WaspAction getAction(Action action) {
        if (action != null) {
            try {
                return this.getAction(action.getName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public WaspAction getAction(String actions) {
        String saveActions = this.convertWicket2Wasp(actions);
        SwarmAction sa = this.getCachedAction(saveActions);
        if (sa == null) {
            int actionValues = this.parseActions(saveActions);
            String nameValues = this.buildActionString(actionValues);
            sa = new SwarmAction(actionValues, nameValues, this.getFactoryKey());
            this.cacheAction(saveActions, sa);
        }
        return sa;
    }

    protected final synchronized void cacheAction(String name, SwarmAction action) {
        this.cachedStringActions.put(name, action);
    }

    protected final synchronized SwarmAction getCachedAction(String name) {
        return this.cachedStringActions.get(name);
    }

    public SwarmAction getAction(int actions) {
        SwarmAction ja = this.getCachedAction(actions);
        if (ja == null) {
            if (actions > this.maxAction) {
                throw new IllegalArgumentException("Max value for actions = " + this.maxAction + ", you used " + actions);
            }
            if (actions < 0) {
                throw new IllegalArgumentException("Min value for actions = 0, you used " + actions);
            }
            ja = new SwarmAction(actions, this.buildActionString(actions), this.getFactoryKey());
            this.cacheAction(new Integer(actions), ja);
        }
        return ja;
    }

    protected final synchronized void cacheAction(Integer actions, SwarmAction ja) {
        this.cachedIntActions.put(actions, ja);
    }

    protected final synchronized SwarmAction getCachedAction(int actions) {
        return this.cachedIntActions.get(actions);
    }

    protected final String valueOf(Integer action) {
        return this.stringValues.get(action);
    }

    protected String buildActionString(int actions) {
        AppendingStringBuffer buff = new AppendingStringBuffer(this.power > 0 ? 10 * this.power : 10);
        for (int i = -1; i < this.power; ++i) {
            this.appendActionString(buff, actions, this.registeredIntActions.get(i).actions());
        }
        if (buff.length() > 0) {
            buff.delete(buff.length() - 2, buff.length());
        }
        return buff.toString();
    }

    protected final void appendActionString(AppendingStringBuffer buff, int actions, int waspAction) {
        if (this.implies(actions, waspAction)) {
            buff.append(this.valueOf(new Integer(waspAction))).append(", ");
        }
    }

    protected final boolean implies(int actions, int action) {
        return (actions & action) == action;
    }

    protected int parseActions(String actions) {
        int sum = 0;
        if (actions != null) {
            String[] actionz = actions.split(",");
            String action = null;
            Set<Integer> keys = this.stringValues.keySet();
            for (int i = 0; i < actionz.length && !(action = actionz[i].trim()).equals(""); ++i) {
                if (action.equals("all")) {
                    return this.getAction(AllActions.class).actions();
                }
                boolean found = false;
                for (Integer key : keys) {
                    if (!action.equalsIgnoreCase(this.valueOf(key))) continue;
                    sum |= key.intValue();
                    found = true;
                    break;
                }
                if (found) continue;
                throw new IllegalArgumentException("Invalid action: " + action + " in: " + actions);
            }
        }
        return sum;
    }

    public synchronized SwarmAction getAction(Class<? extends WaspAction> waspActionClass) {
        if (AllActions.class.isAssignableFrom(waspActionClass)) {
            SwarmAction all = this.registeredClassActions.get(Access.class);
            for (SwarmAction action : this.registeredClassActions.values()) {
                all = all.add((WaspAction)action);
            }
            return all;
        }
        SwarmAction action = this.registeredClassActions.get(waspActionClass);
        if (action == null) {
            throw new IllegalArgumentException("" + waspActionClass + " is not registered");
        }
        return action;
    }

    public synchronized SwarmAction register(Class<? extends WaspAction> waspActionClass, String name) throws RegistrationException {
        if (AllActions.class.isAssignableFrom(waspActionClass)) {
            throw new RegistrationException("Can not register 'all' actions");
        }
        SwarmAction temp = this.registeredClassActions.get(waspActionClass);
        if (temp != null) {
            return temp;
        }
        if (WaspAction.class.isAssignableFrom(waspActionClass)) {
            if (this.power > 30) {
                throw new RegistrationException("Can not register more then 32 different actions.");
            }
            int action = this.nextPowerOf2();
            return this.register(waspActionClass, new SwarmAction(action, name, this.getFactoryKey()));
        }
        throw new RegistrationException(waspActionClass + " is not a " + WaspAction.class.getName());
    }

    public final int getNumberOfRegisteredClasses() {
        return this.power + 1;
    }

    protected final int nextPowerOf2() {
        return (int)Math.pow(2.0, this.power);
    }

    protected final String convertWicket2Wasp(String name) {
        if (name == null) {
            return "";
        }
        return name.toLowerCase();
    }

    protected final synchronized SwarmAction register(Class<? extends WaspAction> waspActionClass, SwarmAction action) throws RegistrationException {
        if (AllActions.class.isAssignableFrom(waspActionClass)) {
            throw new RegistrationException("Can not register 'all' actions");
        }
        if (this.power > 30) {
            throw new RegistrationException("Can not register more then 32 different actions.");
        }
        int assignedPowerOf2 = this.nextPowerOf2();
        if (assignedPowerOf2 > maxAssingableAction) {
            throw new RegistrationException("Unable to register an action with a base value greater then " + maxAssingableAction);
        }
        if (assignedPowerOf2 < 0) {
            throw new RegistrationException(assignedPowerOf2 + " is not a positive value");
        }
        Integer powerOf2 = new Integer(action.actions());
        if (!this.implies(powerOf2, assignedPowerOf2)) {
            throw new RegistrationException("Unable to register action '" + action.getName() + "' with value " + powerOf2 + " expected " + assignedPowerOf2 + " or more.");
        }
        this.stringValues.put(powerOf2, action.getName());
        this.registeredIntActions.put(this.power, action);
        this.registeredClassActions.put(waspActionClass, action);
        this.maxAction += assignedPowerOf2;
        ++this.power;
        return action;
    }

    public List<WaspAction> getRegisteredActions() {
        return new ArrayList<SwarmAction>(this.registeredClassActions.values());
    }

    public void destroy() {
        this.power = 31;
        this.maxAction = 0;
        if (this.registeredClassActions != null) {
            this.registeredClassActions.clear();
        }
        if (this.registeredIntActions != null) {
            this.registeredIntActions.clear();
        }
        if (this.cachedStringActions != null) {
            this.cachedStringActions.clear();
        }
        if (this.cachedIntActions != null) {
            this.cachedIntActions.clear();
        }
        if (this.stringValues != null) {
            this.stringValues.clear();
        }
        this.registeredClassActions = null;
        this.registeredIntActions = null;
        this.cachedStringActions = null;
        this.cachedIntActions = null;
        this.stringValues = null;
        Actions.unregisterActionFactory((Object)this.getFactoryKey());
    }

    protected final Object getFactoryKey() {
        return this.factoryKey;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ImpliesOtherAction
    extends SwarmAction {
        private static final long serialVersionUID = 1L;

        public ImpliesOtherAction(String name, SwarmActionFactory factory, Class<? extends WaspAction> otherAction) {
            super(factory.nextPowerOf2() | factory.getAction(otherAction).actions(), name, factory.getFactoryKey());
        }

        public ImpliesOtherAction(String name, SwarmActionFactory factory, Class<? extends WaspAction> ... otherActions) {
            super(factory.nextPowerOf2() | ImpliesOtherAction.bitwiseOr(factory, otherActions), name, factory.getFactoryKey());
        }

        private static final int bitwiseOr(SwarmActionFactory factory, Class<? extends WaspAction>[] otherActions) {
            int result = 0;
            if (otherActions != null) {
                for (Class<? extends WaspAction> action : otherActions) {
                    result |= factory.getAction(action).actions();
                }
            }
            return result;
        }
    }
}

