/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.swarm.actions;

import org.apache.wicket.security.actions.AbstractWaspAction;
import org.apache.wicket.security.actions.ActionFactory;
import org.apache.wicket.security.actions.Actions;
import org.apache.wicket.security.actions.WaspAction;
import org.apache.wicket.security.swarm.actions.SwarmActionFactory;

public class SwarmAction
extends AbstractWaspAction {
    private final int actions;
    private final Object key;

    protected SwarmAction(int action, String name, Object key) {
        super(name);
        this.key = key;
        if (action < 0) {
            throw new IllegalArgumentException(action + " must be >= 0");
        }
        this.actions = action;
    }

    public final boolean implies(int otherActions) {
        return (this.actions & otherActions) == otherActions;
    }

    public final int actions() {
        return this.actions;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof SwarmAction) {
            SwarmAction other = (SwarmAction)((Object)obj);
            return other.actions() == this.actions;
        }
        return false;
    }

    public final int hashCode() {
        int result = 4679;
        result = 37 * result + SwarmAction.class.hashCode();
        result = 37 * result + this.actions;
        return result;
    }

    public final boolean implies(WaspAction other) {
        return other instanceof SwarmAction && this.implies(((SwarmAction)other).actions());
    }

    public final WaspAction add(int otherActions) {
        return this.newInstance(this.actions | otherActions);
    }

    public final SwarmAction add(WaspAction other) {
        if (other instanceof SwarmAction) {
            return this.newInstance(this.actions | ((SwarmAction)other).actions());
        }
        throw new IllegalArgumentException("other must be a SwarmAction");
    }

    public final SwarmAction remove(int otherActions) {
        if (this.implies(otherActions)) {
            return this.newInstance(this.actions - otherActions);
        }
        return this;
    }

    public final WaspAction remove(WaspAction action) {
        if (action instanceof SwarmAction) {
            return this.remove(((SwarmAction)action).actions);
        }
        throw new IllegalArgumentException("action must be a SwarmAction");
    }

    private SwarmAction newInstance(int myActions) {
        return ((SwarmActionFactory)this.getActionFactory()).getAction(myActions);
    }

    public final ActionFactory getActionFactory() {
        return Actions.getActionFactory((Object)this.key);
    }
}

