/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.session;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import org.dcm4chex.archive.ejb.jdbc.AddRoleToUserCmd;
import org.dcm4chex.archive.ejb.jdbc.AddUserCmd;
import org.dcm4chex.archive.ejb.jdbc.QueryPasswordForUserCmd;
import org.dcm4chex.archive.ejb.jdbc.QueryRolesForUserCmd;
import org.dcm4chex.archive.ejb.jdbc.QueryUsersCmd;
import org.dcm4chex.archive.ejb.jdbc.RemoveRoleFromUserCmd;
import org.dcm4chex.archive.ejb.jdbc.RemoveUserCmd;
import org.dcm4chex.archive.ejb.jdbc.UpdatePasswordForUserCmd;

public abstract class UserManagerBean
implements SessionBean {
    private static final String DB_JNDI_NAME = "java:comp/env/jdbc/DS";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getUsers() {
        ArrayList<String> arrayList;
        QueryUsersCmd cmd = new QueryUsersCmd(DB_JNDI_NAME);
        try {
            cmd.execute();
            ArrayList<String> users = new ArrayList<String>();
            while (cmd.next()) {
                users.add(cmd.getUser());
            }
            arrayList = users;
        }
        catch (Throwable throwable) {
            try {
                cmd.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new EJBException((Exception)e);
            }
        }
        cmd.close();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUser(String user, String passwd) {
        try {
            AddUserCmd cmd = new AddUserCmd(DB_JNDI_NAME);
            try {
                cmd.setUser(user);
                cmd.setPassword(passwd);
                cmd.execute();
            }
            finally {
                cmd.close();
            }
        }
        catch (SQLException e) {
            throw new EJBException((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUser(String user, String passwd, Collection roles) {
        try {
            this.addUser(user, passwd);
            AddRoleToUserCmd cmd = new AddRoleToUserCmd(DB_JNDI_NAME);
            try {
                cmd.setUser(user);
                Iterator i = roles.iterator();
                while (i.hasNext()) {
                    cmd.setRole((String)i.next());
                    cmd.execute();
                }
            }
            finally {
                cmd.close();
            }
        }
        catch (SQLException e) {
            throw new EJBException((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUser(String user) {
        boolean bl;
        Collection roles = this.getRolesOfUser(user);
        Iterator i = roles.iterator();
        while (i.hasNext()) {
            this.removeRoleFromUser(user, (String)i.next());
        }
        RemoveUserCmd cmd = new RemoveUserCmd(DB_JNDI_NAME);
        try {
            cmd.setUser(user);
            bl = cmd.execute() != 0;
        }
        catch (Throwable throwable) {
            try {
                cmd.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new EJBException((Exception)e);
            }
        }
        cmd.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPasswordForUser(String user) {
        String string;
        QueryPasswordForUserCmd cmd = new QueryPasswordForUserCmd(DB_JNDI_NAME);
        try {
            cmd.setUser(user);
            cmd.execute();
            string = cmd.next() ? cmd.getPassword() : null;
        }
        catch (Throwable throwable) {
            try {
                cmd.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new EJBException((Exception)e);
            }
        }
        cmd.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPasswordForUser(String user, String passwd) {
        boolean bl;
        UpdatePasswordForUserCmd cmd = new UpdatePasswordForUserCmd(DB_JNDI_NAME);
        try {
            cmd.setUser(user);
            cmd.setPassword(passwd);
            bl = cmd.execute() != 0;
        }
        catch (Throwable throwable) {
            try {
                cmd.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new EJBException((Exception)e);
            }
        }
        cmd.close();
        return bl;
    }

    public boolean changePasswordForUser(String user, String oldPasswd, String newPasswd) {
        if (!this.getPasswordForUser(user).equals(oldPasswd)) {
            return false;
        }
        return this.setPasswordForUser(user, newPasswd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getRolesOfUser(String user) {
        ArrayList<String> arrayList;
        QueryRolesForUserCmd cmd = new QueryRolesForUserCmd(DB_JNDI_NAME);
        try {
            cmd.setUser(user);
            cmd.execute();
            ArrayList<String> roles = new ArrayList<String>();
            while (cmd.next()) {
                roles.add(cmd.getRole());
            }
            arrayList = roles;
        }
        catch (Throwable throwable) {
            try {
                cmd.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new EJBException((Exception)e);
            }
        }
        cmd.close();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRoleToUser(String user, String role) {
        try {
            AddRoleToUserCmd cmd = new AddRoleToUserCmd(DB_JNDI_NAME);
            try {
                cmd.setUser(user);
                cmd.setRole(role);
                cmd.execute();
            }
            finally {
                cmd.close();
            }
        }
        catch (SQLException e) {
            throw new EJBException((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRoleFromUser(String user, String role) {
        boolean bl;
        RemoveRoleFromUserCmd cmd = new RemoveRoleFromUserCmd(DB_JNDI_NAME);
        try {
            cmd.setUser(user);
            cmd.setRole(role);
            bl = cmd.execute() != 0;
        }
        catch (Throwable throwable) {
            try {
                cmd.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new EJBException((Exception)e);
            }
        }
        cmd.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUser(String user, Collection roles) {
        try {
            Collection col = this.getRolesOfUser(user);
            AddRoleToUserCmd cmd = new AddRoleToUserCmd(DB_JNDI_NAME);
            try {
                cmd.setUser(user);
                for (String role : roles) {
                    if (!col.contains(role)) {
                        cmd.setRole(role);
                        cmd.execute();
                        continue;
                    }
                    col.remove(role);
                }
            }
            finally {
                cmd.close();
            }
            RemoveRoleFromUserCmd delCmd = new RemoveRoleFromUserCmd(DB_JNDI_NAME);
            try {
                delCmd.setUser(user);
                Iterator i = col.iterator();
                while (i.hasNext()) {
                    delCmd.setRole((String)i.next());
                    delCmd.execute();
                }
            }
            finally {
                delCmd.close();
            }
        }
        catch (SQLException e) {
            throw new EJBException((Exception)e);
        }
    }
}

