/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.session;

import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.Collection;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.dcm4che.data.Dataset;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocal;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocalHome;
import org.dcm4chex.archive.ejb.interfaces.PatientLocal;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocal;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocalHome;
import org.dcm4chex.archive.ejb.interfaces.StudyLocal;

public abstract class UpdateAttributesBean
implements SessionBean {
    private SeriesLocalHome seriesHome;
    private InstanceLocalHome instHome;

    public void setSessionContext(SessionContext arg0) throws EJBException, RemoteException {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.seriesHome = (SeriesLocalHome)jndiCtx.lookup("java:comp/env/ejb/Series");
            this.instHome = (InstanceLocalHome)jndiCtx.lookup("java:comp/env/ejb/Instance");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetSessionContext() {
        this.seriesHome = null;
        this.instHome = null;
    }

    public Collection seriesIuidsForAttributesUpdate(int availability, String modality, String srcAET, Timestamp updatedAfter, Timestamp updatedBefore, int offset, int limit) {
        try {
            return this.seriesHome.seriesIuidsForAttributesUpdate(availability, modality, srcAET, updatedAfter, updatedBefore, offset, limit);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public int countSeriesForAttributesUpdate(int availability, String modality, String srcAET, Timestamp updatedAfter, Timestamp updatedBefore) {
        try {
            return this.seriesHome.countSeriesForAttributesUpdate(availability, modality, srcAET, updatedAfter, updatedBefore);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public void updateInstanceAttributes(Dataset ds) {
        try {
            InstanceLocal instance = this.instHome.findBySopIuid(ds.getString(524312));
            instance.coerceAttributes(ds, null);
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public void updatePatientStudySeriesAttributes(Dataset ds) {
        try {
            SeriesLocal series = this.seriesHome.findBySeriesIuid(ds.getString(0x20000E));
            StudyLocal study = series.getStudy();
            PatientLocal patient = study.getPatient();
            series.coerceAttributes(ds, null);
            series.setUpdatedTime(new Timestamp(System.currentTimeMillis()));
            study.coerceAttributes(ds, null);
            patient.coerceAttributes(ds, null);
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }
}

