/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.session;

import java.util.Collection;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObject;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.DcmServiceException;
import org.dcm4chex.archive.common.PatientMatching;
import org.dcm4chex.archive.common.UPSState;
import org.dcm4chex.archive.ejb.interfaces.PatientLocal;
import org.dcm4chex.archive.ejb.interfaces.PatientLocalHome;
import org.dcm4chex.archive.ejb.interfaces.UPSGlobalSubscriptionLocal;
import org.dcm4chex.archive.ejb.interfaces.UPSGlobalSubscriptionLocalHome;
import org.dcm4chex.archive.ejb.interfaces.UPSLocal;
import org.dcm4chex.archive.ejb.interfaces.UPSLocalHome;
import org.dcm4chex.archive.ejb.interfaces.UPSSubscriptionLocal;
import org.dcm4chex.archive.ejb.interfaces.UPSSubscriptionLocalHome;
import org.dcm4chex.archive.exceptions.NonUniquePatientException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UPSManagementBean
implements SessionBean {
    private static Logger LOG = Logger.getLogger(UPSManagementBean.class);
    private static final int ALREADY_IN_REQUESTED_STATE = 45828;
    private static final int MAY_NO_LONGER_BE_UPDATED = 49920;
    private static final int CORRECT_TRANSACTION_UID_NOT_PROVIDED = 49921;
    private static final int ALREADY_IN_PROGRESS = 49922;
    private static final int NOT_MET_FINAL_STATE_REQUIREMENTS = 49924;
    private static final int NO_SUCH_UPS = 49927;
    private static final int NOT_IN_PROGRESS = 49936;
    private PatientLocalHome patHome;
    private UPSLocalHome upsHome;
    private UPSSubscriptionLocalHome subsHome;
    private UPSGlobalSubscriptionLocalHome gsubsHome;
    private SessionContext sessionCtx;

    public void setSessionContext(SessionContext ctx) {
        this.sessionCtx = ctx;
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.patHome = (PatientLocalHome)jndiCtx.lookup("java:comp/env/ejb/Patient");
            this.upsHome = (UPSLocalHome)jndiCtx.lookup("java:comp/env/ejb/UPS");
            this.subsHome = (UPSSubscriptionLocalHome)jndiCtx.lookup("java:comp/env/ejb/UPSSubscription");
            this.gsubsHome = (UPSGlobalSubscriptionLocalHome)jndiCtx.lookup("java:comp/env/ejb/UPSGlobalSubscription");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetSessionContext() {
        this.sessionCtx = null;
        this.patHome = null;
        this.upsHome = null;
        this.subsHome = null;
        this.gsubsHome = null;
    }

    public void createUPS(Dataset ds, PatientMatching matching) throws DcmServiceException {
        this.checkDuplicate(ds.getString(524312));
        try {
            UPSLocal ups = this.upsHome.create(ds, ds.containsValue(0x100020) ? this.findOrCreatePatient(ds, matching) : null);
            Collection gSubs = this.gsubsHome.findAll();
            for (UPSGlobalSubscriptionLocal gSub : gSubs) {
                this.subsHome.create(gSub.getReceivingAETitle(), gSub.getDeletionLock(), ups);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Creation of UPS(iuid=" + ds.getString(524312) + ") failed: "), (Throwable)e);
            this.sessionCtx.setRollbackOnly();
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    private void checkDuplicate(String iuid) throws DcmServiceException {
        try {
            this.upsHome.findBySopInstanceUID(iuid);
            this.sessionCtx.setRollbackOnly();
            throw new DcmServiceException(273);
        }
        catch (ObjectNotFoundException e) {
        }
        catch (FinderException e) {
            LOG.error((Object)("Query for UPS(iuid=" + iuid + ") failed: "), (Throwable)e);
            this.sessionCtx.setRollbackOnly();
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    private PatientLocal findOrCreatePatient(Dataset ds, PatientMatching matching) throws DcmServiceException {
        try {
            try {
                return this.patHome.selectPatient(ds, matching, true);
            }
            catch (ObjectNotFoundException enfe) {
                return this.patHome.create(ds);
            }
            catch (NonUniquePatientException onfe) {
                return this.patHome.create(ds);
            }
        }
        catch (Exception e) {
            this.sessionCtx.setRollbackOnly();
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    public Dataset getUPS(String uid) throws DcmServiceException {
        UPSLocal ups = this.findUPS(uid);
        PatientLocal pat = ups.getPatient();
        Dataset attrs = ups.getAttributes();
        if (pat != null) {
            attrs.putAll((DcmObject)pat.getAttributes(false));
        }
        return attrs;
    }

    public int getUPSState(String uid) throws DcmServiceException {
        return this.findUPS(uid).getStateAsInt();
    }

    public boolean updateMatchingUPS(Dataset ds) throws FinderException {
        Collection matchingUPS;
        Dataset refRequest = ds.getItem(4236144);
        if (refRequest == null) {
            return false;
        }
        String rpid = refRequest.getString(0x401001);
        Dataset wkitem = ds.getItem(4210712);
        String codeValue = wkitem.getString(524544);
        String codingSchemeDesignator = wkitem.getString(524546);
        String codingSchemeVersion = wkitem.getString(524547);
        int state = UPSState.toInt((String)ds.getString(7606272));
        Collection collection = matchingUPS = codingSchemeVersion == null ? this.upsHome.findByStateAndRequestedProcedureIdAndWorkItemCode(state, rpid, codeValue, codingSchemeDesignator) : this.upsHome.findByStateAndRequestedProcedureIdAndWorkItemCode(state, rpid, codeValue, codingSchemeDesignator, codingSchemeVersion);
        if (matchingUPS.isEmpty()) {
            return false;
        }
        if (matchingUPS.size() > 1) {
            LOG.info((Object)("More than one UPS (" + codeValue + ", " + codingSchemeDesignator + ", \"" + codingSchemeVersion + "\") with rpid: " + rpid + " found"));
            return false;
        }
        ((UPSLocal)matchingUPS.iterator().next()).updateAttributes(ds);
        return true;
    }

    public void updateUPS(String iuid, Dataset ds) throws DcmServiceException {
        UPSLocal ups = this.findUPS(iuid);
        switch (ups.getStateAsInt()) {
            case 0: {
                if (!ds.contains(528789)) break;
                throw new DcmServiceException(49936);
            }
            case 1: {
                if (ups.getTransactionUID().equals(ds.getString(528789))) break;
                throw new DcmServiceException(49921);
            }
            case 2: 
            case 3: {
                throw new DcmServiceException(49920);
            }
        }
        ups.updateAttributes(ds);
    }

    public Collection<String> getReceivingAETs(String iuid) throws DcmServiceException {
        try {
            return this.subsHome.getReceivingAETs(iuid);
        }
        catch (Exception e) {
            this.sessionCtx.setRollbackOnly();
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    public void setRequestUPSCancelInfo(String iuid, Dataset info) throws DcmServiceException {
        Dataset code;
        if (info.isEmpty()) {
            return;
        }
        UPSLocal ups = this.findUPS(iuid);
        Dataset attrs = ups.getAttributes();
        DcmElement progressInfoSeq = attrs.get(7606274);
        if (progressInfoSeq == null) {
            progressInfoSeq = attrs.putSQ(7606274);
        }
        Dataset progressInfo = progressInfoSeq.isEmpty() ? progressInfoSeq.addNewItem() : progressInfoSeq.getItem();
        String reason = info.getString(7606840);
        if (reason != null) {
            progressInfo.putLT(7606840, reason);
        }
        if ((code = info.getItem(7606286)) != null) {
            progressInfo.putSQ(7606286).addItem(code);
        }
        String contactURI = info.getString(7606282);
        String contactDisplayName = info.getString(7606284);
        if (contactURI != null || contactDisplayName != null) {
            DcmElement sq = progressInfo.get(7606280);
            if (sq == null) {
                sq = attrs.putSQ(7606280);
            }
            Dataset item = sq.addNewItem();
            if (contactURI != null) {
                item.putST(7606282, contactURI);
            }
            if (contactDisplayName != null) {
                item.putLO(7606284, contactDisplayName);
            }
        }
    }

    public Dataset changeUPSState(String iuid, int newState, String tuid) throws DcmServiceException {
        try {
            UPSLocal ups = this.findUPS(iuid);
            int prevState = ups.getStateAsInt();
            if (newState == 1) {
                if (prevState != 0) {
                    throw new DcmServiceException(prevState == 1 ? 49922 : 49920);
                }
                ups.setTransactionUID(tuid);
            } else {
                if (prevState != 1) {
                    throw new DcmServiceException(prevState == newState ? 45828 : 49920);
                }
                if (!tuid.equals(ups.getTransactionUID())) {
                    throw new DcmServiceException(49921);
                }
                if (newState == 2 && !this.meetFinalStateRequirements(ups.getAttributes())) {
                    throw new DcmServiceException(49924);
                }
            }
            ups.updateState(newState);
            Dataset stateReport = this.getUPSStateReport(ups);
            if (newState != 1 && !this.subsHome.hasDeletionLocks(ups)) {
                ups.remove();
            }
            return stateReport;
        }
        catch (DcmServiceException e) {
            throw e;
        }
        catch (Exception e) {
            this.sessionCtx.setRollbackOnly();
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    public Dataset getUPSStateReport(String iuid) throws FinderException {
        return this.getUPSStateReport(this.upsHome.findBySopInstanceUID(iuid));
    }

    private Dataset getUPSStateReport(UPSLocal ups) {
        Dataset stateReport = DcmObjectFactory.getInstance().newDataset();
        stateReport.putCS(7606272, UPSState.toString((int)ups.getStateAsInt()));
        Dataset progressInfo = ups.getAttributes().getItem(7606274);
        if (progressInfo != null) {
            Dataset code;
            String s = progressInfo.getString(7606840);
            if (s != null) {
                stateReport.putLT(7606840, s);
            }
            if ((code = progressInfo.getItem(7606286)) != null) {
                stateReport.putSQ(7606286).addItem(code);
            }
        }
        return stateReport;
    }

    private boolean meetFinalStateRequirements(Dataset ds) {
        DcmElement sq = ds.get(7606806);
        if (sq.isEmpty()) {
            return false;
        }
        int n = sq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset item = sq.getItem(i);
            if (item.containsValue(4210728) && item.containsValue(4210713) && item.containsValue(0x400244) && item.containsValue(4194885) && item.containsValue(4194896) && item.containsValue(4194897)) continue;
            return false;
        }
        return true;
    }

    private UPSLocal findUPS(String iuid) throws DcmServiceException {
        try {
            return this.upsHome.findBySopInstanceUID(iuid);
        }
        catch (ObjectNotFoundException e) {
            throw new DcmServiceException(49927);
        }
        catch (Exception e) {
            this.sessionCtx.setRollbackOnly();
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    public boolean subscribeReceiveUPSEventReports(String iuid, String aet, boolean deletionLock) throws DcmServiceException {
        try {
            try {
                UPSSubscriptionLocal sub = this.subsHome.findByReceivingAETAndUPSInstanceUID(aet, iuid);
                if (deletionLock != sub.getDeletionLock()) {
                    UPSLocal ups;
                    sub.setDeletionLock(deletionLock);
                    if (!deletionLock && !this.subsHome.hasDeletionLocks(ups = sub.getUPS())) {
                        ups.remove();
                    }
                }
                return false;
            }
            catch (ObjectNotFoundException e) {
                this.subsHome.create(aet, deletionLock, this.findUPS(iuid));
                return true;
            }
        }
        catch (Exception e) {
            this.sessionCtx.setRollbackOnly();
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    public Collection<String> subscribeGlobally(String aet, boolean dellock) throws DcmServiceException {
        try {
            try {
                this.gsubsHome.findByReceivingAET(aet).setDeletionLock(dellock);
            }
            catch (ObjectNotFoundException e) {
                this.gsubsHome.create(aet, dellock);
            }
            Collection uids = this.upsHome.getNotSubscribed(aet);
            for (String uid : uids) {
                this.subscribeReceiveUPSEventReports(uid, aet, dellock);
            }
            return uids;
        }
        catch (DcmServiceException e) {
            throw e;
        }
        catch (Exception e) {
            this.sessionCtx.setRollbackOnly();
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    public void unsubscribeReceiveUPSEventReports(String iuid, String aet) throws DcmServiceException {
        try {
            try {
                this.removeSubscription(this.subsHome.findByReceivingAETAndUPSInstanceUID(aet, iuid));
            }
            catch (ObjectNotFoundException e) {
                this.findUPS(iuid);
            }
        }
        catch (DcmServiceException e) {
            throw e;
        }
        catch (Exception e) {
            this.sessionCtx.setRollbackOnly();
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    void removeSubscription(UPSSubscriptionLocal sub) throws Exception {
        boolean dellock = sub.getDeletionLock();
        UPSLocal ups = sub.getUPS();
        sub.remove();
        if (dellock && !this.subsHome.hasDeletionLocks(ups)) {
            ups.remove();
        }
    }

    public void unsubscribeGlobally(String aet) throws DcmServiceException {
        try {
            Collection allSubs = this.subsHome.findByReceivingAET(aet);
            for (UPSSubscriptionLocal sub : allSubs) {
                this.removeSubscription(sub);
            }
            this.suspendGlobalSubscription(aet);
        }
        catch (DcmServiceException e) {
            throw e;
        }
        catch (Exception e) {
            this.sessionCtx.setRollbackOnly();
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    public void suspendGlobalSubscription(String aet) throws DcmServiceException {
        try {
            this.gsubsHome.findByReceivingAET(aet).remove();
        }
        catch (ObjectNotFoundException e) {
        }
        catch (Exception e) {
            this.sessionCtx.setRollbackOnly();
            throw new DcmServiceException(272, (Throwable)e);
        }
    }
}

