/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.session;

import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObject;
import org.dcm4che.net.DcmServiceException;
import org.dcm4chex.archive.common.PatientMatching;
import org.dcm4chex.archive.ejb.interfaces.PatientUpdateLocal;
import org.dcm4chex.archive.ejb.interfaces.PatientUpdateLocalHome;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocal;
import org.dcm4chex.archive.ejb.interfaces.StudyLocal;
import org.dcm4chex.archive.ejb.interfaces.StudyLocalHome;

public abstract class StudyReconciliationBean
implements SessionBean {
    private static final Logger log = Logger.getLogger(StudyReconciliationBean.class);
    private final PatientMatching patientMatching = new PatientMatching("pid,issuer?");
    private StudyLocalHome studyHome;
    private PatientUpdateLocal patientUpdate;

    public void setSessionContext(SessionContext arg0) throws EJBException, RemoteException {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.studyHome = (StudyLocalHome)jndiCtx.lookup("java:comp/env/ejb/Study");
            this.patientUpdate = ((PatientUpdateLocalHome)jndiCtx.lookup("java:comp/env/ejb/PatientUpdate")).create();
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetSessionContext() {
        this.studyHome = null;
    }

    private StudyLocal getStudy(String suid) throws FinderException, DcmServiceException {
        try {
            return this.studyHome.findByStudyIuid(suid);
        }
        catch (ObjectNotFoundException e) {
            throw new DcmServiceException(280, suid);
        }
    }

    public Collection getStudyIuidsWithStatus(int status, Timestamp createdBefore, int limit) throws FinderException {
        Collection col = this.studyHome.findStudiesWithStatus(status, createdBefore, limit);
        ArrayList<String> studyIuids = new ArrayList<String>();
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            studyIuids.add(((StudyLocal)iter.next()).getStudyIuid());
        }
        return studyIuids;
    }

    public void updateStatus(Collection studyIuids, int status) throws FinderException, DcmServiceException {
        if (studyIuids == null) {
            return;
        }
        Iterator iter = studyIuids.iterator();
        while (iter.hasNext()) {
            this.getStudy((String)iter.next()).setStudyStatus(status);
        }
    }

    public void updateStatus(String studyIuid, int status) throws FinderException, DcmServiceException {
        if (studyIuid == null) {
            return;
        }
        this.getStudy(studyIuid).setStudyStatus(status);
    }

    public void updatePatient(Dataset attrs) throws FinderException, CreateException {
        this.patientUpdate.updatePatient(attrs, this.patientMatching);
    }

    public void mergePatient(Dataset dominant, Dataset prior, boolean keepPrior) throws FinderException, CreateException, EJBException, RemoveException {
        this.patientUpdate.mergePatient(dominant, prior, this.patientMatching, keepPrior);
    }

    public void updateStudyAndSeries(String studyIuid, int studyStatus, Map map) throws FinderException, DcmServiceException {
        if (studyIuid == null) {
            return;
        }
        StudyLocal study = this.getStudy(studyIuid);
        study.setStudyStatus(studyStatus);
        if (map != null && !map.isEmpty()) {
            Dataset dsOrig;
            Dataset ds;
            Iterator iter = study.getSeries().iterator();
            do {
                SeriesLocal sl = (SeriesLocal)iter.next();
                ds = sl.getAttributes(false);
                dsOrig = (Dataset)map.get(sl.getSeriesIuid());
                ds.putAll((DcmObject)dsOrig);
                sl.setAttributes(ds);
            } while (iter.hasNext());
            ds = study.getAttributes(false);
            ds.putAll((DcmObject)dsOrig);
            study.setAttributes(ds);
            study.updateModalitiesInStudy();
            study.updateSOPClassesInStudy();
        }
    }
}

