/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.session;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.FileMetaInfo;
import org.dcm4che.net.DcmServiceException;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.common.Availability;
import org.dcm4chex.archive.common.PatientMatching;
import org.dcm4chex.archive.common.SeriesStored;
import org.dcm4chex.archive.ejb.interfaces.FileLocal;
import org.dcm4chex.archive.ejb.interfaces.FileLocalHome;
import org.dcm4chex.archive.ejb.interfaces.FileSystemLocal;
import org.dcm4chex.archive.ejb.interfaces.FileSystemLocalHome;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocal;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocalHome;
import org.dcm4chex.archive.ejb.interfaces.PatientLocal;
import org.dcm4chex.archive.ejb.interfaces.PatientLocalHome;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocal;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocalHome;
import org.dcm4chex.archive.ejb.interfaces.StudyLocal;
import org.dcm4chex.archive.ejb.interfaces.StudyLocalHome;
import org.dcm4chex.archive.ejb.interfaces.StudyOnFileSystemLocalHome;
import org.dcm4chex.archive.ejb.session.UpdateDerivedFieldsUtils;
import org.dcm4chex.archive.exceptions.NonUniquePatientException;
import org.dcm4chex.archive.exceptions.NonUniquePatientIDException;

public abstract class StorageBean
implements SessionBean {
    public static final int STORED = 0;
    public static final int RECEIVED = 1;
    private static Logger log = Logger.getLogger(StorageBean.class);
    private PatientLocalHome patHome;
    private StudyLocalHome studyHome;
    private SeriesLocalHome seriesHome;
    private InstanceLocalHome instHome;
    private FileLocalHome fileHome;
    private FileSystemLocalHome fileSystemHome;
    private StudyOnFileSystemLocalHome sofHome;
    private SessionContext sessionCtx;
    private static final int MAX_PK_CACHE_ENTRIES = 100;
    private static Map seriesPkCache = Collections.synchronizedMap(new LinkedHashMap(){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 100;
        }
    });

    public void setSessionContext(SessionContext ctx) {
        this.sessionCtx = ctx;
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.patHome = (PatientLocalHome)jndiCtx.lookup("java:comp/env/ejb/Patient");
            this.studyHome = (StudyLocalHome)jndiCtx.lookup("java:comp/env/ejb/Study");
            this.seriesHome = (SeriesLocalHome)jndiCtx.lookup("java:comp/env/ejb/Series");
            this.instHome = (InstanceLocalHome)jndiCtx.lookup("java:comp/env/ejb/Instance");
            this.fileHome = (FileLocalHome)jndiCtx.lookup("java:comp/env/ejb/File");
            this.fileSystemHome = (FileSystemLocalHome)jndiCtx.lookup("java:comp/env/ejb/FileSystem");
            this.sofHome = (StudyOnFileSystemLocalHome)jndiCtx.lookup("java:comp/env/ejb/StudyOnFileSystem");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetSessionContext() {
        this.sessionCtx = null;
        this.patHome = null;
        this.studyHome = null;
        this.seriesHome = null;
        this.instHome = null;
        this.fileHome = null;
        this.fileSystemHome = null;
        this.sofHome = null;
    }

    public Dataset store(Dataset ds, long fspk, String fileid, long size, byte[] md5, boolean updateStudyAccessTime, PatientMatching matching) throws DcmServiceException, NonUniquePatientIDException {
        return this.store(ds, fspk, fileid, size, md5, updateStudyAccessTime, matching, true);
    }

    public Dataset store(Dataset ds, long fspk, String fileid, long size, byte[] md5, boolean updateStudyAccessTime, PatientMatching matching, boolean canRollback) throws DcmServiceException, NonUniquePatientIDException {
        FileMetaInfo fmi = ds.getFileMetaInfo();
        String iuid = fmi.getMediaStorageSOPInstanceUID();
        String cuid = fmi.getMediaStorageSOPClassUID();
        String tsuid = fmi.getTransferSyntaxUID();
        log.info((Object)("inserting instance " + fmi));
        try {
            InstanceLocal instance;
            Dataset coercedElements = DcmObjectFactory.getInstance().newDataset();
            int prevAvailability = 3;
            try {
                instance = this.instHome.findBySopIuid(iuid);
                prevAvailability = instance.getAvailabilitySafe();
                this.coerceInstanceIdentity(instance, ds, coercedElements);
            }
            catch (ObjectNotFoundException onfe) {
                instance = this.instHome.create(ds, this.getSeries(matching, ds, coercedElements));
            }
            if (fspk != -1L) {
                FileSystemLocal fs = this.fileSystemHome.findByPrimaryKey(new Long(fspk));
                FileLocal file = this.fileHome.create(fileid, tsuid, size, md5, 0, instance, fs);
                instance.setAvailability(Math.min(fs.getAvailability(), prevAvailability));
                instance.addRetrieveAET(fs.getRetrieveAET());
                if (updateStudyAccessTime) {
                    this.touchStudyOnFileSystem(ds.getString(0x20000D), fs);
                }
            } else {
                instance.setAvailability(Availability.toInt((String)ds.getString(524374)));
                instance.setExternalRetrieveAET(ds.getString(524372));
            }
            instance.setInstanceStatus(1);
            instance.getSeries().setSeriesStatus(1);
            log.info((Object)("inserted records for instance[uid=" + iuid + "]"));
            return coercedElements;
        }
        catch (Exception e) {
            log.warn((Object)("inserting records for instance[uid=" + iuid + "] failed: " + e.getMessage()));
            if (canRollback) {
                this.sessionCtx.setRollbackOnly();
            }
            if (e instanceof NonUniquePatientIDException) {
                throw (NonUniquePatientIDException)e;
            }
            if (e instanceof DcmServiceException) {
                throw (DcmServiceException)((Object)e);
            }
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    private void touchStudyOnFileSystem(String siud, FileSystemLocal fs) throws FinderException, CreateException {
        String dirPath = fs.getDirectoryPath();
        try {
            this.sofHome.findByStudyAndFileSystem(siud, dirPath).touch();
        }
        catch (ObjectNotFoundException e) {
            try {
                this.sofHome.create(this.studyHome.findByStudyIuid(siud), fs);
            }
            catch (Exception ignore) {
                log.info((Object)"Create StudyOnFS failed! Check if concurrent create.", (Throwable)ignore);
                this.sofHome.findByStudyAndFileSystem(siud, dirPath).touch();
            }
        }
    }

    public SeriesStored makeSeriesStored(String seriuid) throws FinderException {
        return this.makeSeriesStored(this.findBySeriesIuid(seriuid));
    }

    public void commitSeriesStored(SeriesStored seriesStored) throws FinderException {
        Dataset ian = seriesStored.getIAN();
        Dataset refSeries = ian.get(528661).getItem(0);
        DcmElement refSOPs = refSeries.get(528793);
        int numI = refSOPs.countItems();
        HashSet<String> iuids = new HashSet<String>(numI * 4 / 3 + 1);
        for (int i = 0; i < numI; ++i) {
            iuids.add(refSOPs.getItem(i).getString(528725));
        }
        String seriuid = refSeries.getString(0x20000E);
        SeriesLocal series = this.findBySeriesIuid(seriuid);
        Collection c = series.getInstances();
        int remaining = 0;
        for (InstanceLocal inst : c) {
            if (inst.getInstanceStatus() != 1) continue;
            if (iuids.remove(inst.getSopIuid())) {
                inst.setInstanceStatus(0);
                continue;
            }
            ++remaining;
        }
        if (remaining == 0) {
            series.setSeriesStatus(0);
        }
    }

    public Collection getPksOfPendingSeries(Timestamp updatedBefore) throws FinderException {
        return this.seriesHome.getSeriesPksWithStatusAndUpdatedBefore(1, updatedBefore);
    }

    public SeriesStored makeSeriesStored(Long seriesPk, Timestamp updatedBefore) throws FinderException {
        SeriesLocal series = this.seriesHome.findByPrimaryKey(seriesPk);
        Timestamp lastUpdated = series.getMaxUpdatedTimeOfSeriesRelatedInstances();
        return lastUpdated != null && lastUpdated.before(updatedBefore) ? this.makeSeriesStored(series) : null;
    }

    private SeriesStored makeSeriesStored(SeriesLocal series) throws FinderException {
        StudyLocal study = series.getStudy();
        PatientLocal pat = study.getPatient();
        if (pat == null) {
            log.warn((Object)("Failed: SeriesStored for series " + series.getSeriesIuid() + " (pk=" + series.getPk() + ") Reason: Missing reference to a patient! Study iuid:" + study.getStudyIuid()));
            return null;
        }
        UpdateDerivedFieldsUtils.updateDerivedFieldsOf(series);
        UpdateDerivedFieldsUtils.updateDerivedFieldsOf(study);
        Dataset ian = DcmObjectFactory.getInstance().newDataset();
        ian.putUI(0x20000D, study.getStudyIuid());
        Dataset refSeries = ian.putSQ(528661).addNewItem();
        DcmElement refSOPs = refSeries.putSQ(528793);
        refSeries.putUI(0x20000E, series.getSeriesIuid());
        HashSet<String> commonRetrieveAETs = null;
        Collection c = series.getInstances();
        for (InstanceLocal inst : c) {
            if (inst.getInstanceStatus() != 1) continue;
            String[] retrieveAETs = StringUtils.split((String)inst.getRetrieveAETs(), (char)'\\');
            if (retrieveAETs == null) {
                log.debug((Object)("Use SeriesStored without local file for series " + series.getSeriesIuid() + " (pk=" + series.getPk() + ") Reason: Found Instance with status RECEIVED but without Retrieve AET! iuid:" + inst.getSopIuid()));
                if (commonRetrieveAETs == null) {
                    commonRetrieveAETs = new HashSet();
                }
            } else if (commonRetrieveAETs == null) {
                commonRetrieveAETs = new HashSet<String>();
                commonRetrieveAETs.addAll(Arrays.asList(retrieveAETs));
            } else {
                commonRetrieveAETs.retainAll(Arrays.asList(retrieveAETs));
            }
            Dataset refSOP = refSOPs.addNewItem();
            refSOP.putUI(528720, inst.getSopCuid());
            refSOP.putUI(528725, inst.getSopIuid());
            refSOP.putAE(524372, retrieveAETs);
            refSOP.putCS(524374, Availability.toString((int)inst.getAvailabilitySafe()));
        }
        if (commonRetrieveAETs == null) {
            return null;
        }
        Dataset patAttrs = pat.getAttributes(false);
        Dataset studyAttrs = study.getAttributes(false);
        Dataset seriesAttrs = series.getAttributes(false);
        Dataset pps = seriesAttrs.getItem(528657);
        DcmElement refPPSSeq = ian.putSQ(528657);
        if (pps != null) {
            if (!pps.contains(4210713)) {
                pps.putSQ(4210713);
            }
            refPPSSeq.addItem(pps);
        }
        SeriesStored seriesStored = new SeriesStored(series.getSourceAET(), commonRetrieveAETs.isEmpty() ? null : (String)commonRetrieveAETs.iterator().next(), patAttrs, studyAttrs, seriesAttrs, ian);
        return seriesStored;
    }

    public void updateDerivedStudyAndSeriesFields(String seriuid) throws FinderException {
        SeriesLocal series = this.findBySeriesIuid(seriuid);
        UpdateDerivedFieldsUtils.updateDerivedFieldsOf(series);
        UpdateDerivedFieldsUtils.updateDerivedFieldsOf(series.getStudy());
    }

    public void storeFile(String iuid, String tsuid, String dirpath, String fileid, int size, byte[] md5, int status) throws CreateException, FinderException {
        FileSystemLocal fs = this.fileSystemHome.findByDirectoryPath(dirpath);
        InstanceLocal instance = this.instHome.findBySopIuid(iuid);
        this.fileHome.create(fileid, tsuid, (long)size, md5, status, instance, fs);
    }

    private SeriesLocal getSeries(PatientMatching matching, Dataset ds, Dataset coercedElements) throws Exception {
        SeriesLocal series;
        String uid = ds.getString(0x20000E);
        try {
            series = this.findBySeriesIuid(uid);
        }
        catch (ObjectNotFoundException onfe) {
            try {
                return this.seriesHome.create(ds, this.getStudy(matching, ds, coercedElements));
            }
            catch (CreateException e1) {
                try {
                    series = this.findBySeriesIuid(uid);
                }
                catch (Exception e2) {
                    throw e1;
                }
            }
        }
        this.coerceSeriesIdentity(series, ds, coercedElements);
        return series;
    }

    private StudyLocal getStudy(PatientMatching matching, Dataset ds, Dataset coercedElements) throws Exception {
        StudyLocal study;
        String uid = ds.getString(0x20000D);
        try {
            study = this.studyHome.findByStudyIuid(uid);
        }
        catch (ObjectNotFoundException onfe) {
            try {
                return this.studyHome.create(ds, this.getPatient(matching, ds, coercedElements));
            }
            catch (CreateException e1) {
                try {
                    study = this.studyHome.findByStudyIuid(uid);
                }
                catch (Exception e2) {
                    throw e1;
                }
            }
        }
        this.coerceStudyIdentity(study, ds, coercedElements);
        return study;
    }

    private PatientLocal getPatient(PatientMatching matching, Dataset ds, Dataset coercedElements) throws Exception {
        PatientLocal pat;
        try {
            pat = this.patHome.selectPatient(ds, matching, true);
        }
        catch (ObjectNotFoundException onfe) {
            try {
                pat = this.patHome.create(ds);
                try {
                    return this.patHome.selectPatient(ds, matching, true);
                }
                catch (NonUniquePatientException nupe) {
                    pat.remove();
                    pat = this.patHome.selectPatient(ds, matching, true);
                }
                catch (ObjectNotFoundException onfe2) {
                    return pat;
                }
            }
            catch (CreateException ce) {
                try {
                    pat = this.patHome.selectPatient(ds, matching, true);
                }
                catch (ObjectNotFoundException onfe2) {
                    throw ce;
                }
            }
        }
        catch (NonUniquePatientException nupe) {
            return this.patHome.create(ds);
        }
        this.coercePatientIdentity(pat, ds, coercedElements);
        return pat;
    }

    private void coercePatientIdentity(PatientLocal patient, Dataset ds, Dataset coercedElements) throws DcmServiceException, CreateException {
        patient.coerceAttributes(ds, coercedElements);
    }

    private void coerceStudyIdentity(StudyLocal study, Dataset ds, Dataset coercedElements) throws Exception {
        this.coercePatientIdentity(this.getPatient(study, ds), ds, coercedElements);
        study.coerceAttributes(ds, coercedElements);
    }

    private PatientLocal getPatient(StudyLocal study, Dataset ds) throws Exception {
        String pid = ds.getString(0x100020);
        String issuer = ds.getString(0x100021);
        PatientLocal priorPat = study.getPatient();
        if (priorPat.getIssuerOfPatientId() == null && issuer != null) {
            try {
                PatientLocal dominantPat = this.patHome.selectPatient(pid, issuer);
                if (!dominantPat.isIdentical((EJBLocalObject)priorPat)) {
                    log.info((Object)("Detect duplicate Patient Record: " + dominantPat.asString()));
                    dominantPat.getStudies().addAll(priorPat.getStudies());
                    dominantPat.getMpps().addAll(priorPat.getMpps());
                    dominantPat.getMwlItems().addAll(priorPat.getMwlItems());
                    dominantPat.getGsps().addAll(priorPat.getGsps());
                    dominantPat.getGppps().addAll(priorPat.getGppps());
                    dominantPat.getUPS().addAll(priorPat.getUPS());
                    dominantPat.getMerged().addAll(priorPat.getMerged());
                    priorPat.remove();
                    return dominantPat;
                }
            }
            catch (ObjectNotFoundException e) {
                // empty catch block
            }
        }
        return priorPat;
    }

    private void coerceSeriesIdentity(SeriesLocal series, Dataset ds, Dataset coercedElements) throws Exception {
        this.coerceStudyIdentity(series.getStudy(), ds, coercedElements);
        series.coerceAttributes(ds, coercedElements);
    }

    private void coerceInstanceIdentity(InstanceLocal instance, Dataset ds, Dataset coercedElements) throws Exception {
        this.coerceSeriesIdentity(instance.getSeries(), ds, coercedElements);
        instance.coerceAttributes(ds, coercedElements);
    }

    public void commit(String iuid) throws FinderException {
        this.instHome.findBySopIuid(iuid).setCommitment(true);
    }

    public void commited(Dataset stgCmtResult) throws FinderException {
        DcmElement refSOPSeq = stgCmtResult.get(528793);
        if (refSOPSeq == null) {
            return;
        }
        HashSet seriesSet = new HashSet();
        HashSet studySet = new HashSet();
        String aet0 = stgCmtResult.getString(524372);
        int n = refSOPSeq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset refSOP = refSOPSeq.getItem(i);
            String iuid = refSOP.getString(528725);
            String aet = refSOP.getString(524372, aet0);
            if (iuid == null || aet == null) continue;
            this.commited(seriesSet, studySet, iuid, aet);
        }
        Iterator series = seriesSet.iterator();
        while (series.hasNext()) {
            SeriesLocal ser = this.findBySeriesIuid((String)series.next());
            ser.updateExternalRetrieveAET();
        }
        Iterator studies = studySet.iterator();
        while (studies.hasNext()) {
            StudyLocal study = this.studyHome.findByStudyIuid((String)studies.next());
            study.updateExternalRetrieveAET();
        }
    }

    private void commited(HashSet seriesSet, HashSet studySet, String iuid, String aet) throws FinderException {
        InstanceLocal inst = this.instHome.findBySopIuid(iuid);
        inst.setExternalRetrieveAET(aet);
        SeriesLocal series = inst.getSeries();
        seriesSet.add(series.getSeriesIuid());
        StudyLocal study = series.getStudy();
        studySet.add(study.getStudyIuid());
    }

    public int numberOfStudyRelatedInstances(String iuid) {
        try {
            StudyLocal study = this.studyHome.findByStudyIuid(iuid);
            return study.getNumberOfStudyRelatedInstances();
        }
        catch (ObjectNotFoundException onfe) {
            return -1;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public boolean studyExists(String iuid) {
        try {
            this.studyHome.findByStudyIuid(iuid);
            return true;
        }
        catch (ObjectNotFoundException onfe) {
            return false;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public boolean instanceExists(String iuid) {
        try {
            this.instHome.findBySopIuid(iuid);
            return true;
        }
        catch (ObjectNotFoundException onfe) {
            return false;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public void deleteInstances(String[] iuids, boolean deleteSeries, boolean deleteStudy) throws FinderException, EJBException, RemoveException {
        for (int i = 0; i < iuids.length; ++i) {
            InstanceLocal inst = this.instHome.findBySopIuid(iuids[i]);
            SeriesLocal series = inst.getSeries();
            StudyLocal study = series.getStudy();
            inst.remove();
            UpdateDerivedFieldsUtils.updateDerivedFieldsOf(series);
            if (deleteSeries && series.getNumberOfSeriesRelatedInstances() == 0) {
                series.remove();
            }
            UpdateDerivedFieldsUtils.updateDerivedFieldsOf(study);
            if (!deleteStudy || study.getNumberOfStudyRelatedSeries() != 0) continue;
            study.remove();
        }
    }

    private SeriesLocal findBySeriesIuid(String uid) throws FinderException {
        Long pk = (Long)seriesPkCache.get(uid);
        if (pk != null) {
            try {
                return this.seriesHome.findByPrimaryKey(pk);
            }
            catch (ObjectNotFoundException x) {
                log.warn((Object)("Series " + uid + " not found with cached pk! Cache entry removed!"));
                seriesPkCache.remove(uid);
            }
        }
        SeriesLocal ser = this.seriesHome.findBySeriesIuid(uid);
        seriesPkCache.put(uid, ser.getPk());
        return ser;
    }

    public void removeFromSeriesPkCache(String uid) {
        seriesPkCache.remove(uid);
    }

    public Dataset getPatientByIDWithIssuer(String pid, String issuer) throws FinderException {
        return this.patHome.findByPatientIdWithIssuer(pid, issuer).getAttributes(false);
    }
}

