/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.session;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4chex.archive.common.PatientMatching;
import org.dcm4chex.archive.ejb.interfaces.FileDTO;
import org.dcm4chex.archive.ejb.interfaces.FileLocal;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocal;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocalHome;
import org.dcm4chex.archive.ejb.interfaces.MPPSLocal;
import org.dcm4chex.archive.ejb.interfaces.PatientLocal;
import org.dcm4chex.archive.ejb.interfaces.PatientLocalHome;
import org.dcm4chex.archive.ejb.interfaces.PrivateFileLocalHome;
import org.dcm4chex.archive.ejb.interfaces.PrivateInstanceLocal;
import org.dcm4chex.archive.ejb.interfaces.PrivateInstanceLocalHome;
import org.dcm4chex.archive.ejb.interfaces.PrivatePatientLocal;
import org.dcm4chex.archive.ejb.interfaces.PrivatePatientLocalHome;
import org.dcm4chex.archive.ejb.interfaces.PrivateSeriesLocal;
import org.dcm4chex.archive.ejb.interfaces.PrivateSeriesLocalHome;
import org.dcm4chex.archive.ejb.interfaces.PrivateStudyLocal;
import org.dcm4chex.archive.ejb.interfaces.PrivateStudyLocalHome;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocal;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocalHome;
import org.dcm4chex.archive.ejb.interfaces.StudyLocal;
import org.dcm4chex.archive.ejb.interfaces.StudyLocalHome;
import org.dcm4chex.archive.ejb.session.UpdateDerivedFieldsUtils;

public abstract class PrivateManagerBean
implements SessionBean {
    private static final int DELETED = 1;
    private PatientLocalHome patHome;
    private StudyLocalHome studyHome;
    private SeriesLocalHome seriesHome;
    private InstanceLocalHome instHome;
    private PrivatePatientLocalHome privPatHome;
    private PrivateStudyLocalHome privStudyHome;
    private PrivateSeriesLocalHome privSeriesHome;
    private PrivateInstanceLocalHome privInstHome;
    private PrivateFileLocalHome privFileHome;
    private static final DcmObjectFactory dof = DcmObjectFactory.getInstance();
    private static Logger log = Logger.getLogger((String)PrivateManagerBean.class.getName());

    public void setSessionContext(SessionContext arg0) throws EJBException, RemoteException {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.patHome = (PatientLocalHome)jndiCtx.lookup("java:comp/env/ejb/Patient");
            this.studyHome = (StudyLocalHome)jndiCtx.lookup("java:comp/env/ejb/Study");
            this.seriesHome = (SeriesLocalHome)jndiCtx.lookup("java:comp/env/ejb/Series");
            this.instHome = (InstanceLocalHome)jndiCtx.lookup("java:comp/env/ejb/Instance");
            this.privPatHome = (PrivatePatientLocalHome)jndiCtx.lookup("java:comp/env/ejb/PrivatePatient");
            this.privStudyHome = (PrivateStudyLocalHome)jndiCtx.lookup("java:comp/env/ejb/PrivateStudy");
            this.privSeriesHome = (PrivateSeriesLocalHome)jndiCtx.lookup("java:comp/env/ejb/PrivateSeries");
            this.privInstHome = (PrivateInstanceLocalHome)jndiCtx.lookup("java:comp/env/ejb/PrivateInstance");
            this.privFileHome = (PrivateFileLocalHome)jndiCtx.lookup("java:comp/env/ejb/PrivateFile");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetSessionContext() {
        this.patHome = null;
        this.studyHome = null;
        this.seriesHome = null;
        this.instHome = null;
        this.privPatHome = null;
        this.privStudyHome = null;
        this.privSeriesHome = null;
        this.privInstHome = null;
        this.privFileHome = null;
    }

    public void deletePrivateSeries(long series_pk) throws RemoteException, FinderException {
        try {
            PrivateSeriesLocal series = this.privSeriesHome.findByPrimaryKey(new Long(series_pk));
            PrivateStudyLocal study = series.getStudy();
            series.remove();
            if (study.getSeries().isEmpty()) {
                PrivatePatientLocal pat = study.getPatient();
                study.remove();
                if (pat.getStudies().isEmpty()) {
                    pat.remove();
                }
            }
        }
        catch (EJBException e) {
            throw new RemoteException(e.getMessage());
        }
        catch (RemoveException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public Collection deletePrivateStudy(long study_pk) throws RemoteException, FinderException {
        try {
            PrivateStudyLocal study = this.privStudyHome.findByPrimaryKey(new Long(study_pk));
            Collection files = null;
            PrivatePatientLocal pat = study.getPatient();
            study.remove();
            if (pat.getStudies().isEmpty()) {
                pat.remove();
            }
            return files;
        }
        catch (EJBException e) {
            throw new RemoteException(e.getMessage());
        }
        catch (RemoveException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void deletePrivatePatient(long patient_pk) throws RemoteException {
        try {
            this.privPatHome.remove((Object)new Long(patient_pk));
        }
        catch (EJBException e) {
            throw new RemoteException(e.getMessage());
        }
        catch (RemoveException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void deletePrivateInstance(long instance_pk) throws RemoteException, FinderException {
        try {
            PrivateInstanceLocal instance = this.privInstHome.findByPrimaryKey(new Long(instance_pk));
            PrivateSeriesLocal series = instance.getSeries();
            instance.remove();
            if (series.getInstances().isEmpty()) {
                PrivateStudyLocal study = series.getStudy();
                series.remove();
                if (study.getSeries().isEmpty()) {
                    PrivatePatientLocal pat = study.getPatient();
                    study.remove();
                    if (pat.getStudies().isEmpty()) {
                        pat.remove();
                    }
                }
            }
        }
        catch (EJBException e) {
            throw new RemoteException(e.getMessage());
        }
        catch (RemoveException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void deletePrivateFile(long file_pk) throws RemoteException {
        try {
            this.privFileHome.remove((Object)new Long(file_pk));
        }
        catch (EJBException e) {
            throw new RemoteException(e.getMessage());
        }
        catch (RemoveException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void deletePrivateFiles(Collection fileDTOs) throws RemoteException {
        try {
            Iterator iter = fileDTOs.iterator();
            while (iter.hasNext()) {
                this.privFileHome.remove((Object)new Long(((FileDTO)iter.next()).getPk()));
            }
        }
        catch (EJBException e) {
            throw new RemoteException(e.getMessage());
        }
        catch (RemoveException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void deleteAll(int privateType) throws RemoteException {
        try {
            Collection c = this.privPatHome.findByPrivateType(privateType);
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                this.privPatHome.remove((Object)((PrivatePatientLocal)iter.next()).getPk());
            }
        }
        catch (EJBException e) {
            throw new RemoteException(e.getMessage());
        }
        catch (RemoveException e) {
            throw new RemoteException(e.getMessage());
        }
        catch (FinderException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public Collection moveInstancesToTrash(String[] iuids, boolean cascading) throws RemoteException {
        try {
            HashMap mapStudies = new HashMap();
            for (int i = 0; i < iuids.length; ++i) {
                Map mapSeries;
                InstanceLocal instance = this.instHome.findBySopIuid(iuids[i]);
                SeriesLocal series = instance.getSeries();
                StudyLocal study = series.getStudy();
                if (!mapStudies.containsKey(study)) {
                    mapStudies.put(study, new HashMap());
                }
                if (!(mapSeries = (Map)mapStudies.get(study)).containsKey(series)) {
                    mapSeries.put(series, new ArrayList());
                }
                Collection colInstances = (Collection)mapSeries.get(series);
                colInstances.add(instance);
            }
            ArrayList<Dataset> dss = new ArrayList<Dataset>();
            for (StudyLocal study : mapStudies.keySet()) {
                dss.add(this.makeIAN(study, (Map)mapStudies.get(study)));
                for (SeriesLocal series : ((Map)mapStudies.get(study)).keySet()) {
                    List instances = (List)((Map)mapStudies.get(study)).get(series);
                    for (int i = 0; i < instances.size(); ++i) {
                        this.getPrivateInstance((InstanceLocal)instances.get(i), 1, null);
                        ((InstanceLocal)instances.get(i)).remove();
                    }
                    if (series.getInstances().size() == 0 && cascading) {
                        this.getPrivateSeries(series, 1, null, false);
                        series.remove();
                        continue;
                    }
                    UpdateDerivedFieldsUtils.updateDerivedFieldsOf(series);
                }
                if (study.getSeries().size() == 0 && cascading) {
                    this.getPrivateStudy(study, 1, null, false);
                    study.remove();
                    continue;
                }
                UpdateDerivedFieldsUtils.updateDerivedFieldsOf(study);
            }
            return dss;
        }
        catch (CreateException e) {
            throw new RemoteException(e.getMessage());
        }
        catch (EJBException e) {
            throw new RemoteException(e.getMessage());
        }
        catch (FinderException e) {
            throw new RemoteException(e.getMessage());
        }
        catch (RemoveException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public Dataset moveInstanceToTrash(long instance_pk) throws RemoteException {
        try {
            InstanceLocal instance = this.instHome.findByPrimaryKey(new Long(instance_pk));
            ArrayList<InstanceLocal> colInstance = new ArrayList<InstanceLocal>();
            colInstance.add(instance);
            SeriesLocal series = instance.getSeries();
            HashMap<SeriesLocal, ArrayList<InstanceLocal>> mapSeries = new HashMap<SeriesLocal, ArrayList<InstanceLocal>>();
            mapSeries.put(series, colInstance);
            Dataset ds = this.makeIAN(series.getStudy(), mapSeries);
            this.getPrivateInstance(instance, 1, null);
            instance.remove();
            UpdateDerivedFieldsUtils.updateDerivedFieldsOf(series);
            UpdateDerivedFieldsUtils.updateDerivedFieldsOf(series.getStudy());
            return ds;
        }
        catch (CreateException e) {
            throw new RemoteException(e.getMessage());
        }
        catch (EJBException e) {
            throw new RemoteException(e.getMessage());
        }
        catch (FinderException e) {
            throw new RemoteException(e.getMessage());
        }
        catch (RemoveException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public Dataset moveSeriesToTrash(long series_pk) throws RemoteException {
        try {
            SeriesLocal series = this.seriesHome.findByPrimaryKey(new Long(series_pk));
            StudyLocal study = series.getStudy();
            HashMap<SeriesLocal, Collection> mapSeries = new HashMap<SeriesLocal, Collection>();
            mapSeries.put(series, series.getInstances());
            Dataset ds = this.makeIAN(series.getStudy(), mapSeries);
            this.getPrivateSeries(series, 1, null, true);
            series.remove();
            UpdateDerivedFieldsUtils.updateDerivedFieldsOf(study);
            return ds;
        }
        catch (CreateException e) {
            throw new RemoteException(e.getMessage());
        }
        catch (EJBException e) {
            throw new RemoteException(e.getMessage());
        }
        catch (FinderException e) {
            throw new RemoteException(e.getMessage());
        }
        catch (RemoveException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public Collection moveSeriesToTrash(String[] uids) {
        ArrayList<Dataset> result = new ArrayList<Dataset>();
        HashMap<StudyLocal, HashMap<SeriesLocal, Collection>> mapStudies = new HashMap<StudyLocal, HashMap<SeriesLocal, Collection>>();
        try {
            HashMap<SeriesLocal, Collection> mapSeries;
            StudyLocal study;
            for (int i = 0; i < uids.length; ++i) {
                SeriesLocal series = this.seriesHome.findBySeriesIuid(uids[i]);
                study = series.getStudy();
                mapSeries = (HashMap<SeriesLocal, Collection>)mapStudies.get(study);
                if (mapSeries == null) {
                    mapSeries = new HashMap<SeriesLocal, Collection>();
                    mapStudies.put(study, mapSeries);
                }
                mapSeries.put(series, series.getInstances());
            }
            for (Map.Entry studyEntry : mapStudies.entrySet()) {
                study = (StudyLocal)studyEntry.getKey();
                mapSeries = (Map)studyEntry.getValue();
                result.add(this.makeIAN(study, mapSeries));
                for (SeriesLocal series : mapSeries.keySet()) {
                    this.getPrivateSeries(series, 1, null, true);
                    series.remove();
                }
                UpdateDerivedFieldsUtils.updateDerivedFieldsOf(study);
            }
            return result;
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public Collection moveSeriesOfPPSToTrash(String ppsIUID, boolean removeEmptyParents) throws RemoteException {
        ArrayList result = new ArrayList();
        try {
            Object[] ppsSeries = this.seriesHome.findByPpsIuid(ppsIUID).toArray();
            if (ppsSeries.length > 0) {
                SeriesLocal series = null;
                StudyLocal study = ((SeriesLocal)ppsSeries[0]).getStudy();
                for (int i = 0; i < ppsSeries.length; ++i) {
                    series = (SeriesLocal)ppsSeries[i];
                    this.getPrivateSeries(series, 1, null, true);
                    series.remove();
                }
                if (removeEmptyParents && study.getSeries().isEmpty()) {
                    study.remove();
                } else {
                    UpdateDerivedFieldsUtils.updateDerivedFieldsOf(study);
                }
            }
        }
        catch (FinderException ignore) {
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
        return result;
    }

    public Dataset moveStudyToTrash(String iuid) throws ObjectNotFoundException {
        try {
            return this.moveStudyToTrash(this.studyHome.findByStudyIuid(iuid));
        }
        catch (ObjectNotFoundException onfe) {
            throw onfe;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public Dataset moveStudyToTrash(long study_pk) throws ObjectNotFoundException {
        try {
            return this.moveStudyToTrash(this.studyHome.findByPrimaryKey(new Long(study_pk)));
        }
        catch (ObjectNotFoundException onfe) {
            throw onfe;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    private Dataset moveStudyToTrash(StudyLocal study) {
        try {
            Dataset ds = this.makeIAN(study, null);
            this.getPrivateStudy(study, 1, null, true);
            study.remove();
            return ds;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public Dataset purgeStudy(String suid) {
        try {
            StudyLocal study = this.studyHome.findByStudyIuid(suid);
            Dataset ds = this.makeIAN(study, null);
            for (SeriesLocal series : study.getSeries()) {
                for (FileLocal file : series.getAllFiles()) {
                    this.privFileHome.create(file.getFilePath(), file.getFileTsuid(), file.getFileSize(), file.getFileMd5(), file.getFileStatus(), null, file.getFileSystem());
                }
            }
            study.remove();
            return ds;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public Collection movePatientToTrash(long pat_pk) throws ObjectNotFoundException {
        try {
            return this.movePatientToTrash(this.patHome.findByPrimaryKey(new Long(pat_pk)));
        }
        catch (ObjectNotFoundException onfe) {
            throw onfe;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public Collection movePatientToTrash(Dataset patAttrs, PatientMatching matching) throws ObjectNotFoundException {
        try {
            return this.movePatientToTrash(this.patHome.selectPatient(patAttrs, matching, false));
        }
        catch (ObjectNotFoundException onfe) {
            throw onfe;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    private Collection movePatientToTrash(PatientLocal patient) {
        Collection col = patient.getStudies();
        ArrayList<Dataset> result = new ArrayList<Dataset>();
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            result.add(this.makeIAN((StudyLocal)iter.next(), null));
        }
        Dataset ds = patient.getAttributes(true);
        try {
            this.getPrivatePatient(patient, 1, true);
            patient.remove();
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
        if (result.isEmpty()) {
            result.add(ds);
        }
        return result;
    }

    private PrivateInstanceLocal getPrivateInstance(InstanceLocal instance, int type, PrivateSeriesLocal privSeries) throws FinderException, CreateException {
        PrivateInstanceLocal privInstance;
        Collection col = this.privInstHome.findBySopIuid(type, instance.getSopIuid());
        if (col.isEmpty()) {
            if (privSeries == null) {
                privSeries = this.getPrivateSeries(instance.getSeries(), type, null, false);
            }
            privInstance = this.privInstHome.create(type, instance.getAttributes(true), privSeries);
        } else {
            privInstance = (PrivateInstanceLocal)col.iterator().next();
        }
        Object[] files = instance.getFiles().toArray();
        for (int i = 0; i < files.length; ++i) {
            FileLocal file = (FileLocal)files[i];
            this.privFileHome.create(file.getFilePath(), file.getFileTsuid(), file.getFileSize(), file.getFileMd5(), file.getFileStatus(), privInstance, file.getFileSystem());
            try {
                file.remove();
                continue;
            }
            catch (Exception x) {
                log.warn((Object)("Can not remove File record:" + file), (Throwable)x);
            }
        }
        return privInstance;
    }

    private PrivateSeriesLocal getPrivateSeries(SeriesLocal series, int type, PrivateStudyLocal privStudy, boolean includeInstances) throws FinderException, CreateException {
        PrivateSeriesLocal privSeries;
        Collection col = this.privSeriesHome.findBySeriesIuid(type, series.getSeriesIuid());
        if (col.isEmpty()) {
            if (privStudy == null) {
                privStudy = this.getPrivateStudy(series.getStudy(), type, null, false);
            }
            privSeries = this.privSeriesHome.create(type, series.getAttributes(true), privStudy);
        } else {
            privSeries = (PrivateSeriesLocal)col.iterator().next();
        }
        if (includeInstances) {
            Iterator iter = series.getInstances().iterator();
            while (iter.hasNext()) {
                this.getPrivateInstance((InstanceLocal)iter.next(), type, privSeries);
            }
        }
        return privSeries;
    }

    private PrivateStudyLocal getPrivateStudy(StudyLocal study, int type, PrivatePatientLocal privPat, boolean includeSeries) throws FinderException, CreateException {
        PrivateStudyLocal privStudy;
        Collection col = this.privStudyHome.findByStudyIuid(type, study.getStudyIuid());
        if (col.isEmpty()) {
            if (privPat == null) {
                privPat = this.getPrivatePatient(study.getPatient(), type, false);
            }
            privStudy = this.privStudyHome.create(type, study.getAttributes(true), privPat);
        } else {
            privStudy = (PrivateStudyLocal)col.iterator().next();
        }
        if (includeSeries) {
            Iterator iter = study.getSeries().iterator();
            while (iter.hasNext()) {
                this.getPrivateSeries((SeriesLocal)iter.next(), type, privStudy, true);
            }
        }
        return privStudy;
    }

    private PrivatePatientLocal getPrivatePatient(PatientLocal patient, int type, boolean includeStudies) throws FinderException, CreateException {
        Collection col = this.privPatHome.findByPatientIdWithIssuer(type, patient.getPatientId(), patient.getIssuerOfPatientId());
        PrivatePatientLocal privPat = col.isEmpty() ? this.privPatHome.create(type, patient.getAttributes(true)) : (PrivatePatientLocal)col.iterator().next();
        if (includeStudies) {
            Iterator iter = patient.getStudies().iterator();
            while (iter.hasNext()) {
                this.getPrivateStudy((StudyLocal)iter.next(), type, privPat, true);
            }
        }
        return privPat;
    }

    private Dataset makeIAN(StudyLocal study, Map mapSeries) {
        Iterator<Object> iter;
        log.debug((Object)("makeIAN: studyIUID:" + study.getStudyIuid()));
        PatientLocal pat = study.getPatient();
        Dataset ds = dof.newDataset();
        ds.putUI(0x20000D, study.getStudyIuid());
        ds.putSH(524368, study.getAccessionNumber());
        ds.putLO(0x100020, pat.getPatientId());
        ds.putLO(0x100021, pat.getIssuerOfPatientId());
        ds.putPN(0x100010, pat.getPatientName());
        DcmElement refPPSSeq = ds.putSQ(528657);
        HashSet<String> mppsuids = new HashSet<String>();
        DcmElement refSeriesSeq = ds.putSQ(528661);
        Iterator<Object> iterator = iter = mapSeries == null ? study.getSeries().iterator() : mapSeries.keySet().iterator();
        while (iter.hasNext()) {
            String mppsuid;
            SeriesLocal sl = (SeriesLocal)iter.next();
            MPPSLocal mpps = sl.getMpps();
            if (mpps != null && mppsuids.add(mppsuid = mpps.getSopIuid())) {
                Dataset refmpps = refPPSSeq.addNewItem();
                refmpps.putUI(528720, "1.2.840.10008.3.1.2.3.3");
                refmpps.putUI(528725, mppsuid);
                refmpps.putSQ(4210713);
            }
            Dataset dsSer = refSeriesSeq.addNewItem();
            dsSer.putUI(0x20000E, sl.getSeriesIuid());
            Collection instances = mapSeries == null ? sl.getInstances() : (Collection)mapSeries.get(sl);
            Iterator iter2 = instances.iterator();
            DcmElement refSopSeq = null;
            if (iter2.hasNext()) {
                refSopSeq = dsSer.putSQ(528793);
            }
            while (iter2.hasNext()) {
                InstanceLocal il = (InstanceLocal)iter2.next();
                Dataset dsInst = refSopSeq.addNewItem();
                dsInst.putAE(524372, il.getRetrieveAETs());
                dsInst.putCS(524374, "UNAVAILABLE");
                dsInst.putUI(528720, il.getSopCuid());
                dsInst.putUI(528725, il.getSopIuid());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"return IAN:");
            log.debug((Object)ds);
        }
        return ds;
    }
}

