/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.session;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.dcm4chex.archive.ejb.interfaces.PatientLocal;
import org.dcm4chex.archive.ejb.interfaces.PatientLocalHome;

public abstract class PIXQueryBean
implements SessionBean {
    private PatientLocalHome patHome;

    public void setSessionContext(SessionContext ctx) throws RemoteException {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.patHome = (PatientLocalHome)jndiCtx.lookup("java:comp/env/ejb/Patient");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetSessionContext() {
        this.patHome = null;
    }

    public List queryCorrespondingPIDs(String patientID, String issuer, String[] domains) {
        try {
            Collection c = this.isWildCard(patientID) ? this.patHome.findCorrespondingLike(this.toLIKE(patientID), issuer) : this.patHome.findCorresponding(patientID, issuer);
            return this.toPIDs(c, domains);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public List queryCorrespondingPIDsByPrimaryPatientID(String patientID, String issuer, String[] domains) {
        try {
            Collection c = this.isWildCard(patientID) ? this.patHome.findCorrespondingByPrimaryPatientIDLike(this.toLIKE(patientID), issuer) : this.patHome.findCorrespondingByPrimaryPatientID(patientID, issuer);
            return this.toPIDs(c, domains);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public List queryCorrespondingPIDsByOtherPatientID(String patientID, String issuer, String[] domains) {
        try {
            Collection c = this.isWildCard(patientID) ? this.patHome.findCorrespondingByOtherPatientIDLike(this.toLIKE(patientID), issuer) : this.patHome.findCorrespondingByOtherPatientID(patientID, issuer);
            return this.toPIDs(c, domains);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    private ArrayList toPIDs(Collection pats, String[] domains) {
        ArrayList<String[]> l = new ArrayList<String[]>(pats.size());
        List<String> domainList = domains != null ? Arrays.asList(domains) : null;
        for (PatientLocal pat : pats) {
            String iss = pat.getIssuerOfPatientId();
            if (domainList != null && !domainList.contains(iss)) continue;
            l.add(new String[]{pat.getPatientId(), iss});
        }
        return l;
    }

    private String toLIKE(String patientID) {
        StringBuffer sb = new StringBuffer(patientID);
        block5: for (int i = 0; i < sb.length(); ++i) {
            switch (sb.charAt(i)) {
                case '?': {
                    sb.setCharAt(i, '_');
                    continue block5;
                }
                case '*': {
                    sb.setCharAt(i, '%');
                    continue block5;
                }
                case '%': 
                case '\\': 
                case '_': {
                    sb.insert(i++, '\\');
                }
            }
        }
        return sb.toString();
    }

    private boolean isWildCard(String s) {
        return s.indexOf(42) != -1 || s.indexOf(63) != -1;
    }
}

