/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.session;

import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.util.UIDGenerator;
import org.dcm4chex.archive.ejb.interfaces.FileLocal;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocal;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocalHome;
import org.dcm4chex.archive.ejb.interfaces.MediaDTO;
import org.dcm4chex.archive.ejb.interfaces.MediaLocal;
import org.dcm4chex.archive.ejb.interfaces.MediaLocalHome;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocal;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocalHome;
import org.dcm4chex.archive.ejb.interfaces.StudyLocal;
import org.dcm4chex.archive.ejb.interfaces.StudyLocalHome;

public abstract class MediaComposerBean
implements SessionBean {
    private static Logger log = Logger.getLogger((String)MediaComposerBean.class.getName());
    private MediaLocalHome mediaHome;
    private InstanceLocalHome instHome;
    private StudyLocalHome studyHome;
    private SeriesLocalHome seriesHome;

    public void setSessionContext(SessionContext arg0) throws EJBException, RemoteException {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.mediaHome = (MediaLocalHome)jndiCtx.lookup("java:comp/env/ejb/Media");
            this.instHome = (InstanceLocalHome)jndiCtx.lookup("java:comp/env/ejb/Instance");
            this.studyHome = (StudyLocalHome)jndiCtx.lookup("java:comp/env/ejb/Study");
            this.seriesHome = (SeriesLocalHome)jndiCtx.lookup("java:comp/env/ejb/Series");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetSessionContext() {
        this.mediaHome = null;
        this.instHome = null;
    }

    public Collection getStudiesReceivedBefore(long time) throws FinderException {
        return this.studyHome.findStudiesNotOnMedia(new Timestamp(time));
    }

    public List assignStudyToMedia(StudyLocal study, List mediaPool, long maxMediaSize, String prefix) throws FinderException, CreateException {
        if (mediaPool == null) {
            mediaPool = this.getCollectingMedia();
        }
        HashMap<InstanceLocal, FileLocal> instanceFiles = new HashMap<InstanceLocal, FileLocal>();
        long size = 0L;
        for (InstanceLocal instance : study.getInstancesNotOnMedia()) {
            Collection files = instance.getFiles();
            if (files.isEmpty()) {
                log.warn((Object)("Instance " + instance.getPk() + "(" + instance.getSopIuid() + ") has no files! ignored!"));
                continue;
            }
            Iterator it = files.iterator();
            FileLocal file = (FileLocal)it.next();
            while (it.hasNext()) {
                FileLocal file2 = (FileLocal)it.next();
                int avail = file.getFileSystem().getAvailability();
                int avail2 = file2.getFileSystem().getAvailability();
                if (avail2 < avail) {
                    file = file2;
                    continue;
                }
                if (file2.getPk() <= file.getPk()) continue;
                file = file2;
            }
            size += file.getFileSize();
            instanceFiles.put(instance, file);
        }
        if (size > maxMediaSize) {
            log.info((Object)("Study size (" + size + ") exceed maxMediaSize (" + maxMediaSize + ")! Split study is necessary!"));
            this.splitStudy(instanceFiles, mediaPool, maxMediaSize, prefix);
        } else {
            log.debug((Object)("assign study " + study.getStudyIuid() + " (size=" + size + ") to media"));
            this.assignInstancesToMedia(instanceFiles.keySet(), size, this.getMedia(mediaPool, maxMediaSize - size, prefix));
        }
        return mediaPool;
    }

    private void assignInstancesToMedia(Set instances, long size, MediaLocal media) throws CreateException {
        log.debug((Object)("assign instances (" + instances + ") to media " + media));
        Iterator iter = instances.iterator();
        while (iter.hasNext()) {
            ((InstanceLocal)iter.next()).setMedia(media);
        }
        media.setMediaUsage(media.getMediaUsage() + size);
    }

    private MediaLocal getMedia(List mediaPool, long maxUsed, String prefix) throws CreateException {
        MediaLocal media2;
        ++maxUsed;
        if (mediaPool.size() > 0) {
            for (MediaLocal media2 : mediaPool) {
                if (media2.getMediaUsage() >= maxUsed) continue;
                return media2;
            }
        }
        log.debug((Object)("We need new media! mediaPool:" + mediaPool));
        media2 = this.createMedia(prefix);
        mediaPool.add(media2);
        return media2;
    }

    private void splitStudy(Map instanceFiles, List mediaPool, long maxMediaSize, String prefix) throws CreateException {
        log.info((Object)"Split study!");
        long size = 0L;
        HashSet instances = new HashSet();
        for (Map.Entry entry : instanceFiles.entrySet()) {
            long fileSize = ((FileLocal)entry.getValue()).getFileSize();
            if ((size += fileSize) > maxMediaSize) {
                log.debug((Object)("assign instances (" + instances.size() + "/" + instanceFiles.size() + ") to new media!"));
                this.assignInstancesToMedia(instances, size, this.createMedia(prefix));
                size = fileSize;
                instances.clear();
            }
            instances.add(entry.getKey());
        }
        if (!instances.isEmpty()) {
            log.debug((Object)("assign remaining instances (" + instances.size() + "/" + instanceFiles.size() + ") to new media!"));
            this.assignInstancesToMedia(instances, size, this.getMedia(mediaPool, maxMediaSize - size, prefix));
        }
    }

    public List getCollectingMedia() throws FinderException {
        List mediaCollection = (List)this.mediaHome.findByStatus(0);
        Comparator comp = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                MediaLocal ml1 = (MediaLocal)arg0;
                MediaLocal ml2 = (MediaLocal)arg1;
                return (int)(ml2.getMediaUsage() - ml1.getMediaUsage());
            }
        };
        Collections.sort(mediaCollection, comp);
        log.debug((Object)("Number of 'COLLECTING' media found:" + mediaCollection.size()));
        return mediaCollection;
    }

    private MediaLocal createMedia(String prefix) throws CreateException {
        MediaLocal ml = this.mediaHome.create(UIDGenerator.getInstance().createUID());
        ml.setFilesetId(prefix + ml.getPk());
        ml.setMediaStatus(0);
        if (log.isInfoEnabled()) {
            log.info((Object)("New media created:" + ml.getFilesetId()));
        }
        return ml;
    }

    public List getWithStatus(int status) throws FinderException {
        return this.toMediaDTOs(this.mediaHome.findByStatus(status));
    }

    public int findByCreatedTime(Collection col, Long after, Long before, int[] stati, Integer offset, Integer limit, boolean desc) throws FinderException {
        Timestamp tsAfter = null;
        if (after != null) {
            tsAfter = new Timestamp(after);
        }
        Timestamp tsBefore = null;
        if (before != null) {
            tsBefore = new Timestamp(before);
        }
        col.addAll(this.toMediaDTOs(this.mediaHome.listByCreatedTime(stati, tsAfter, tsBefore, offset, limit, desc)));
        return this.mediaHome.countByCreatedTime(stati, tsAfter, tsBefore);
    }

    public int findByUpdatedTime(Collection col, Long after, Long before, int[] stati, Integer offset, Integer limit, boolean desc) throws FinderException {
        Timestamp tsAfter = null;
        if (after != null) {
            tsAfter = new Timestamp(after);
        }
        Timestamp tsBefore = null;
        if (before != null) {
            tsBefore = new Timestamp(before);
        }
        col.addAll(this.toMediaDTOs(this.mediaHome.listByUpdatedTime(stati, tsAfter, tsBefore, offset, limit, desc)));
        return this.mediaHome.countByUpdatedTime(stati, tsAfter, tsBefore);
    }

    private List toMediaDTOs(Collection c) {
        ArrayList<MediaDTO> list = new ArrayList<MediaDTO>();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            list.add(this.toMediaDTO((MediaLocal)it.next()));
        }
        return list;
    }

    private MediaDTO toMediaDTO(MediaLocal media) {
        MediaDTO dto = new MediaDTO();
        dto.setPk(media.getPk().longValue());
        dto.setCreatedTime((Date)media.getCreatedTime());
        dto.setUpdatedTime((Date)media.getUpdatedTime());
        dto.setMediaUsage(media.getMediaUsage());
        dto.setMediaStatus(media.getMediaStatus());
        dto.setMediaStatusInfo(media.getMediaStatusInfo());
        dto.setFilesetId(media.getFilesetId());
        dto.setFilesetIuid(media.getFilesetIuid());
        dto.setMediaCreationRequestIuid(media.getMediaCreationRequestIuid());
        try {
            dto.setInstancesAvailable(media.checkInstancesAvailable());
        }
        catch (FinderException finderException) {
            // empty catch block
        }
        return dto;
    }

    public void setMediaCreationRequestIuid(long pk, String iuid) throws FinderException {
        MediaLocal media = this.mediaHome.findByPrimaryKey(new Long(pk));
        media.setMediaCreationRequestIuid(iuid);
    }

    public void setMediaStatus(long pk, int status, String info) throws FinderException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setMediaStatus: pk=" + pk + ", status:" + status + ", info" + info));
        }
        MediaLocal media = this.mediaHome.findByPrimaryKey(new Long(pk));
        media.setMediaStatus(status);
        media.setMediaStatusInfo(info);
        if (status == 4) {
            this.updateSeriesAndStudies(media);
        }
    }

    public Collection getStudyUIDSForMedia(long pk) throws FinderException {
        ArrayList<String> c = new ArrayList<String>();
        MediaLocal media = this.mediaHome.findByPrimaryKey(new Long(pk));
        Collection studies = this.studyHome.findStudiesOnMedia(media);
        Iterator iter = studies.iterator();
        while (iter.hasNext()) {
            c.add(((StudyLocal)iter.next()).getStudyIuid());
        }
        return c;
    }

    public Dataset prepareMediaCreationRequest(long pk) throws FinderException {
        MediaLocal media = this.mediaHome.findByPrimaryKey(new Long(pk));
        Dataset ds = DcmObjectFactory.getInstance().newDataset();
        ds.putCS(524293, "ISO_IR 100");
        ds.putSH(8913200, media.getFilesetId());
        ds.putUI(8913216, media.getFilesetIuid());
        Collection c = media.getInstances();
        DcmElement refSOPSeq = ds.putSQ(528793);
        for (InstanceLocal il : c) {
            Dataset item = refSOPSeq.addNewItem();
            item.putUI(528725, il.getSopIuid());
            item.putUI(528720, il.getSopCuid());
        }
        return ds;
    }

    private void updateSeriesAndStudies(MediaLocal media) throws FinderException {
        Collection series = this.seriesHome.findSeriesOnMedia(media);
        for (SeriesLocal ser : series) {
            ser.updateFilesetId();
        }
        Collection studies = this.studyHome.findStudiesOnMedia(media);
        for (StudyLocal sty : studies) {
            sty.updateFilesetId();
        }
    }

    public void deleteMedia(Long mediaPk) throws EJBException, RemoveException, FinderException {
        MediaLocal media = this.mediaHome.findByPrimaryKey(mediaPk);
        Collection series = this.seriesHome.findSeriesOnMedia(media);
        Collection studies = this.studyHome.findStudiesOnMedia(media);
        String filesetId = media.getFilesetId();
        this.mediaHome.remove((Object)mediaPk);
        log.info((Object)("Media " + filesetId + " removed!"));
        for (SeriesLocal ser : series) {
            ser.updateFilesetId();
            ser.updateAvailability();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Series updated after media " + filesetId + " was deleted!"));
        }
        for (StudyLocal sty : studies) {
            sty.updateFilesetId();
            sty.updateAvailability();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Studies updated after media " + filesetId + " was deleted!"));
        }
    }

    public boolean checkInstancesAvailable(Long mediaPk) throws FinderException {
        return this.mediaHome.findByPrimaryKey(mediaPk).checkInstancesAvailable();
    }
}

