/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.session;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObject;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.dict.Tags;
import org.dcm4che.util.UIDGenerator;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocal;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocalHome;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocal;
import org.dcm4chex.archive.ejb.interfaces.StudyLocal;
import org.dcm4chex.archive.ejb.interfaces.StudyLocalHome;

public abstract class MPPSEmulatorBean
implements SessionBean {
    private static Logger LOG = Logger.getLogger(MPPSEmulatorBean.class);
    private static final int[] PATIENT_TAGS = new int[]{524293, 0x100010, 0x100020, 0x100021, 0x100030, 0x100040};
    private static final int[] SERIES_TAGS = new int[]{528446, 528464, 1577008, 0x20000E};
    private static final int[] STUDY_TAGS = new int[]{528434, 0x200010};
    private static final int[] SERIES_PPS_TAGS = new int[]{0x400244, 4194885, 4194899};
    private StudyLocalHome studyHome;
    private InstanceLocalHome instanceHome;

    public void setSessionContext(SessionContext ctx) {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.studyHome = (StudyLocalHome)jndiCtx.lookup("java:comp/env/ejb/Study");
            this.instanceHome = (InstanceLocalHome)jndiCtx.lookup("java:comp/env/ejb/Instance");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetSessionContext() {
        this.studyHome = null;
        this.instanceHome = null;
    }

    public Collection getStudiesWithMissingMPPS(String sourceAET, long delay) throws FinderException {
        return this.studyHome.selectWithMissingPpsIuidFromSrcAETReceivedLastOfStudyBefore(sourceAET, new Timestamp(System.currentTimeMillis() - delay));
    }

    public Dataset[] generateMPPS(Long studyPk, boolean ignoreReqAttrIfNoStudyAccNo) throws FinderException {
        StudyLocal study = this.studyHome.findByPrimaryKey(studyPk);
        if (study.getNumberOfReceivingSeries() != 0) {
            LOG.info((Object)("Skip generation of MPPS for study " + study.getStudyIuid() + "! Study contains series with status RECEIVING!"));
            return new Dataset[0];
        }
        String suid = study.getStudyIuid();
        HashMap mppsMap = new HashMap();
        for (SeriesLocal series : study.getSeries()) {
            if (series.getPpsIuid() != null) continue;
            this.addSeries(series, mppsMap, suid, study, ignoreReqAttrIfNoStudyAccNo);
        }
        Dataset[] result = new Dataset[mppsMap.size()];
        Iterator it = mppsMap.values().iterator();
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.updateSeries((List)it.next());
        }
        return result;
    }

    private Dataset updateSeries(List list) {
        boolean calcPpsEndDT;
        Dataset mpps = (Dataset)list.get(0);
        Date ppsStartDT = mpps.getDateTime(0x400244, 4194885);
        Date ppsEndDT = mpps.getDateTime(4194896, 4194897);
        boolean calcPpsStartDT = ppsStartDT == null;
        boolean bl = calcPpsEndDT = ppsEndDT == null;
        if (calcPpsStartDT || calcPpsEndDT) {
            SeriesLocal series = (SeriesLocal)list.get(1);
            ppsStartDT = ppsEndDT = series.getCreatedTime();
            int n = list.size();
            for (int i = 2; i < n; ++i) {
                series = (SeriesLocal)list.get(i);
                Timestamp dt = series.getCreatedTime();
                if (calcPpsStartDT && ppsStartDT.compareTo(dt) > 0) {
                    ppsStartDT = dt;
                }
                if (!calcPpsEndDT || ppsEndDT.compareTo(dt) <= 0) continue;
                ppsEndDT = dt;
            }
            if (calcPpsStartDT) {
                mpps.putDA(0x400244, ppsStartDT);
                mpps.putTM(4194885, ppsStartDT);
            }
            if (calcPpsEndDT) {
                mpps.putDA(4194896, ppsEndDT);
                mpps.putTM(4194897, ppsEndDT);
            }
        }
        int n = list.size();
        for (int i = 1; i < n; ++i) {
            SeriesLocal series = (SeriesLocal)list.get(i);
            Dataset seriesAttrs = series.getAttributes(false);
            seriesAttrs.putAll((DcmObject)mpps.subSet(SERIES_PPS_TAGS));
            Dataset refPPS = seriesAttrs.putSQ(528657).addNewItem();
            refPPS.putUI(528720, mpps.getString(524310));
            refPPS.putUI(528725, mpps.getString(524312));
            series.setAttributes(seriesAttrs);
        }
        return mpps;
    }

    private void addSeries(SeriesLocal series, HashMap mppsMap, String suid, StudyLocal study, boolean ignoreReqAttrIfNoStudyAccNo) throws FinderException {
        Dataset mpps;
        String md = series.getModality() == null ? "OT" : series.getModality();
        String srcAet = series.getSourceAET();
        Dataset seriesAttrs = series.getAttributes(false);
        String key = md + srcAet;
        ArrayList<Object> list = (ArrayList<Object>)mppsMap.get(key);
        if (list == null) {
            list = new ArrayList<Object>();
            mppsMap.put(key, list);
            mpps = DcmObjectFactory.getInstance().newDataset();
            list.add(mpps);
            Dataset patAttrs = study.getPatient().getAttributes(false);
            Dataset studyAttrs = study.getAttributes(false);
            mpps.putAll((DcmObject)patAttrs.subSet(PATIENT_TAGS));
            mpps.putAll((DcmObject)studyAttrs.subSet(STUDY_TAGS));
            this.checkCodeSeq(mpps, 528434);
            DcmElement rqaSq = ignoreReqAttrIfNoStudyAccNo && studyAttrs.getString(524368) == null ? null : seriesAttrs.get(4194933);
            int rqaSqSize = rqaSq != null ? rqaSq.countItems() : 0;
            DcmElement ssaSq = mpps.putSQ(4194928);
            if (rqaSqSize == 0) {
                Dataset ssa = ssaSq.addNewItem();
                ssa.putSH(524368);
                ssa.putSQ(528656);
                ssa.putUI(0x20000D, studyAttrs.getString(0x20000D));
                ssa.putLO(3280992);
                ssa.putSH(0x400009);
                ssa.putLO(0x400007);
                ssa.putSQ(0x400008);
                ssa.putSH(0x401001);
            } else {
                int n = rqaSqSize;
                for (int i = 0; i < n; ++i) {
                    Dataset ssa = rqaSq.getItem(i);
                    ssaSq.addItem(ssa);
                    ssa.putSH(524368, studyAttrs.getString(524368));
                    ssa.putUI(0x20000D, studyAttrs.getString(0x20000D));
                    if (!ssa.contains(528656)) {
                        ssa.putSQ(528656);
                    }
                    if (!ssa.contains(0x400009)) {
                        ssa.putSH(0x400009);
                    }
                    if (!ssa.contains(0x400007)) {
                        ssa.putLO(0x400007);
                    }
                    this.checkCodeSeq(ssa, 0x400008);
                    if (ssa.contains(0x401001)) continue;
                    ssa.putSH(0x401001);
                }
            }
            mpps.putUI(524312, UIDGenerator.getInstance().createUID());
            mpps.putUI(524310, "1.2.840.10008.3.1.2.3.3");
            mpps.putAE(4194881, srcAet);
            mpps.putSH(0x400242, seriesAttrs.getString(528400));
            mpps.putSH(4194883);
            mpps.putCS(524384, md);
            mpps.putSH(4194899, this.makePPSID(md, suid));
            mpps.putLO(4194901, studyAttrs.getString(528432));
            mpps.putSQ(0x400340);
        }
        mpps = (Dataset)list.get(0);
        list.add(series);
        Date ppsStartDT = mpps.getDateTime(0x400244, 4194885);
        Date ppsEndDT = mpps.getDateTime(4194896, 4194897);
        Date seriesDT = seriesAttrs.getDateTime(524321, 524337);
        if (seriesDT != null) {
            if (ppsStartDT == null || ppsStartDT.compareTo(seriesDT) > 0) {
                ppsStartDT = seriesDT;
                mpps.putDA(0x400244, seriesDT);
                mpps.putTM(4194885, seriesDT);
            }
            if (ppsEndDT == null || ppsEndDT.compareTo(seriesDT) < 0) {
                ppsEndDT = seriesDT;
                mpps.putDA(4194896, seriesDT);
                mpps.putTM(4194897, seriesDT);
            }
        }
        Dataset seriesItem = mpps.get(0x400340).addNewItem();
        seriesItem.putAll((DcmObject)seriesAttrs.subSet(SERIES_TAGS));
        DcmElement refImageSq = seriesItem.putSQ(528704);
        Collection c = this.instanceHome.findBySeriesPk(series.getPk());
        for (InstanceLocal inst : c) {
            Dataset refSOP = refImageSq.addNewItem();
            refSOP.putUI(528720, inst.getSopCuid());
            refSOP.putUI(528725, inst.getSopIuid());
        }
    }

    private void checkCodeSeq(Dataset ds, int tag) {
        DcmElement codeSeq = ds.get(tag);
        if (codeSeq == null) {
            ds.putSQ(tag);
        } else if (codeSeq.countItems() > 0) {
            DcmElement newCodeSeq = ds.putSQ(tag);
            int len = codeSeq.countItems();
            for (int i = 0; i < len; ++i) {
                Dataset item = codeSeq.getItem(i);
                if (item != null && item.containsValue(524544) && item.containsValue(524546)) {
                    newCodeSeq.addItem(item);
                    if (tag != 528434 || len <= 1) continue;
                    LOG.warn((Object)"Study with multiple Procedure Codes - only include first (valid) code item in emulated MPPS");
                    return;
                }
                LOG.warn((Object)("Code sequence " + Tags.toString((int)tag) + ":Invalid code item removed! code:"));
                LOG.warn((Object)item);
            }
        }
    }

    private String makePPSID(String md, String suid) {
        return md.substring(0, 2) + suid.substring(Math.max(0, suid.length() - 14));
    }
}

