/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.session;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObject;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.util.UIDGenerator;
import org.dcm4chex.archive.common.GPSPSStatus;
import org.dcm4chex.archive.common.PatientMatching;
import org.dcm4chex.archive.ejb.interfaces.GPPPSLocal;
import org.dcm4chex.archive.ejb.interfaces.GPSPSLocal;
import org.dcm4chex.archive.ejb.interfaces.GPSPSLocalHome;
import org.dcm4chex.archive.ejb.interfaces.GPSPSRequestLocal;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocalHome;
import org.dcm4chex.archive.ejb.interfaces.PatientLocal;
import org.dcm4chex.archive.ejb.interfaces.PatientLocalHome;

public abstract class GPWLManagerBean
implements SessionBean {
    private static final int MAY_NO_LONGER_BE_UPDATED = 42241;
    private static final int WRONG_TRANSACTION_UID = 42242;
    private static final int ALREADY_IN_PROGRESS = 42243;
    private static final int[] OUTPUT_INFO_TAGS = new int[]{4210737, 4210738, 0x404033};
    private static Logger log = Logger.getLogger(GPWLManagerBean.class);
    private PatientLocalHome patHome;
    private InstanceLocalHome instanceHome;
    private GPSPSLocalHome gpspsHome;
    private final PatientMatching patientMatching = new PatientMatching("pid,issuer?");

    public void setSessionContext(SessionContext ctx) {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.patHome = (PatientLocalHome)jndiCtx.lookup("java:comp/env/ejb/Patient");
            this.instanceHome = (InstanceLocalHome)jndiCtx.lookup("java:comp/env/ejb/Instance");
            this.gpspsHome = (GPSPSLocalHome)jndiCtx.lookup("java:comp/env/ejb/GPSPS");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetSessionContext() {
        this.gpspsHome = null;
        this.instanceHome = null;
        this.patHome = null;
    }

    public Dataset getWorklistItem(String spsid) throws FinderException {
        try {
            return this.getWorklistItem(spsid, false);
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public Dataset removeWorklistItem(String iuid) throws EJBException, RemoveException, FinderException {
        return this.getWorklistItem(iuid, true);
    }

    private Dataset getWorklistItem(String iuid, boolean remove) throws RemoveException, FinderException {
        GPSPSLocal gpsps;
        try {
            gpsps = this.gpspsHome.findBySopIuid(iuid);
        }
        catch (ObjectNotFoundException onf) {
            return null;
        }
        PatientLocal pat = gpsps.getPatient();
        Dataset attrs = gpsps.getAttributes();
        attrs.putAll((DcmObject)pat.getAttributes(false));
        if (remove) {
            gpsps.remove();
        }
        return attrs;
    }

    public String addWorklistItem(Dataset ds) {
        String iuid = ds.getString(524312);
        if (iuid == null) {
            iuid = UIDGenerator.getInstance().createUID();
            ds.putUI(524312, iuid);
        }
        if (!ds.containsValue(0x404010)) {
            ds.putDT(0x404010, new Date());
        }
        try {
            this.gpspsHome.create(ds, this.findOrCreatePatient(ds));
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        return iuid;
    }

    private PatientLocal findOrCreatePatient(Dataset ds) throws FinderException, CreateException {
        try {
            return this.patHome.selectPatient(ds, this.patientMatching, true);
        }
        catch (ObjectNotFoundException onfe) {
            return this.patHome.create(ds);
        }
    }

    public void updateWorklistItem(Dataset ds) {
        try {
            String iuid = ds.getString(524312);
            GPSPSLocal gpsps = this.gpspsHome.findBySopIuid(iuid);
            Dataset attrs = gpsps.getAttributes();
            attrs.putAll((DcmObject)ds);
            attrs.putDT(0x404010, new Date());
            gpsps.setAttributes(attrs);
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public void modifyStatus(String iuid, Dataset ds) throws DcmServiceException {
        try {
            HashMap<String, Dataset> nextWorkItems = new HashMap<String, Dataset>();
            GPSPSLocal gpsps = this.gpspsHome.findBySopIuid(iuid);
            String tsuid = ds.getString(528789);
            String status = ds.getString(0x404001);
            int statusAsInt = GPSPSStatus.toInt((String)status);
            switch (gpsps.getGpspsStatusAsInt()) {
                case 1: {
                    if (statusAsInt == 1) {
                        throw new DcmServiceException(42243);
                    }
                    if (!tsuid.equals(gpsps.getTransactionUid())) {
                        throw new DcmServiceException(42242);
                    }
                    if (statusAsInt != 3) break;
                    Collection c = gpsps.getGppps();
                    Iterator iter = c.iterator();
                    while (iter.hasNext()) {
                        DcmElement nextItems;
                        Dataset gppps = ((GPPPSLocal)iter.next()).getAttributes();
                        String ppsStatus = gppps.getString(0x404002);
                        if (!ppsStatus.equals("COMPLETED") || (nextItems = gppps.get(4210737)) == null) continue;
                        int n = nextItems.countItems();
                        for (int i = 0; i < n; ++i) {
                            Dataset item = nextItems.getItem(i);
                            String value = item.getString(524544);
                            String scheme = item.getString(524546);
                            if (scheme.equals("DCM") && value.equals("110009")) continue;
                            nextWorkItems.put(value, item);
                        }
                    }
                    break;
                }
                case 3: 
                case 4: {
                    throw new DcmServiceException(42241);
                }
            }
            Dataset attrs = gpsps.getAttributes();
            attrs.putCS(0x404001, status);
            gpsps.setTransactionUid(statusAsInt == 1 ? tsuid : null);
            this.addActualHumanPerformers(attrs, ds.get(4210741));
            attrs.putDT(0x404010, new Date());
            gpsps.setAttributes(attrs);
            if (!nextWorkItems.isEmpty()) {
                Dataset nextSPS = gpsps.getAttributes();
                Dataset patientAttr = gpsps.getPatient().getAttributes(false);
                nextSPS.putAll((DcmObject)patientAttr);
                nextSPS.remove(4210741);
                nextSPS.remove(0x404010);
                nextSPS.putCS(0x404001, "SCHEDULED");
                Collection c = nextWorkItems.values();
                for (Dataset wi : c) {
                    nextSPS.remove(524312);
                    nextSPS.remove(4210712);
                    nextSPS.putSQ(4210712);
                    DcmElement dest = nextSPS.get(4210712);
                    dest.addItem(wi);
                    this.addWorklistItem(nextSPS);
                }
            }
        }
        catch (ObjectNotFoundException e) {
            throw new DcmServiceException(274);
        }
        catch (DcmServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    private void addActualHumanPerformers(Dataset attrs, DcmElement src) {
        Dataset code;
        Dataset item;
        int i;
        int n;
        if (src == null || src.countItems() == 0) {
            return;
        }
        HashSet<String> perfs = new HashSet<String>();
        DcmElement dest = attrs.get(4210741);
        if (dest == null) {
            dest = attrs.putSQ(4210741);
        } else {
            n = dest.countItems();
            for (i = 0; i < n; ++i) {
                item = dest.getItem(i);
                code = item.getItem(0x404009);
                perfs.add(code.getString(524544) + '\\' + code.getString(524546));
            }
        }
        n = src.countItems();
        for (i = 0; i < n; ++i) {
            item = src.getItem(i);
            code = item.getItem(0x404009);
            if (code == null || !perfs.add(code.getString(524544) + '\\' + code.getString(524546))) continue;
            dest.addItem(item);
        }
    }

    public Dataset getOutputInformation(String iuid) throws FinderException {
        Dataset result = DcmObjectFactory.getInstance().newDataset();
        GPSPSLocal gpsps = this.gpspsHome.findBySopIuid(iuid);
        Collection c = gpsps.getGppps();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            Dataset gppps = ((GPPPSLocal)iter.next()).getAttributes();
            result.putAll((DcmObject)gppps.subSet(OUTPUT_INFO_TAGS), 1);
        }
        return result;
    }

    public void addWorklistItem(Dataset wkitem, boolean checkPGP, boolean checkAppend) {
        block8: {
            if (checkPGP || checkAppend) {
                DcmElement reqSeq = wkitem.get(4236144);
                if (reqSeq.countItems() > 1) {
                    log.info((Object)"Detect Group Case - do not check for previous Work Items");
                } else if (!reqSeq.isEmpty()) {
                    try {
                        GPSPSLocal prevWkItem;
                        boolean pgp;
                        String rpid = reqSeq.getItem().getString(0x401001);
                        boolean bl = pgp = checkPGP && this.extendInputInfoIfPGP(wkitem, rpid);
                        if (!pgp && !checkAppend || (prevWkItem = this.findPrevWkItem(rpid, wkitem.getItem(4210712))) == null) break block8;
                        if (pgp) {
                            this.removeRequestFrom(prevWkItem, rpid);
                            break block8;
                        }
                        this.appendInputInfoTo(prevWkItem, rpid, wkitem.get(4210721));
                        return;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new EJBException(e);
                    }
                }
            }
        }
        this.addWorklistItem(wkitem);
    }

    private boolean removeRequestFrom(GPSPSLocal prevWkItem, String rpid) throws RemoveException {
        Collection c = prevWkItem.getRefRequests();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            GPSPSRequestLocal rq = (GPSPSRequestLocal)iter.next();
            if (!rpid.equals(rq.getRequestedProcedureId())) continue;
            Dataset attrs = prevWkItem.getAttributes();
            DcmElement srcSq = attrs.get(4236144);
            DcmElement dstSq = attrs.putSQ(4236144);
            int n = srcSq.countItems();
            for (int i = 0; i < n; ++i) {
                Dataset item = srcSq.getItem(i);
                if (rpid.equals(item.getString(0x401001))) continue;
                dstSq.addItem(item);
            }
            String iuid = attrs.getString(524312);
            if (dstSq.isEmpty()) {
                log.info((Object)("Remove previous Work Item(uid:" + iuid + ") for Requested Procedure(id:" + rpid + ")"));
                prevWkItem.remove();
            } else {
                log.info((Object)("Detach previous Work Item(uid:" + iuid + ") from Requested Procedure(id:" + rpid + ")"));
                iter.remove();
                prevWkItem.setAttributes(attrs);
            }
            return true;
        }
        return false;
    }

    private void appendInputInfoTo(GPSPSLocal wkItem, String rpid, DcmElement srcInputSeq) {
        int numSOP = 0;
        Dataset attrs = wkItem.getAttributes();
        DcmElement destInputSeq = attrs.get(4210721);
        int n = srcInputSeq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset srcSty = srcInputSeq.getItem(i);
            Dataset dstSty = this.selectItem(destInputSeq, srcSty, 0x20000D, 528661);
            DcmElement srcSerSq = srcSty.get(528661);
            DcmElement destSerSq = dstSty.get(528661);
            int m = srcSerSq.countItems();
            for (int j = 0; j < m; ++j) {
                Dataset srcSer = srcSerSq.getItem(j);
                Dataset dstSer = this.selectItem(destSerSq, srcSer, 0x20000E, 528793);
                dstSer.putAE(524372, srcSer.getString(524372));
                DcmElement srcSOPSq = srcSer.get(528793);
                DcmElement destSOPSq = dstSer.get(528793);
                int l = srcSOPSq.countItems();
                for (int k = 0; k < l; ++k) {
                    destSOPSq.addItem(srcSOPSq.getItem(k));
                    ++numSOP;
                }
            }
        }
        String iuid = attrs.getString(524312);
        log.info((Object)("Append Input Information of previous Work Item(uid:" + iuid + ") for Requested Procedure(id:" + rpid + ") with " + numSOP + " references."));
        wkItem.setAttributes(attrs);
    }

    private Dataset selectItem(DcmElement dstSeq, Dataset srcItem, int uidTag, int sqTag) {
        String uid = srcItem.getString(uidTag);
        int n = dstSeq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset sty = dstSeq.getItem(i);
            if (!uid.equals(sty.getString(uidTag))) continue;
            return sty;
        }
        Dataset sty = dstSeq.addNewItem();
        sty.putUI(uidTag, uid);
        sty.putSQ(sqTag);
        return sty;
    }

    private GPSPSLocal findPrevWkItem(String rpid, Dataset code) throws FinderException, CreateException {
        Collection c = this.gpspsHome.findByReqProcId(0, code.getString(524544), code.getString(524546), rpid);
        int numPrevWkItem = c.size();
        return numPrevWkItem == 1 ? (GPSPSLocal)c.iterator().next() : null;
    }

    private boolean extendInputInfoIfPGP(Dataset wkitem, String rpid) throws FinderException {
        Dataset gsps;
        DcmElement inputInfoSeq = wkitem.get(4210721);
        if (inputInfoSeq.countItems() != 1) {
            return false;
        }
        DcmElement seriesSeq = inputInfoSeq.getItem().get(528661);
        if (seriesSeq.countItems() != 1) {
            return false;
        }
        Dataset series = seriesSeq.getItem();
        DcmElement sopSeq = series.get(528793);
        if (sopSeq.countItems() != 1) {
            return false;
        }
        Dataset refSOP = sopSeq.getItem();
        if (!"1.2.840.10008.5.1.4.1.1.11.1".equals(refSOP.getString(528720))) {
            return false;
        }
        String retrieveAET = series.getString(524372);
        String gspsuid = refSOP.getString(528725);
        try {
            gsps = this.instanceHome.findBySopIuid(gspsuid).getAttributes(true);
        }
        catch (ObjectNotFoundException e) {
            log.warn((Object)("No such GSPS object (uid=" + gspsuid + ") - no PGP support"));
            return false;
        }
        DcmElement gspsSeriesSeq = gsps.get(528661);
        int numI = 0;
        int n = gspsSeriesSeq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset gspsSeries = gspsSeriesSeq.getItem(i);
            DcmElement imgSeq = gspsSeries.get(528704);
            series = seriesSeq.addNewItem();
            series.putAE(524372, retrieveAET);
            sopSeq = series.putSQ(528793);
            int m = imgSeq.countItems();
            for (int j = 0; j < m; ++j) {
                Dataset img = imgSeq.getItem(j);
                refSOP = sopSeq.addNewItem();
                refSOP.putUI(528720, img.getString(528720));
                refSOP.putUI(528725, img.getString(528725));
                ++numI;
            }
            series.putUI(0x20000E, gspsSeries.getString(0x20000E));
        }
        log.info((Object)("Detect PGP case - create Work Item for Requested Procedure " + rpid + " referring " + numI + " images"));
        return true;
    }
}

