/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.session;

import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObject;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.ejb.interfaces.CodeLocal;
import org.dcm4chex.archive.ejb.interfaces.CodeLocalHome;
import org.dcm4chex.archive.ejb.interfaces.FileDTO;
import org.dcm4chex.archive.ejb.interfaces.FileLocal;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocal;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocalHome;
import org.dcm4chex.archive.ejb.interfaces.MPPSLocal;
import org.dcm4chex.archive.ejb.interfaces.MPPSLocalHome;
import org.dcm4chex.archive.ejb.interfaces.PatientLocal;
import org.dcm4chex.archive.ejb.interfaces.PatientLocalHome;
import org.dcm4chex.archive.ejb.interfaces.PrivateFileLocal;
import org.dcm4chex.archive.ejb.interfaces.PrivateInstanceLocal;
import org.dcm4chex.archive.ejb.interfaces.PrivateInstanceLocalHome;
import org.dcm4chex.archive.ejb.interfaces.PrivatePatientLocal;
import org.dcm4chex.archive.ejb.interfaces.PrivatePatientLocalHome;
import org.dcm4chex.archive.ejb.interfaces.PrivateSeriesLocal;
import org.dcm4chex.archive.ejb.interfaces.PrivateSeriesLocalHome;
import org.dcm4chex.archive.ejb.interfaces.PrivateStudyLocal;
import org.dcm4chex.archive.ejb.interfaces.PrivateStudyLocalHome;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocal;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocalHome;
import org.dcm4chex.archive.ejb.interfaces.StudyLocal;
import org.dcm4chex.archive.ejb.interfaces.StudyLocalHome;
import org.dcm4chex.archive.util.Convert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContentManagerBean
implements SessionBean {
    private static final int[] MPPS_FILTER_TAGS = new int[]{4194881, 0x400242, 0x400244, 4194885, 4194896, 4194897, 4194898, 4194899, 4194900, 4194901, 4194912, 4194928, 4194945};
    private static final DcmObjectFactory dof = DcmObjectFactory.getInstance();
    private PatientLocalHome patHome;
    private StudyLocalHome studyHome;
    private SeriesLocalHome seriesHome;
    private InstanceLocalHome instanceHome;
    private CodeLocalHome codeHome;
    private PrivatePatientLocalHome privPatHome;
    private PrivateStudyLocalHome privStudyHome;
    private PrivateSeriesLocalHome privSeriesHome;
    private PrivateInstanceLocalHome privInstanceHome;
    private MPPSLocalHome mppsHome;

    public void setSessionContext(SessionContext arg0) throws EJBException, RemoteException {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.patHome = (PatientLocalHome)jndiCtx.lookup("java:comp/env/ejb/Patient");
            this.studyHome = (StudyLocalHome)jndiCtx.lookup("java:comp/env/ejb/Study");
            this.seriesHome = (SeriesLocalHome)jndiCtx.lookup("java:comp/env/ejb/Series");
            this.instanceHome = (InstanceLocalHome)jndiCtx.lookup("java:comp/env/ejb/Instance");
            this.codeHome = (CodeLocalHome)jndiCtx.lookup("java:comp/env/ejb/Code");
            this.privPatHome = (PrivatePatientLocalHome)jndiCtx.lookup("java:comp/env/ejb/PrivatePatient");
            this.privStudyHome = (PrivateStudyLocalHome)jndiCtx.lookup("java:comp/env/ejb/PrivateStudy");
            this.privSeriesHome = (PrivateSeriesLocalHome)jndiCtx.lookup("java:comp/env/ejb/PrivateSeries");
            this.privInstanceHome = (PrivateInstanceLocalHome)jndiCtx.lookup("java:comp/env/ejb/PrivateInstance");
            this.mppsHome = (MPPSLocalHome)jndiCtx.lookup("java:comp/env/ejb/MPPS");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetSessionContext() {
        this.patHome = null;
        this.studyHome = null;
        this.seriesHome = null;
        this.instanceHome = null;
        this.codeHome = null;
        this.privPatHome = null;
        this.privStudyHome = null;
        this.privSeriesHome = null;
        this.privInstanceHome = null;
    }

    public Dataset getPatient(long pk) throws FinderException {
        PatientLocal pat = this.patHome.findByPrimaryKey(new Long(pk));
        return pat.getAttributes(true);
    }

    public Dataset getPatientByID(String pid, String issuer) throws FinderException {
        PatientLocal pat = this.getPatientLocal(pid, issuer);
        if (pat == null) {
            return null;
        }
        if (issuer == null && pat.getIssuerOfPatientId() != null) {
            return null;
        }
        return pat.getAttributes(true);
    }

    public Dataset getStudy(long studyPk) throws FinderException {
        return this.studyHome.findByPrimaryKey(new Long(studyPk)).getAttributes(true);
    }

    public Dataset getStudyByIUID(String studyIUID) throws FinderException {
        return this.studyHome.findByStudyIuid(studyIUID).getAttributes(true);
    }

    public Set<Dataset> getPriorInfos(String studyIUID, boolean instanceLevel, int minAvail, Long createdAfter, String[] retrAETs, String[] modalities) throws FinderException {
        PatientLocal pat = this.studyHome.findByStudyIuid(studyIUID).getPatient();
        Dataset dsPat = pat.getAttributes(true);
        Collection seriess = this.seriesHome.listPriorOfPatient(pat, studyIUID, createdAfter == null ? null : new Timestamp(createdAfter), minAvail, modalities);
        long studyPk = -1L;
        HashSet<Dataset> infos = new HashSet<Dataset>();
        Dataset dsStudy = null;
        for (SeriesLocal series : seriess) {
            Dataset info;
            if (!this.isRetrieveableFrom(series.getRetrieveAETs(), retrAETs)) continue;
            Dataset dsSeries = series.getAttributes(true);
            if (studyPk != series.getStudy().getPk()) {
                dsStudy = series.getStudy().getAttributes(true);
                studyPk = series.getStudy().getPk();
            }
            if (instanceLevel) {
                Iterator itInst = series.getInstances().iterator();
                while (itInst.hasNext()) {
                    info = ((InstanceLocal)itInst.next()).getAttributes(true);
                    info.putAll((DcmObject)dsSeries);
                    info.putAll((DcmObject)dsStudy);
                    info.putAll((DcmObject)dsPat);
                    infos.add(info);
                }
                continue;
            }
            info = dsSeries;
            info.putAll((DcmObject)dsStudy);
            info.putAll((DcmObject)dsPat);
            infos.add(info);
        }
        return infos;
    }

    private boolean isRetrieveableFrom(String retrieveAETs, String[] retrAETs) {
        if (retrAETs == null) {
            return true;
        }
        if (retrieveAETs == null || retrieveAETs.length() < 1) {
            return false;
        }
        String[] aets = StringUtils.split((String)retrieveAETs, (char)'\\');
        for (int i = 0; i < aets.length; ++i) {
            for (int j = 0; j < retrAETs.length; ++j) {
                if (!retrAETs[j].equals(aets[i])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchModality(String mod, String[] mods) {
        if (mods == null) {
            return true;
        }
        for (int i = 0; i < mods.length; ++i) {
            if (!mods[i].equals(mod)) continue;
            return true;
        }
        return false;
    }

    public Dataset getSeries(long seriesPk) throws FinderException {
        return this.seriesHome.findByPrimaryKey(new Long(seriesPk)).getAttributes(true);
    }

    public Dataset getSeriesByIUID(String seriesIUID) throws FinderException {
        return this.seriesHome.findBySeriesIuid(seriesIUID).getAttributes(true);
    }

    public Dataset getInstance(long instancePk) throws FinderException {
        return this.instanceHome.findByPrimaryKey(new Long(instancePk)).getAttributes(true);
    }

    public Dataset getInstanceByIUID(String sopiuid) throws FinderException {
        return this.instanceHome.findBySopIuid(sopiuid).getAttributes(true);
    }

    public Dataset getInstanceInfo(String iuid, boolean supplement) throws FinderException {
        InstanceLocal il = this.instanceHome.findBySopIuid(iuid);
        return this.getInstanceInfo(il, supplement);
    }

    public List listInstanceInfos(String[] iuids, boolean supplement) throws FinderException {
        Collection c = this.instanceHome.listByIUIDs(iuids);
        return this.toDatasetList(c, supplement);
    }

    public List listInstanceInfosByPatientAndSRCode(String pid, String issuer, Collection codes, Collection cuids) throws FinderException {
        PatientLocal pat = this.getPatientLocal(pid, issuer);
        if (pat == null) {
            return null;
        }
        ArrayList<Long> srCodes = null;
        if (codes != null) {
            srCodes = new ArrayList<Long>(codes.size());
            for (Dataset ds : codes) {
                Collection c = this.codeHome.findByValueAndDesignator(ds.getString(524544), ds.getString(524546));
                for (CodeLocal code : c) {
                    srCodes.add(code.getPk());
                }
            }
            if (srCodes.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
        }
        Collection c = this.instanceHome.listByPatientAndSRCode(pat, srCodes, cuids);
        return this.toDatasetList(c, false);
    }

    private PatientLocal getPatientLocal(String pid, String issuer) throws FinderException {
        try {
            return this.patHome.selectPatient(pid, issuer);
        }
        catch (ObjectNotFoundException onfe) {
            return null;
        }
    }

    public List listInstanceInfosByStudyAndSRCode(String suid, String cuid, String code, String designator, boolean supplement) throws FinderException {
        Collection c = this.instanceHome.findByStudyAndSrCode(suid, cuid, code, designator);
        return this.toDatasetList(c, supplement);
    }

    private List toDatasetList(Collection c, boolean supplement) {
        ArrayList<Dataset> list = new ArrayList<Dataset>(c.size());
        for (InstanceLocal il : c) {
            list.add(this.getInstanceInfo(il, supplement));
        }
        return list;
    }

    private Dataset getInstanceInfo(InstanceLocal il, boolean supplement) {
        Dataset ds = il.getAttributes(supplement);
        SeriesLocal series = il.getSeries();
        ds.putAll((DcmObject)series.getAttributes(supplement));
        StudyLocal study = series.getStudy();
        ds.putAll((DcmObject)study.getAttributes(supplement));
        ds.putAll((DcmObject)study.getPatient().getAttributes(supplement));
        return ds;
    }

    public List listStudiesOfPatient(long patientPk) throws FinderException {
        Collection c = this.patHome.findByPrimaryKey(new Long(patientPk)).getStudies();
        ArrayList<Dataset> result = new ArrayList<Dataset>(c.size());
        for (StudyLocal study : c) {
            result.add(study.getAttributes(true));
        }
        return result;
    }

    public List listSeriesOfStudy(long studyPk) throws FinderException {
        Collection c = this.studyHome.findByPrimaryKey(new Long(studyPk)).getSeries();
        ArrayList<Dataset> result = new ArrayList<Dataset>(c.size());
        for (SeriesLocal series : c) {
            result.add(this.mergeMPPSAttr(series.getAttributes(true), series.getMpps()));
        }
        return result;
    }

    private Dataset mergeMPPSAttr(Dataset ds, MPPSLocal mpps) {
        if (mpps != null) {
            ds.putAll((DcmObject)mpps.getAttributes().subSet(MPPS_FILTER_TAGS));
        }
        return ds;
    }

    public List listInstancesOfSeries(long seriesPk) throws FinderException {
        Collection c = this.instanceHome.findBySeriesPk(new Long(seriesPk));
        ArrayList<Dataset> result = new ArrayList<Dataset>(c.size());
        for (InstanceLocal inst : c) {
            result.add(inst.getAttributes(true));
        }
        return result;
    }

    public List listFilesOfInstance(long instancePk) throws FinderException {
        Collection c = this.instanceHome.findByPrimaryKey(new Long(instancePk)).getFiles();
        ArrayList<FileDTO> result = new ArrayList<FileDTO>(c.size());
        for (FileLocal file : c) {
            result.add(file.getFileDTO());
        }
        return result;
    }

    public List listStudiesOfPrivatePatient(long patientPk) throws FinderException {
        Collection c = this.privPatHome.findByPrimaryKey(new Long(patientPk)).getStudies();
        ArrayList<Dataset> result = new ArrayList<Dataset>(c.size());
        for (PrivateStudyLocal study : c) {
            Dataset ds = study.getAttributes();
            ds.setPrivateCreatorID("dcm4che/archive");
            ds.putOB(4390929, Convert.toBytes((long)study.getPk()));
            ds.setPrivateCreatorID(null);
            result.add(ds);
        }
        return result;
    }

    public List listSeriesOfPrivateStudy(long studyPk) throws FinderException {
        Collection c = this.privStudyHome.findByPrimaryKey(new Long(studyPk)).getSeries();
        ArrayList<Dataset> result = new ArrayList<Dataset>(c.size());
        for (PrivateSeriesLocal series : c) {
            String ppsUID;
            Dataset ds = series.getAttributes();
            ds.setPrivateCreatorID("dcm4che/archive");
            ds.putOB(4390930, Convert.toBytes((long)series.getPk()));
            ds.setPrivateCreatorID(null);
            Dataset refPPS = ds.getItem(528657);
            if (refPPS != null && (ppsUID = refPPS.getString(528725)) != null) {
                try {
                    this.mergeMPPSAttr(ds, this.mppsHome.findBySopIuid(ppsUID));
                }
                catch (FinderException ignore) {
                    // empty catch block
                }
            }
            result.add(ds);
        }
        return result;
    }

    public List listInstancesOfPrivateSeries(long seriesPk) throws FinderException {
        Collection c = this.privSeriesHome.findByPrimaryKey(new Long(seriesPk)).getInstances();
        ArrayList<Dataset> result = new ArrayList<Dataset>(c.size());
        for (PrivateInstanceLocal inst : c) {
            Dataset ds = inst.getAttributes();
            ds.setPrivateCreatorID("dcm4che/archive");
            ds.putOB(4390931, Convert.toBytes((long)inst.getPk()));
            result.add(ds);
            ds.setPrivateCreatorID(null);
        }
        return result;
    }

    public List listFilesOfPrivateInstance(long instancePk) throws FinderException {
        Collection c = this.privInstanceHome.findByPrimaryKey(new Long(instancePk)).getFiles();
        ArrayList<FileDTO> result = new ArrayList<FileDTO>(c.size());
        for (PrivateFileLocal file : c) {
            result.add(file.getFileDTO());
        }
        return result;
    }

    public List[] listInstanceFilesToRecover(long pk) throws FinderException {
        List[] result = new List[]{new ArrayList(), new ArrayList()};
        this.addInstanceFilesToRecover(this.privInstanceHome.findByPrimaryKey(new Long(pk)), result, null);
        return result;
    }

    public List[] listSeriesFilesToRecover(long pk) throws FinderException {
        List[] result = new List[]{new ArrayList(), new ArrayList()};
        this.addSeriesToRecover(this.privSeriesHome.findByPrimaryKey(new Long(pk)), result, null);
        return result;
    }

    public List[] listStudyFilesToRecover(long pk) throws FinderException {
        List[] result = new List[]{new ArrayList(), new ArrayList()};
        this.addStudyToRecover(this.privStudyHome.findByPrimaryKey(new Long(pk)), result, null);
        return result;
    }

    public List[] listPatientFilesToRecover(long pk) throws FinderException {
        List[] result = new List[]{new ArrayList(), new ArrayList()};
        PrivatePatientLocal pat = this.privPatHome.findByPrimaryKey(new Long(pk));
        Iterator iter = pat.getStudies().iterator();
        while (iter.hasNext()) {
            this.addStudyToRecover((PrivateStudyLocal)iter.next(), result, pat.getAttributes());
        }
        return result;
    }

    private void addStudyToRecover(PrivateStudyLocal study, List[] result, Dataset patAttrs) throws FinderException {
        Dataset studyAttrs = study.getAttributes();
        if (patAttrs == null) {
            patAttrs = study.getPatient().getAttributes();
        }
        studyAttrs.putAll((DcmObject)patAttrs);
        Iterator iter = study.getSeries().iterator();
        while (iter.hasNext()) {
            this.addSeriesToRecover((PrivateSeriesLocal)iter.next(), result, studyAttrs);
        }
    }

    private void addSeriesToRecover(PrivateSeriesLocal series, List[] result, Dataset studyAttrs) throws FinderException {
        Dataset seriesAttrs = series.getAttributes();
        if (studyAttrs == null) {
            studyAttrs = series.getStudy().getAttributes();
            studyAttrs.putAll((DcmObject)series.getStudy().getPatient().getAttributes());
        }
        seriesAttrs.putAll((DcmObject)studyAttrs);
        Iterator iter = series.getInstances().iterator();
        while (iter.hasNext()) {
            this.addInstanceFilesToRecover((PrivateInstanceLocal)iter.next(), result, seriesAttrs);
        }
    }

    private void addInstanceFilesToRecover(PrivateInstanceLocal instance, List[] result, Dataset seriesAttrs) throws FinderException {
        Dataset instanceAttrs = instance.getAttributes();
        if (seriesAttrs == null) {
            seriesAttrs = instance.getSeries().getAttributes();
            seriesAttrs.putAll((DcmObject)instance.getSeries().getStudy().getAttributes());
            seriesAttrs.putAll((DcmObject)instance.getSeries().getStudy().getPatient().getAttributes());
        }
        instanceAttrs.putAll((DcmObject)seriesAttrs);
        Iterator iter = this.listFilesOfPrivateInstance(instance.getPk()).iterator();
        if (iter.hasNext()) {
            result[0].add(iter.next());
            result[1].add(instanceAttrs);
        }
    }

    public Dataset getSOPInstanceRefMacro(long studyPk, boolean insertModality) throws FinderException {
        Dataset ds = dof.newDataset();
        StudyLocal sl = this.studyHome.findByPrimaryKey(new Long(studyPk));
        ds.putUI(0x20000D, sl.getStudyIuid());
        DcmElement refSerSq = ds.putSQ(528661);
        for (SeriesLocal series : sl.getSeries()) {
            int pos;
            Dataset serDS = refSerSq.addNewItem();
            serDS.putUI(0x20000E, series.getSeriesIuid());
            String aet = series.getRetrieveAETs();
            if (aet != null && (pos = aet.indexOf(92)) != -1) {
                aet = aet.substring(0, pos);
            }
            serDS.putAE(524372, aet);
            serDS.putAE(8913200, series.getFilesetId());
            serDS.putAE(8913216, series.getFilesetIuid());
            if (insertModality) {
                serDS.putCS(524384, series.getModality());
                serDS.putIS(0x200011, series.getSeriesNumber());
            }
            DcmElement refSopSq = serDS.putSQ(528793);
            Collection col = series.getInstances();
            List l = col instanceof List ? (List)col : new ArrayList(col);
            Collections.sort(l, new InstanceNumberComparator());
            for (InstanceLocal instance : l) {
                Dataset instDS = refSopSq.addNewItem();
                instDS.putUI(528725, instance.getSopIuid());
                instDS.putUI(528720, instance.getSopCuid());
            }
        }
        return ds;
    }

    public Collection getSOPInstanceRefMacros(Collection instanceUIDs) throws FinderException {
        HashMap<Long, Dataset> result = new HashMap<Long, Dataset>();
        HashMap<Long, DcmElement> mapRefSopSQ = new HashMap<Long, DcmElement>();
        for (Object o : instanceUIDs) {
            DcmElement refSopSq;
            InstanceLocal instance = o instanceof Long ? this.instanceHome.findByPrimaryKey((Long)o) : this.instanceHome.findBySopIuid(o.toString());
            SeriesLocal series = instance.getSeries();
            StudyLocal study = series.getStudy();
            Dataset ds = (Dataset)result.get(study.getPk());
            if (ds == null) {
                ds = dof.newDataset();
                ds.putUI(0x20000D, study.getStudyIuid());
                ds.putSQ(528661);
                result.put(study.getPk(), ds);
            }
            if ((refSopSq = (DcmElement)mapRefSopSQ.get(series.getPk())) == null) {
                DcmElement refSeriesSq = ds.get(528661);
                Dataset serDS = refSeriesSq.addNewItem();
                serDS.putUI(0x20000E, series.getSeriesIuid());
                String aet = series.getRetrieveAETs();
                if (aet != null) {
                    int pos = aet.indexOf(92);
                    if (pos != -1) {
                        aet = aet.substring(0, pos);
                    }
                    serDS.putAE(524372, aet);
                }
                serDS.putAE(8913200, series.getFilesetId());
                serDS.putAE(8913216, series.getFilesetIuid());
                refSopSq = serDS.putSQ(528793);
                mapRefSopSQ.put(series.getPk(), refSopSq);
            }
            Dataset instDS = refSopSq.addNewItem();
            instDS.putUI(528725, instance.getSopIuid());
            instDS.putUI(528720, instance.getSopCuid());
        }
        return result.values();
    }

    public Dataset getPatientForStudy(long studyPk) throws FinderException {
        StudyLocal sl = this.studyHome.findByPrimaryKey(new Long(studyPk));
        return sl.getPatient().getAttributes(false);
    }

    public Dataset getPatientForStudy(String studyIUID) throws FinderException {
        StudyLocal sl = this.studyHome.findByStudyIuid(studyIUID);
        return sl.getPatient().getAttributes(false);
    }

    public boolean isStudyAvailable(long studyPk, int availability) throws FinderException {
        StudyLocal sl = this.studyHome.findByPrimaryKey(new Long(studyPk));
        return sl.isStudyAvailable(availability);
    }

    public Dataset getHeaderInfo(long patPk, long studyPk, long seriesPk, long instancePk) throws FinderException {
        Dataset ds = dof.newDataset();
        if (patPk != -1L) {
            ds.putAll((DcmObject)this.patHome.findByPrimaryKey(new Long(patPk)).getAttributes(true));
        }
        if (studyPk != -1L) {
            ds.putAll((DcmObject)this.studyHome.findByPrimaryKey(new Long(studyPk)).getAttributes(true));
        }
        if (seriesPk != -1L) {
            ds.putAll((DcmObject)this.seriesHome.findByPrimaryKey(new Long(seriesPk)).getAttributes(true));
        }
        if (instancePk != -1L) {
            ds.putAll((DcmObject)this.instanceHome.findByPrimaryKey(new Long(instancePk)).getAttributes(true));
        }
        return ds;
    }

    public class InstanceNumberComparator
    implements Comparator {
        public int compare(Object arg0, Object arg1) {
            String in0 = ((InstanceLocal)arg0).getInstanceNumber();
            String in1 = ((InstanceLocal)arg1).getInstanceNumber();
            if (in0 == null) {
                return in1 == null ? 0 : 1;
            }
            if (in1 == null) {
                return 0;
            }
            return new Integer(in0).compareTo(new Integer(in1));
        }
    }
}

