/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.session;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObject;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocal;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocalHome;
import org.dcm4chex.archive.ejb.interfaces.MPPSLocal;
import org.dcm4chex.archive.ejb.interfaces.MPPSLocalHome;
import org.dcm4chex.archive.ejb.interfaces.MWLItemLocalHome;
import org.dcm4chex.archive.ejb.interfaces.PatientLocal;
import org.dcm4chex.archive.ejb.interfaces.PatientLocalHome;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocal;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocalHome;
import org.dcm4chex.archive.ejb.interfaces.StudyLocal;
import org.dcm4chex.archive.ejb.interfaces.StudyLocalHome;
import org.dcm4chex.archive.ejb.session.UpdateDerivedFieldsUtils;
import org.dcm4chex.archive.util.Convert;

public abstract class ContentEditBean
implements SessionBean {
    private static final int CHANGE_MODE_NO = 0;
    private static final int CHANGE_MODE_STUDY = 4;
    private static final int CHANGE_MODE_SERIES = 2;
    private static final int CHANGE_MODE_INSTANCE = 1;
    private static final int DELETED = 1;
    private PatientLocalHome patHome;
    private StudyLocalHome studyHome;
    private SeriesLocalHome seriesHome;
    private InstanceLocalHome instHome;
    private MPPSLocalHome mppsHome;
    private MWLItemLocalHome mwlHome;
    private static final DcmObjectFactory dof = DcmObjectFactory.getInstance();
    private static Logger log = Logger.getLogger((String)ContentEditBean.class.getName());

    public void setSessionContext(SessionContext arg0) throws EJBException, RemoteException {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.patHome = (PatientLocalHome)jndiCtx.lookup("java:comp/env/ejb/Patient");
            this.studyHome = (StudyLocalHome)jndiCtx.lookup("java:comp/env/ejb/Study");
            this.seriesHome = (SeriesLocalHome)jndiCtx.lookup("java:comp/env/ejb/Series");
            this.instHome = (InstanceLocalHome)jndiCtx.lookup("java:comp/env/ejb/Instance");
            this.mppsHome = (MPPSLocalHome)jndiCtx.lookup("java:comp/env/ejb/MPPS");
            this.mwlHome = (MWLItemLocalHome)jndiCtx.lookup("java:comp/env/ejb/MWLItem");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetSessionContext() {
        this.patHome = null;
        this.studyHome = null;
        this.seriesHome = null;
        this.instHome = null;
        this.mppsHome = null;
    }

    public Dataset createPatient(Dataset ds) throws CreateException {
        return this.patHome.create(ds).getAttributes(true);
    }

    public Map mergePatients(long patPk, long[] mergedPks, boolean keepPrior) throws EJBException, RemoveException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PatientLocal dominant = this.patHome.findByPrimaryKey(new Long(patPk));
            if (this.checkCircularMerge(dominant, mergedPks)) {
                log.warn((Object)("Circular merge detected (dominant:" + dominant.getPatientId() + "^^^" + dominant.getIssuerOfPatientId() + ")! Merge order ignored!"));
                map.put("ERROR", "Circular Merge detected!");
                return map;
            }
            map.put("DOMINANT", dominant.getAttributes(false));
            Dataset[] mergedPats = new Dataset[mergedPks.length];
            map.put("MERGED", mergedPats);
            ArrayList list = new ArrayList();
            for (int i = 0; i < mergedPks.length; ++i) {
                if (patPk == mergedPks[i]) continue;
                PatientLocal priorPat = this.patHome.findByPrimaryKey(new Long(mergedPks[i]));
                mergedPats[i] = priorPat.getAttributes(false);
                list.addAll(priorPat.getStudies());
                dominant.getStudies().addAll(priorPat.getStudies());
                dominant.getMpps().addAll(priorPat.getMpps());
                dominant.getMwlItems().addAll(priorPat.getMwlItems());
                dominant.getGppps().addAll(priorPat.getGppps());
                dominant.getGsps().addAll(priorPat.getGsps());
                dominant.getUPS().addAll(priorPat.getUPS());
                if (keepPrior) {
                    priorPat.setMergedWith(dominant);
                    continue;
                }
                priorPat.remove();
            }
            ArrayList<Dataset> col = new ArrayList<Dataset>();
            for (StudyLocal sl : list) {
                col.add(this.getStudyMgtDataset(sl, sl.getSeries(), null));
            }
            map.put("NOTIFICATION_DS", col);
            return map;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    private boolean checkCircularMerge(PatientLocal pat, long[] mergedPks) {
        PatientLocal mergedWith = pat.getMergedWith();
        if (mergedWith != null) {
            long pk = mergedWith.getPk();
            for (int i = 0; i < mergedPks.length; ++i) {
                if (pk != mergedPks[i]) continue;
                return true;
            }
            return this.checkCircularMerge(pat, mergedPks);
        }
        return false;
    }

    public Dataset createStudy(Dataset ds, long patPk) throws CreateException {
        try {
            PatientLocal patient = this.patHome.findByPrimaryKey(new Long(patPk));
            Dataset ds1 = this.studyHome.create(ds, patient).getAttributes(true);
            if (log.isDebugEnabled()) {
                log.debug((Object)"createStudy ds1:");
                log.debug((Object)ds1);
            }
            ds1.putAll((DcmObject)patient.getAttributes(true));
            if (log.isDebugEnabled()) {
                log.debug((Object)"createStudy ds1 with patient:");
                log.debug((Object)ds1);
            }
            return ds1;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public Dataset createSeries(Dataset ds, long studyPk) throws CreateException {
        try {
            StudyLocal study = this.studyHome.findByPrimaryKey(new Long(studyPk));
            SeriesLocal series = this.seriesHome.create(ds, study);
            ArrayList<SeriesLocal> col = new ArrayList<SeriesLocal>();
            col.add(series);
            return this.getStudyMgtDataset(study, col, null, 2, series.getAttributes(true));
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public Collection updatePatient(Dataset ds) {
        try {
            ArrayList<Dataset> col = new ArrayList<Dataset>();
            ds.setPrivateCreatorID("dcm4che/archive");
            long pk = Convert.toLong((byte[])ds.getByteBuffer(4390928).array());
            ds.setPrivateCreatorID(null);
            PatientLocal patient = this.patHome.findByPrimaryKey(new Long(pk));
            patient.setAttributes(ds);
            Collection studies = patient.getStudies();
            for (StudyLocal sl : patient.getStudies()) {
                col.add(this.getStudyMgtDataset(sl, sl.getSeries(), null));
            }
            return col;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public Dataset updateStudy(Dataset ds) {
        try {
            ds.setPrivateCreatorID("dcm4che/archive");
            long pk = Convert.toLong((byte[])ds.getByteBuffer(4390929).array());
            ds.setPrivateCreatorID(null);
            StudyLocal study = this.studyHome.findByPrimaryKey(new Long(pk));
            study.setAttributes(ds);
            return this.getStudyMgtDataset(study, study.getSeries(), null, 4, study.getAttributes(true));
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public Dataset updateSeries(Dataset ds) {
        try {
            ds.setPrivateCreatorID("dcm4che/archive");
            long pk = Convert.toLong((byte[])ds.getByteBuffer(4390930).array());
            ds.setPrivateCreatorID(null);
            SeriesLocal series = this.seriesHome.findByPrimaryKey(new Long(pk));
            series.setAttributes(ds);
            StudyLocal study = series.getStudy();
            study.updateModalitiesInStudy();
            study.updateSOPClassesInStudy();
            ArrayList<SeriesLocal> col = new ArrayList<SeriesLocal>();
            col.add(series);
            return this.getStudyMgtDataset(study, col, null, 2, series.getAttributes(true));
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public Collection moveStudies(long[] study_pks, long patient_pk) throws FinderException {
        ArrayList<Dataset> col = new ArrayList<Dataset>();
        PatientLocal pat = this.patHome.findByPrimaryKey(new Long(patient_pk));
        Collection studies = pat.getStudies();
        Dataset dsPat = pat.getAttributes(true);
        for (int i = 0; i < study_pks.length; ++i) {
            StudyLocal study = this.studyHome.findByPrimaryKey(new Long(study_pks[i]));
            PatientLocal oldPat = study.getPatient();
            if (oldPat.isIdentical((EJBLocalObject)pat)) continue;
            this.moveReferencedEntities(study, pat);
            studies.add(study);
            Dataset ds1 = this.getStudyMgtDataset(study, study.getSeries(), null, 4, dsPat);
            col.add(ds1);
        }
        return col;
    }

    private void moveReferencedEntities(StudyLocal study, PatientLocal pat) throws FinderException {
        String suid = study.getStudyIuid();
        Collection mpps = this.mppsHome.findByStudyIuid(suid);
        Collection mwlItems = this.mwlHome.findByStudyIuid(suid);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Update patient references of MWL and MPPS entities because Study has moved!");
            String msgPart = "for study:" + study.getStudyIuid() + " from patient:" + study.getPatient().getPatientId() + " to patient:" + pat.getPatientId();
            log.debug((Object)("Move MPPS (" + mpps + ") " + msgPart));
            log.debug((Object)("Move MWLItems (" + mwlItems + ") " + msgPart));
        }
        pat.getMpps().addAll(mpps);
        pat.getMwlItems().addAll(mwlItems);
    }

    public Dataset moveSeries(long[] series_pks, long study_pk) throws FinderException {
        StudyLocal study = this.studyHome.findByPrimaryKey(new Long(study_pk));
        Collection seriess = study.getSeries();
        ArrayList<SeriesLocal> movedSeriess = new ArrayList<SeriesLocal>();
        for (int i = 0; i < series_pks.length; ++i) {
            SeriesLocal series = this.seriesHome.findByPrimaryKey(new Long(series_pks[i]));
            this.updateMPPSandRemoveRefPPSSeq(series);
            StudyLocal oldStudy = series.getStudy();
            if (oldStudy.isIdentical((EJBLocalObject)study)) continue;
            seriess.add(series);
            movedSeriess.add(series);
            UpdateDerivedFieldsUtils.updateDerivedFieldsOf(oldStudy);
        }
        UpdateDerivedFieldsUtils.updateDerivedFieldsOf(study);
        return this.getStudyMgtDataset(study, movedSeriess, null);
    }

    private void updateMPPSandRemoveRefPPSSeq(SeriesLocal series) {
        MPPSLocal mpps = series.getMpps();
        if (mpps != null) {
            Dataset mppsAttrs = mpps.getAttributes();
            DcmElement pssq = mppsAttrs.get(0x400340);
            DcmElement newPssq = mppsAttrs.putSQ(0x400340);
            String suid = series.getSeriesIuid();
            for (int j = 0; j < pssq.countItems(); ++j) {
                Dataset item = pssq.getItem(j);
                if (item.getString(0x20000E).equals(suid)) continue;
                newPssq.addItem(item);
            }
            mpps.setAttributes(mppsAttrs);
            series.removeMPPS();
        }
        Dataset serAttrs = series.getAttributes(true);
        serAttrs.remove(0x400244);
        serAttrs.remove(4194885);
        serAttrs.remove(528657);
        series.setAttributes(serAttrs);
    }

    public Dataset moveInstances(long[] instance_pks, long series_pk) throws FinderException {
        SeriesLocal series = this.seriesHome.findByPrimaryKey(new Long(series_pk));
        Collection instances = series.getInstances();
        boolean missingSrcAET = series.getSourceAET() == null;
        for (int i = 0; i < instance_pks.length; ++i) {
            InstanceLocal instance = this.instHome.findByPrimaryKey(new Long(instance_pks[i]));
            SeriesLocal oldSeries = instance.getSeries();
            if (oldSeries.isIdentical((EJBLocalObject)series)) continue;
            if (missingSrcAET && oldSeries.getSourceAET() != null) {
                Dataset ds = series.getAttributes(true);
                ds.setPrivateCreatorID("dcm4che/archive");
                ds.putAE(4390932, oldSeries.getSourceAET());
                ds.setPrivateCreatorID(null);
                series.setAttributes(ds);
                missingSrcAET = false;
            }
            instances.add(instance);
            UpdateDerivedFieldsUtils.updateDerivedFieldsOf(oldSeries);
            UpdateDerivedFieldsUtils.updateDerivedFieldsOf(oldSeries.getStudy());
        }
        UpdateDerivedFieldsUtils.updateDerivedFieldsOf(series);
        UpdateDerivedFieldsUtils.updateDerivedFieldsOf(series.getStudy());
        ArrayList<SeriesLocal> col = new ArrayList<SeriesLocal>();
        col.add(series);
        return this.getStudyMgtDataset(series.getStudy(), col, instances);
    }

    public Dataset[] getStudyMgtDatasetForStudies(long[] study_pks) throws FinderException {
        if (study_pks == null || study_pks.length < 1) {
            return new Dataset[0];
        }
        Dataset[] dsStdyMgt = new Dataset[study_pks.length];
        for (int i = 0; i < study_pks.length; ++i) {
            dsStdyMgt[i] = this.getStudyMgtDatasetForStudy(study_pks[i]);
        }
        return dsStdyMgt;
    }

    public Dataset getStudyMgtDatasetForStudy(long study_pk) throws FinderException {
        StudyLocal study = this.studyHome.findByPrimaryKey(new Long(study_pk));
        return this.getStudyMgtDataset(study, study.getSeries(), null);
    }

    public Dataset getStudyMgtDatasetForSeries(long[] seriesPks) throws FinderException {
        if (seriesPks == null || seriesPks.length < 1) {
            return null;
        }
        SeriesLocal series = this.seriesHome.findByPrimaryKey(new Long(seriesPks[0]));
        StudyLocal study = series.getStudy();
        ArrayList<SeriesLocal> seriess = new ArrayList<SeriesLocal>();
        seriess.add(series);
        for (int i = 1; i < seriesPks.length; ++i) {
            seriess.add(this.seriesHome.findByPrimaryKey(new Long(seriesPks[i])));
        }
        return this.getStudyMgtDataset(study, seriess, null);
    }

    public Dataset getStudyMgtDatasetForInstances(long[] instancePks) throws FinderException {
        if (instancePks == null || instancePks.length < 1) {
            return null;
        }
        InstanceLocal il = this.instHome.findByPrimaryKey(Long.valueOf(instancePks[0]));
        SeriesLocal series = il.getSeries();
        StudyLocal study = series.getStudy();
        Dataset ds = dof.newDataset();
        ds.putUI(0x20000D, study.getStudyIuid());
        ds.putSH(524368, study.getAccessionNumber());
        ds.putLO(0x100020, study.getPatient().getPatientId());
        ds.putLO(0x100021, study.getPatient().getIssuerOfPatientId());
        ds.putPN(0x100010, study.getPatient().getPatientName());
        DcmElement refSeriesSeq = ds.putSQ(528661);
        HashMap<Long, Dataset> seriesMap = new HashMap<Long, Dataset>();
        int i = 0;
        while (il != null) {
            DcmElement refSopSeq;
            series = il.getSeries();
            Dataset dsSer = (Dataset)seriesMap.get(series.getPk());
            if (dsSer == null) {
                dsSer = refSeriesSeq.addNewItem();
                refSopSeq = dsSer.putSQ(528793);
                dsSer.putUI(0x20000E, series.getSeriesIuid());
                seriesMap.put(series.getPk(), dsSer);
            } else {
                refSopSeq = dsSer.get(528793);
            }
            Dataset dsInst = refSopSeq.addNewItem();
            dsInst.putUI(528720, il.getSopCuid());
            dsInst.putUI(528725, il.getSopIuid());
            dsInst.putAE(524372, il.getRetrieveAETs());
            il = ++i < instancePks.length ? this.instHome.findByPrimaryKey(Long.valueOf(instancePks[i])) : null;
        }
        return ds;
    }

    private Dataset getStudyMgtDataset(StudyLocal study, Collection series, Collection instances) {
        return this.getStudyMgtDataset(study, series, instances, 0, null);
    }

    private Dataset getStudyMgtDataset(StudyLocal study, Collection series, Collection instances, int chgMode, Dataset changes) {
        Dataset ds = dof.newDataset();
        ds.putUI(0x20000D, study.getStudyIuid());
        log.debug((Object)("getStudyMgtDataset: studyIUID:" + study.getStudyIuid()));
        ds.putSH(524368, study.getAccessionNumber());
        ds.putAll((DcmObject)study.getPatient().getAttributes(false));
        if (chgMode == 4) {
            ds.putAll((DcmObject)changes);
        }
        DcmElement refSeriesSeq = ds.putSQ(528661);
        for (SeriesLocal sl : series) {
            Dataset dsSer = refSeriesSeq.addNewItem();
            if (chgMode == 2) {
                dsSer.putAll((DcmObject)changes);
            }
            dsSer.putUI(0x20000E, sl.getSeriesIuid());
            Collection colInstances = instances != null && series.size() == 1 ? instances : sl.getInstances();
            Iterator iter2 = colInstances.iterator();
            DcmElement refSopSeq = null;
            if (iter2.hasNext()) {
                refSopSeq = dsSer.putSQ(528793);
            }
            while (iter2.hasNext()) {
                InstanceLocal il = (InstanceLocal)iter2.next();
                Dataset dsInst = refSopSeq.addNewItem();
                if (chgMode == 1) {
                    dsInst.putAll((DcmObject)changes);
                }
                dsInst.putUI(528720, il.getSopCuid());
                dsInst.putUI(528725, il.getSopIuid());
                dsInst.putAE(524372, il.getRetrieveAETs());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"return StgMgtDataset:");
            log.debug((Object)ds);
        }
        return ds;
    }
}

