/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.session;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4chex.archive.ejb.entity.CodeBean;
import org.dcm4chex.archive.ejb.interfaces.CodeLocal;
import org.dcm4chex.archive.ejb.interfaces.CodeLocalHome;
import org.dcm4chex.archive.ejb.interfaces.DeviceLocal;
import org.dcm4chex.archive.ejb.interfaces.DeviceLocalHome;

public abstract class CodeToDeviceMappingBean
implements SessionBean {
    private CodeLocalHome codeHome;
    private DeviceLocalHome devHome;
    private static final Logger log = Logger.getLogger(CodeToDeviceMappingBean.class);

    public void setSessionContext(SessionContext arg0) throws EJBException, RemoteException {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.codeHome = (CodeLocalHome)jndiCtx.lookup("java:comp/env/ejb/Code");
            this.devHome = (DeviceLocalHome)jndiCtx.lookup("java:comp/env/ejb/Device");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetSessionContext() {
        this.codeHome = null;
        this.devHome = null;
    }

    public void createMapping(Dataset ds) throws CreateException, FinderException {
        DcmElement spsSeq = ds.get(0x400100);
        int len = spsSeq.countItems();
        for (int i = 0; i < len; ++i) {
            Dataset ds1 = spsSeq.getItem(i);
            DeviceLocal dl = this.getDeviceLocal(ds1);
            ArrayList<CodeLocal> codes = new ArrayList<CodeLocal>();
            DcmElement codeSeq = ds1.get(0x400008);
            int lenCS = codeSeq.countItems();
            for (int j = 0; j < lenCS; ++j) {
                Dataset dsCode = codeSeq.getItem(j);
                codes.add(CodeBean.valueOf(this.codeHome, dsCode));
            }
            dl.setProtocolCodes(codes);
            log.info((Object)("Device " + dl.getStationName() + " mapped to protocols:" + codes));
        }
    }

    private DeviceLocal getDeviceLocal(Dataset ds1) throws FinderException, CreateException {
        String name = ds1.getString(0x400010);
        String aet = ds1.getString(0x400001);
        String modality = ds1.getString(524384);
        DeviceLocal dl = null;
        try {
            dl = this.devHome.findByStationName(name);
        }
        catch (Exception x) {
            // empty catch block
        }
        if (dl == null) {
            dl = this.devHome.create(name, aet, modality);
        }
        return dl;
    }

    public Dataset addScheduledStationInfo(Dataset ds) throws FinderException {
        DcmElement spsSeq = ds.get(0x400100);
        int len = spsSeq.countItems();
        for (int i = 0; i < len; ++i) {
            Dataset sps = spsSeq.getItem(i);
            DeviceLocal device = this.lookupDevice(sps);
            if (device == null) continue;
            sps.putAE(0x400001, device.getStationAET());
            sps.putSH(0x400010, device.getStationName());
            String reqModality = sps.getString(524384);
            if (reqModality == null) {
                sps.putCS(524384, device.getModality());
                continue;
            }
            if (reqModality.equals(device.getModality())) continue;
            log.warn((Object)("Different Modality (" + reqModality + ") in request and device (" + device.getModality() + ") !!!"));
        }
        return ds;
    }

    private DeviceLocal lookupDevice(Dataset sps) throws FinderException {
        String codingScheme;
        Dataset protocol;
        String name = sps.getString(0x400010);
        if (name != null) {
            try {
                return this.devHome.findByStationName(name);
            }
            catch (ObjectNotFoundException ignore) {
                log.warn((Object)("Failed to find device with name: " + name));
            }
        }
        if ((protocol = sps.getItem(0x400008)) == null) {
            return null;
        }
        String codeValue = protocol.getString(524544);
        Collection col = this.codeHome.findByValueAndDesignator(codeValue, codingScheme = protocol.getString(524546));
        if (col.isEmpty()) {
            log.warn((Object)("Failed to find device for unkown Protocol Code: " + codeValue + '^' + codingScheme));
            return null;
        }
        Collection col1 = this.devHome.findByProtocolCode((CodeLocal)col.iterator().next());
        if (col1.isEmpty()) {
            log.warn((Object)("Failed to find device for Protocol Code: " + codeValue + '^' + codingScheme));
            return null;
        }
        return (DeviceLocal)col1.iterator().next();
    }

    public boolean deleteDevice(String stationName) throws FinderException, EJBException, RemoveException {
        DeviceLocal dl = this.devHome.findByStationName(stationName);
        if (dl == null) {
            return false;
        }
        this.deleteDevice(dl);
        return true;
    }

    private void deleteDevice(DeviceLocal dl) throws EJBException, RemoveException {
        ArrayList col = new ArrayList();
        col.addAll(dl.getProtocolCodes());
        String name = dl.getStationName();
        log.info((Object)("Delete device:" + name));
        dl.remove();
        for (CodeLocal code : col) {
            log.info((Object)("Delete protocol code for device (" + name + "):" + code.getCodeValue() + "(" + code.getCodingSchemeDesignator() + ")"));
            try {
                code.remove();
            }
            catch (Exception x) {
                log.error((Object)("Cant delete code ('" + code.getCodeValue() + "')!!!"));
            }
        }
    }

    public boolean deleteMapping() throws FinderException, EJBException, RemoveException {
        Collection col = this.devHome.findAll();
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            this.deleteDevice((DeviceLocal)iter.next());
        }
        return true;
    }
}

