/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.session;

import java.util.Date;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.DcmServiceException;
import org.dcm4chex.archive.common.PatientMatching;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocal;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocalHome;
import org.dcm4chex.archive.ejb.interfaces.MPPSLocalHome;
import org.dcm4chex.archive.ejb.interfaces.MWLItemLocalHome;
import org.dcm4chex.archive.ejb.interfaces.PatientLocal;
import org.dcm4chex.archive.ejb.interfaces.PatientLocalHome;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocal;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocalHome;
import org.dcm4chex.archive.ejb.interfaces.StudyLocal;
import org.dcm4chex.archive.ejb.interfaces.StudyLocalHome;
import org.dcm4chex.archive.ejb.session.StorageBean;
import org.dcm4chex.archive.exceptions.NonUniquePatientException;

public abstract class AttributesModificationBean
implements SessionBean {
    private static Logger log = Logger.getLogger(StorageBean.class);
    private PatientLocalHome patHome;
    private StudyLocalHome studyHome;
    private SeriesLocalHome seriesHome;
    private InstanceLocalHome instHome;
    private MPPSLocalHome mppsHome;
    private MWLItemLocalHome mwlHome;

    public void setSessionContext(SessionContext ctx) {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.patHome = (PatientLocalHome)jndiCtx.lookup("java:comp/env/ejb/Patient");
            this.studyHome = (StudyLocalHome)jndiCtx.lookup("java:comp/env/ejb/Study");
            this.seriesHome = (SeriesLocalHome)jndiCtx.lookup("java:comp/env/ejb/Series");
            this.instHome = (InstanceLocalHome)jndiCtx.lookup("java:comp/env/ejb/Instance");
            this.mppsHome = (MPPSLocalHome)jndiCtx.lookup("java:comp/env/ejb/MPPS");
            this.mwlHome = (MWLItemLocalHome)jndiCtx.lookup("java:comp/env/ejb/MWLItem");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetSessionContext() {
        this.patHome = null;
        this.studyHome = null;
        this.seriesHome = null;
        this.instHome = null;
    }

    public boolean modifyAttributes(Dataset attrs, Date time, String system, String reason, boolean updateOriginalAttributesSeq, int entityNotFoundErrorCode) throws DcmServiceException {
        try {
            String level = attrs.getString(524370);
            if (level == null) {
                throw new IllegalArgumentException("Missing Query/Retrieve Level");
            }
            if ("IMAGE".equals(level)) {
                return this.updateInstanceAttrs(attrs, time, system, reason, updateOriginalAttributesSeq);
            }
            if ("SERIES".equals(level)) {
                return this.updateSeriesAttrs(attrs, time, system, reason, updateOriginalAttributesSeq);
            }
            if ("STUDY".equals(level)) {
                return this.updateStudyAttrs(attrs, time, system, reason, updateOriginalAttributesSeq);
            }
            throw new IllegalArgumentException("Illegal Query/Retrieve Level: " + level);
        }
        catch (IllegalArgumentException e) {
            throw new DcmServiceException(43264, e.getMessage());
        }
        catch (ObjectNotFoundException e) {
            if (entityNotFoundErrorCode != 0) {
                throw new DcmServiceException(entityNotFoundErrorCode, "No entity with specified uid found");
            }
            log.info((Object)"No entity with specified uid found - ignore update:");
            log.debug((Object)attrs);
            return false;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    private boolean updateStudyAttrs(Dataset attrs, Date time, String system, String reason, boolean updateOriginalAttributesSeq) throws FinderException {
        Dataset origAttrs;
        String styiuid = attrs.getString(0x20000D);
        if (styiuid == null) {
            throw new IllegalArgumentException("Missing Study Instance UID");
        }
        StudyLocal study = this.studyHome.findByStudyIuid(styiuid);
        Dataset dataset = origAttrs = updateOriginalAttributesSeq ? DcmObjectFactory.getInstance().newDataset() : null;
        if (!study.updateAttributes(attrs, origAttrs)) {
            return false;
        }
        if (updateOriginalAttributesSeq) {
            this.updateOriginalAttributesSeq(study, time, system, reason, origAttrs);
        }
        return true;
    }

    private boolean updateSeriesAttrs(Dataset attrs, Date time, String system, String reason, boolean updateOriginalAttributesSeq) throws FinderException {
        Dataset origAttrs;
        String seriuid = attrs.getString(0x20000E);
        if (seriuid == null) {
            throw new IllegalArgumentException("Missing Series Instance UID");
        }
        SeriesLocal series = this.seriesHome.findBySeriesIuid(seriuid);
        Dataset dataset = origAttrs = updateOriginalAttributesSeq ? DcmObjectFactory.getInstance().newDataset() : null;
        if (!series.updateAttributes(attrs, true, origAttrs)) {
            return false;
        }
        if (updateOriginalAttributesSeq) {
            this.updateOriginalAttributesSeq(series, time, system, reason, origAttrs);
        }
        return true;
    }

    private boolean updateInstanceAttrs(Dataset attrs, Date time, String system, String reason, boolean updateOriginalAttributesSeq) throws FinderException {
        Dataset origAttrs;
        String sopiuid = attrs.getString(524312);
        if (sopiuid == null) {
            throw new IllegalArgumentException("Missing SOP Instance UID");
        }
        InstanceLocal inst = this.instHome.findBySopIuid(sopiuid);
        Dataset dataset = origAttrs = updateOriginalAttributesSeq ? DcmObjectFactory.getInstance().newDataset() : null;
        if (!inst.updateAttributes(attrs, origAttrs)) {
            return false;
        }
        if (updateOriginalAttributesSeq) {
            this.updateOriginalAttributesSeq(inst, time, system, reason, origAttrs);
        }
        return true;
    }

    public boolean moveStudyToPatient(Dataset attrs, PatientMatching matching, boolean create) throws FinderException, RemoveException, CreateException {
        String[] suids = attrs.getStrings(0x20000D);
        if (suids == null || suids.length == 0) {
            throw new IllegalArgumentException("Missing Study Instance UID for moveStudyToPatient");
        }
        StudyLocal study = this.studyHome.findByStudyIuid(suids[0]);
        PatientLocal pat = this.getPatient(attrs, matching, create);
        if (pat != null && !pat.isIdentical((EJBLocalObject)study.getPatient())) {
            for (int i = 0; i < suids.length; ++i) {
                pat.getMpps().addAll(this.mppsHome.findByStudyIuid(suids[i]));
                pat.getMwlItems().addAll(this.mwlHome.findByStudyIuid(suids[i]));
                pat.getStudies().add(i == 0 ? study : this.studyHome.findByStudyIuid(suids[i]));
            }
            return true;
        }
        return false;
    }

    private void updateOriginalAttributesSeq(StudyLocal study, Date time, String system, String reason, Dataset origAttrs) {
        Iterator iter = study.getSeries().iterator();
        while (iter.hasNext()) {
            this.updateOriginalAttributesSeq((SeriesLocal)iter.next(), time, system, reason, origAttrs);
        }
    }

    private void updateOriginalAttributesSeq(SeriesLocal series, Date time, String system, String reason, Dataset origAttrs) {
        Iterator iter = series.getInstances().iterator();
        while (iter.hasNext()) {
            this.updateOriginalAttributesSeq((InstanceLocal)iter.next(), time, system, reason, origAttrs);
        }
    }

    private void updateOriginalAttributesSeq(InstanceLocal inst, Date time, String system, String reason, Dataset origAttrs) {
        Dataset attrs = inst.getAttributes(false);
        DcmElement origAttrsSeq = attrs.get(67110241);
        if (origAttrsSeq == null) {
            origAttrsSeq = attrs.putSQ(67110241);
        }
        Dataset origAttrsItem = origAttrsSeq.addNewItem();
        origAttrsItem.putLO(67110244);
        origAttrsItem.putDT(67110242, time);
        origAttrsItem.putLO(67110243, system);
        origAttrsItem.putCS(67110245, reason);
        origAttrsItem.putSQ(0x4000550).addItem(origAttrs);
        inst.setAttributes(attrs);
    }

    private PatientLocal getPatient(Dataset attrs, PatientMatching matching, boolean create) throws FinderException, NonUniquePatientException, RemoveException, CreateException {
        PatientLocal pat;
        block12: {
            try {
                return this.patHome.selectPatient(attrs, matching, true);
            }
            catch (ObjectNotFoundException onfe) {
                if (create) {
                    try {
                        pat = this.patHome.create(attrs);
                        try {
                            return this.patHome.selectPatient(attrs, matching, true);
                        }
                        catch (NonUniquePatientException nupe) {
                            pat.remove();
                            pat = this.patHome.selectPatient(attrs, matching, true);
                            break block12;
                        }
                        catch (ObjectNotFoundException onfe2) {
                            return pat;
                        }
                    }
                    catch (CreateException ce) {
                        try {
                            pat = this.patHome.selectPatient(attrs, matching, true);
                            break block12;
                        }
                        catch (ObjectNotFoundException onfe2) {
                            throw ce;
                        }
                    }
                }
                throw onfe;
            }
            catch (NonUniquePatientException nupe) {
                if (create) {
                    return this.patHome.create(attrs);
                }
                throw nupe;
            }
        }
        return pat;
    }
}

