/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.entity;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.PersonName;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.entity.IssuerBean;
import org.dcm4chex.archive.ejb.interfaces.IssuerLocal;
import org.dcm4chex.archive.ejb.interfaces.IssuerLocalHome;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocal;

public abstract class SeriesRequestBean
implements EntityBean {
    private static final Logger log = Logger.getLogger(SeriesRequestBean.class);
    private IssuerLocalHome issuerHome;

    public void setEntityContext(EntityContext ctx) {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.issuerHome = (IssuerLocalHome)jndiCtx.lookup("java:comp/env/ejb/Issuer");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetEntityContext() {
        this.issuerHome = null;
    }

    public Long ejbCreate(Dataset ds, SeriesLocal series) throws CreateException {
        AttributeFilter filter = AttributeFilter.getSeriesAttributeFilter();
        this.setAccessionNumber(ds.getString(524368));
        this.setStudyIuid(ds.getString(0x20000D));
        this.setRequestedProcedureId(filter.getString(ds, 0x401001));
        this.setSpsId(filter.getString(ds, 0x400009));
        this.setRequestingService(filter.getString(ds, 3280947));
        PersonName pn = ds.getPersonName(3280946);
        if (pn != null) {
            PersonName ppn;
            this.setRequestingPhysician(filter.toUpperCase(pn.toComponentGroupString(false), 3280946));
            PersonName ipn = pn.getIdeographic();
            if (ipn != null) {
                this.setRequestingPhysicianIdeographicName(ipn.toComponentGroupString(false));
            }
            if ((ppn = pn.getPhonetic()) != null) {
                this.setRequestingPhysicianPhoneticName(ppn.toComponentGroupString(false));
            }
        }
        if (AttributeFilter.isSoundexEnabled()) {
            this.setRequestingPhysicianFamilyNameSoundex(AttributeFilter.toSoundex((PersonName)pn, (int)0, (String)"*"));
            this.setRequestingPhysicianGivenNameSoundex(AttributeFilter.toSoundex((PersonName)pn, (int)1, (String)"*"));
        }
        return null;
    }

    public void ejbPostCreate(Dataset ds, SeriesLocal series) throws CreateException {
        this.setSeries(series);
        try {
            this.setIssuerOfAccessionNumber(IssuerBean.valueOf(this.issuerHome, ds.getItem(524369)));
        }
        catch (FinderException e) {
            throw new CreateException(e.getMessage());
        }
        log.info((Object)("Created " + this.prompt()));
    }

    public void ejbRemove() throws RemoveException {
        log.info((Object)("Deleting " + this.prompt()));
    }

    public abstract Long getPk();

    public abstract void setPk(Long var1);

    public abstract String getAccessionNumber();

    public abstract void setAccessionNumber(String var1);

    public abstract String getStudyIuid();

    public abstract void setStudyIuid(String var1);

    public abstract String getRequestedProcedureId();

    public abstract void setRequestedProcedureId(String var1);

    public abstract String getSpsId();

    public abstract void setSpsId(String var1);

    public abstract String getRequestingService();

    public abstract void setRequestingService(String var1);

    public abstract String getRequestingPhysician();

    public abstract void setRequestingPhysician(String var1);

    public abstract String getRequestingPhysicianFamilyNameSoundex();

    public abstract void setRequestingPhysicianFamilyNameSoundex(String var1);

    public abstract String getRequestingPhysicianGivenNameSoundex();

    public abstract void setRequestingPhysicianGivenNameSoundex(String var1);

    public abstract String getRequestingPhysicianIdeographicName();

    public abstract void setRequestingPhysicianIdeographicName(String var1);

    public abstract String getRequestingPhysicianPhoneticName();

    public abstract void setRequestingPhysicianPhoneticName(String var1);

    public abstract void setSeries(SeriesLocal var1);

    public abstract IssuerLocal getIssuerOfAccessionNumber();

    public abstract void setIssuerOfAccessionNumber(IssuerLocal var1);

    public abstract SeriesLocal getSeries();

    private String prompt() {
        return "SeriesRequestAttribute[pk=" + this.getPk() + ", accno=" + this.getAccessionNumber() + ", rpid=" + this.getRequestedProcedureId() + ", spsid=" + this.getSpsId() + ", service=" + this.getRequestingService() + ", phys=" + this.getRequestingPhysician() + ", series->" + this.getSeries() + "]";
    }
}

