/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.entity;

import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import org.apache.log4j.Logger;
import org.dcm4chex.archive.ejb.interfaces.OtherPatientIDLocal;
import org.dcm4chex.archive.ejb.interfaces.OtherPatientIDLocalHome;

public abstract class OtherPatientIDBean
implements EntityBean {
    private static final Logger log = Logger.getLogger(OtherPatientIDBean.class);
    private EntityContext ctx;

    public void setEntityContext(EntityContext ctx) {
        this.ctx = ctx;
    }

    public void unsetEntityContext() {
        this.ctx = null;
    }

    public OtherPatientIDLocal ejbHomeValueOf(String pid, String issuer) {
        OtherPatientIDLocalHome opidhome = (OtherPatientIDLocalHome)this.ctx.getEJBLocalHome();
        try {
            try {
                return opidhome.findByPatientIdAndIssuer(pid, issuer);
            }
            catch (ObjectNotFoundException findEx) {
                try {
                    return opidhome.create(pid, issuer);
                }
                catch (CreateException createEx) {
                    log.debug((Object)"Can neither find nor create. Retry to find.");
                    OtherPatientIDLocal opidLocal = opidhome.findByPatientIdAndIssuer(pid, issuer);
                    log.debug((Object)"Found now the other patient ID in the retry.");
                    return opidLocal;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Fail to find or to create other-patient-id: " + pid + "^^^" + issuer));
            throw new EJBException(e);
        }
    }

    public Long ejbCreate(String pid, String issuer) throws CreateException {
        this.setPatientId(pid);
        this.setIssuerOfPatientId(issuer);
        return null;
    }

    public void ejbPostCreate(String id, String issuer) throws CreateException {
        log.info((Object)("Created " + this));
    }

    public void ejbRemove() throws RemoveException {
        log.info((Object)("Deleting " + this));
    }

    public abstract Long getPk();

    public abstract void setPk(Long var1);

    public abstract String getPatientId();

    public abstract void setPatientId(String var1);

    public abstract String getIssuerOfPatientId();

    public abstract void setIssuerOfPatientId(String var1);

    public abstract Collection getPatients();

    public abstract void setPatients(Collection var1);

    public String toString() {
        return "OtherPatientId(id=" + this.getPatientId() + ", issuer=" + this.getIssuerOfPatientId() + ")";
    }
}

