/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.entity;

import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.PersonName;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.common.SPSStatus;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.interfaces.PatientLocal;

public abstract class MWLItemBean
implements EntityBean {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final Logger log = Logger.getLogger(MWLItemBean.class);
    private String spsIdPrefix;
    private String rpIdPrefix;

    public void setEntityContext(EntityContext arg0) throws EJBException, RemoteException {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.spsIdPrefix = (String)jndiCtx.lookup("java:comp/env/SpsIdPrefix");
            this.rpIdPrefix = (String)jndiCtx.lookup("java:comp/env/RpIdPrefix");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public abstract Long getPk();

    public abstract void setPk(Long var1);

    public abstract Timestamp getCreatedTime();

    public abstract void setCreatedTime(Timestamp var1);

    public abstract Timestamp getUpdatedTime();

    public abstract void setUpdatedTime(Timestamp var1);

    public abstract String getSpsId();

    public abstract void setSpsId(String var1);

    public abstract Timestamp getSpsStartDateTime();

    public abstract void setSpsStartDateTime(Timestamp var1);

    public abstract String getScheduledStationAET();

    public abstract void setScheduledStationAET(String var1);

    public abstract String getScheduledStationName();

    public abstract void setScheduledStationName(String var1);

    public abstract String getModality();

    public abstract void setModality(String var1);

    public abstract String getPerformingPhysicianName();

    public abstract void setPerformingPhysicianName(String var1);

    public abstract String getPerformingPhysicianFamilyNameSoundex();

    public abstract void setPerformingPhysicianFamilyNameSoundex(String var1);

    public abstract String getPerformingPhysicianGivenNameSoundex();

    public abstract void setPerformingPhysicianGivenNameSoundex(String var1);

    public abstract String getPerformingPhysicianIdeographicName();

    public abstract void setPerformingPhysicianIdeographicName(String var1);

    public abstract String getPerformingPhysicianPhoneticName();

    public abstract void setPerformingPhysicianPhoneticName(String var1);

    public abstract String getRequestedProcedureId();

    public abstract void setRequestedProcedureId(String var1);

    public abstract String getAccessionNumber();

    public abstract void setAccessionNumber(String var1);

    public abstract String getStudyIuid();

    public abstract void setStudyIuid(String var1);

    public abstract byte[] getEncodedAttributes();

    public abstract void setEncodedAttributes(byte[] var1);

    public abstract void setPatient(PatientLocal var1);

    public abstract PatientLocal getPatient();

    public Long ejbCreate(Dataset ds, PatientLocal patient) throws CreateException {
        this.setAttributes(ds);
        return null;
    }

    public void ejbPostCreate(Dataset ds, PatientLocal patient) throws CreateException {
        this.setPatient(patient);
        this.addMissingIds(ds);
        log.info((Object)("Created " + this.prompt()));
    }

    private void addMissingIds(Dataset ds) {
        Dataset spsItem;
        boolean dirty = false;
        if (ds.getString(0x401001) == null) {
            ds.putSH(0x401001, this.rpIdPrefix + this.getPk());
            dirty = true;
        }
        if ((spsItem = ds.getItem(0x400100)).getString(0x400009) == null) {
            spsItem.putSH(0x400009, this.spsIdPrefix + this.getPk());
            dirty = true;
        }
        if (dirty) {
            this.setAttributes(ds);
        }
    }

    public void ejbRemove() throws RemoveException {
        log.info((Object)("Deleting " + this.prompt()));
    }

    public Dataset getAttributes() {
        return DatasetUtils.fromByteArray((byte[])this.getEncodedAttributes());
    }

    public void setAttributes(Dataset ds) {
        Dataset spsItem = ds.getItem(0x400100);
        if (spsItem == null) {
            throw new IllegalArgumentException("Missing Scheduled Procedure Step Sequence (0040,0100) Item");
        }
        this.setSpsId(spsItem.getString(0x400009));
        this.setSpsStatus(spsItem.getString(0x400020, "SCHEDULED"));
        this.setSpsStartDateTime(spsItem.getDateTime(0x400002, 0x400003));
        this.setScheduledStationAET(spsItem.getString(0x400001));
        this.setScheduledStationName(spsItem.getString(0x400010));
        PersonName pn = spsItem.getPersonName(0x400006);
        if (pn != null) {
            PersonName ppn;
            this.setPerformingPhysicianName(MWLItemBean.toUpperCase(pn.toComponentGroupString(false)));
            PersonName ipn = pn.getIdeographic();
            if (ipn != null) {
                this.setPerformingPhysicianIdeographicName(ipn.toComponentGroupString(false));
            }
            if ((ppn = pn.getPhonetic()) != null) {
                this.setPerformingPhysicianPhoneticName(ppn.toComponentGroupString(false));
            }
        }
        if (AttributeFilter.isSoundexEnabled()) {
            this.setPerformingPhysicianFamilyNameSoundex(AttributeFilter.toSoundex((PersonName)pn, (int)0, (String)"*"));
            this.setPerformingPhysicianGivenNameSoundex(AttributeFilter.toSoundex((PersonName)pn, (int)1, (String)"*"));
        }
        this.setModality(spsItem.getString(524384));
        this.setRequestedProcedureId(ds.getString(0x401001));
        this.setAccessionNumber(ds.getString(524368));
        this.setStudyIuid(ds.getString(0x20000D));
        AttributeFilter filter = AttributeFilter.getExcludePatientAttributeFilter();
        byte[] b = DatasetUtils.toByteArray((Dataset)ds, (String)filter.getTransferSyntaxUID());
        if (log.isDebugEnabled()) {
            log.debug((Object)("setEncodedAttributes(byte[" + b.length + "])"));
        }
        this.setEncodedAttributes(b);
    }

    private static String toUpperCase(String s) {
        return s != null ? s.toUpperCase() : null;
    }

    private void setSpsStartDateTime(Date date) {
        this.setSpsStartDateTime(date != null ? new Timestamp(date.getTime()) : null);
    }

    public abstract int getSpsStatusAsInt();

    public abstract void setSpsStatusAsInt(int var1);

    public String getSpsStatus() {
        return SPSStatus.toString((int)this.getSpsStatusAsInt());
    }

    public void setSpsStatus(String status) {
        this.setSpsStatusAsInt(SPSStatus.toInt((String)status));
    }

    public void updateSpsStatus(int status) {
        if (status == this.getSpsStatusAsInt()) {
            return;
        }
        Dataset ds = this.getAttributes();
        Dataset spsItem = ds.getItem(0x400100);
        spsItem.putCS(0x400020, SPSStatus.toString((int)status));
        this.setSpsStatusAsInt(status);
        byte[] b = DatasetUtils.toByteArray((Dataset)ds, (String)"1.2.840.10008.1.2.1.99");
        if (log.isDebugEnabled()) {
            log.debug((Object)("setEncodedAttributes(byte[" + b.length + "])"));
        }
        this.setEncodedAttributes(b);
    }

    public String asString() {
        return this.prompt();
    }

    private String prompt() {
        Timestamp spsDT = this.getSpsStartDateTime();
        return "MWLItem[pk=" + this.getPk() + ", spsId=" + this.getSpsId() + ", spsStartDateTime=" + (spsDT != null ? new SimpleDateFormat(DATE_FORMAT).format(spsDT) : "") + ", spsStatus=" + this.getSpsStatus() + ", stationAET=" + this.getScheduledStationAET() + ", rqProcId=" + this.getRequestedProcedureId() + ", modality=" + this.getModality() + ", accessionNo=" + this.getAccessionNumber() + ", patient->" + this.getPatient() + "]";
    }
}

