/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.entity;

import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4chex.archive.ejb.entity.CodeBean;
import org.dcm4chex.archive.ejb.interfaces.CodeLocalHome;
import org.dcm4chex.archive.ejb.interfaces.HPLocal;

public abstract class HPDefinitionBean
implements EntityBean {
    private static final Logger log = Logger.getLogger(HPDefinitionBean.class);
    private CodeLocalHome codeHome;

    public void setEntityContext(EntityContext ctx) {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.codeHome = (CodeLocalHome)jndiCtx.lookup("java:comp/env/ejb/Code");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetEntityContext() {
        this.codeHome = null;
    }

    public Long ejbCreate(Dataset ds, HPLocal hp) throws CreateException {
        this.setModality(ds.getString(524384));
        this.setLaterality(ds.getString(0x200060));
        return null;
    }

    public void ejbPostCreate(Dataset ds, HPLocal hp) throws CreateException {
        this.setHP(hp);
        try {
            this.initCodes(ds.get(533016), this.getAnatomicRegionCodes());
            this.initCodes(ds.get(528434), this.getProcedureCodes());
            this.initCodes(ds.get(4198410), this.getReasonforRequestedProcedureCodes());
        }
        catch (CreateException e) {
            throw new CreateException(e.getMessage());
        }
        catch (FinderException e) {
            throw new CreateException(e.getMessage());
        }
        log.info((Object)("Created " + this.toString()));
    }

    private void initCodes(DcmElement sq, Collection c) throws CreateException, FinderException {
        if (sq == null) {
            return;
        }
        int n = sq.countItems();
        for (int i = 0; i < n; ++i) {
            c.add(CodeBean.valueOf(this.codeHome, sq.getItem(i)));
        }
    }

    public void ejbRemove() throws RemoveException {
        log.info((Object)("Deleting " + this.toString()));
    }

    public abstract Long getPk();

    public abstract void setPk(Long var1);

    public abstract void setHP(HPLocal var1);

    public abstract HPLocal getHP();

    public abstract String getModality();

    public abstract void setModality(String var1);

    public abstract String getLaterality();

    public abstract void setLaterality(String var1);

    public abstract Collection getAnatomicRegionCodes();

    public abstract void setAnatomicRegionCodes(Collection var1);

    public abstract Collection getProcedureCodes();

    public abstract void setProcedureCodes(Collection var1);

    public abstract Collection getReasonforRequestedProcedureCodes();

    public abstract void setReasonforRequestedProcedureCodes(Collection var1);

    public String toString() {
        return "HPDefinition[pk=" + this.getPk() + ", hp->" + this.getHP() + "]";
    }
}

