/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.entity;

import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.common.HPLevel;
import org.dcm4chex.archive.ejb.entity.CodeBean;
import org.dcm4chex.archive.ejb.interfaces.CodeLocal;
import org.dcm4chex.archive.ejb.interfaces.CodeLocalHome;
import org.dcm4chex.archive.ejb.interfaces.HPDefinitionLocalHome;
import org.dcm4chex.archive.ejb.interfaces.HPLocal;

public abstract class HPBean
implements EntityBean {
    private static final Logger log = Logger.getLogger(HPBean.class);
    private EntityContext ejbctx;
    private CodeLocalHome codeHome;
    private HPDefinitionLocalHome defHome;

    public void setEntityContext(EntityContext ctx) {
        this.ejbctx = ctx;
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.codeHome = (CodeLocalHome)jndiCtx.lookup("java:comp/env/ejb/Code");
            this.defHome = (HPDefinitionLocalHome)jndiCtx.lookup("java:comp/env/ejb/HPDefinition");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetEntityContext() {
        this.codeHome = null;
        this.defHome = null;
        this.ejbctx = null;
    }

    public Long ejbCreate(Dataset ds) throws CreateException {
        this.setAttributes(ds);
        return null;
    }

    public void ejbPostCreate(Dataset ds) throws CreateException {
        try {
            this.setHangingProtocolUserIdCode(CodeBean.valueOf(this.codeHome, ds.getItem(7471118)));
            this.createHPDefinition(ds.get(7471116));
        }
        catch (CreateException e) {
            throw new CreateException(e.getMessage());
        }
        catch (FinderException e) {
            throw new CreateException(e.getMessage());
        }
        log.info((Object)("Created " + this.toString()));
    }

    private void createHPDefinition(DcmElement sq) throws CreateException {
        if (sq == null) {
            return;
        }
        Collection c = this.getHPDefinition();
        HPLocal hp = (HPLocal)this.ejbctx.getEJBLocalObject();
        int n = sq.countItems();
        for (int i = 0; i < n; ++i) {
            c.add(this.defHome.create(sq.getItem(i), hp));
        }
    }

    public void ejbRemove() throws RemoveException {
        log.info((Object)("Deleting " + this.toString()));
    }

    public String toString() {
        return "HP[pk=" + this.getPk() + ", iuid=" + this.getSopIuid() + "]";
    }

    public abstract Long getPk();

    public abstract void setPk(Long var1);

    public abstract String getSopIuid();

    public abstract void setSopIuid(String var1);

    public abstract String getSopCuid();

    public abstract void setSopCuid(String var1);

    public abstract String getHangingProtocolName();

    public abstract void setHangingProtocolName(String var1);

    public abstract int getHangingProtocolLevelAsInt();

    public abstract void setHangingProtocolLevelAsInt(int var1);

    public String getHangingProtocolLevel() {
        return HPLevel.toString((int)this.getHangingProtocolLevelAsInt());
    }

    public void setHangingProtocolLevel(String level) {
        this.setHangingProtocolLevelAsInt(HPLevel.toInt((String)level));
    }

    public abstract int getNumberOfPriorsReferenced();

    public abstract void setNumberOfPriorsReferenced(int var1);

    public abstract String getHangingProtocolUserGroupName();

    public abstract void setHangingProtocolUserGroupName(String var1);

    public abstract int getNumberOfScreens();

    public abstract void setNumberOfScreens(int var1);

    public abstract byte[] getEncodedAttributes();

    public abstract void setEncodedAttributes(byte[] var1);

    public abstract CodeLocal getHangingProtocolUserIdCode();

    public abstract void setHangingProtocolUserIdCode(CodeLocal var1);

    public abstract Collection getHPDefinition();

    public abstract void setHPDefinition(Collection var1);

    public Dataset getAttributes() {
        return DatasetUtils.fromByteArray((byte[])this.getEncodedAttributes());
    }

    public void setAttributes(Dataset ds) {
        this.setSopIuid(ds.getString(524312));
        this.setSopCuid(ds.getString(524310));
        this.setHangingProtocolName(ds.getString(0x720002));
        this.setHangingProtocolLevel(ds.getString(7471110));
        this.setNumberOfPriorsReferenced(ds.getInt(7471124, 0));
        this.setHangingProtocolUserGroupName(ds.getString(7471120));
        this.setNumberOfScreens(ds.getInt(7471360, 0));
        byte[] b = DatasetUtils.toByteArray((Dataset)ds, (String)"1.2.840.10008.1.2.1.99");
        if (log.isDebugEnabled()) {
            log.debug((Object)("setEncodedAttributes(byte[" + b.length + "]"));
        }
        this.setEncodedAttributes(b);
    }
}

