/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.entity;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.RemoveException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.common.PPSStatus;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.interfaces.PatientLocal;

public abstract class GPPPSBean
implements EntityBean {
    private static final Logger log = Logger.getLogger(GPPPSBean.class);

    public abstract Long getPk();

    public abstract void setPk(Long var1);

    public abstract Timestamp getCreatedTime();

    public abstract void setCreatedTime(Timestamp var1);

    public abstract Timestamp getUpdatedTime();

    public abstract void setUpdatedTime(Timestamp var1);

    public abstract String getSopIuid();

    public abstract void setSopIuid(String var1);

    public abstract Timestamp getPpsStartDateTime();

    public abstract void setPpsStartDateTime(Timestamp var1);

    public void setPpsStartDateTime(Date date) {
        this.setPpsStartDateTime(date != null ? new Timestamp(date.getTime()) : null);
    }

    public abstract int getPpsStatusAsInt();

    public abstract void setPpsStatusAsInt(int var1);

    public abstract byte[] getEncodedAttributes();

    public abstract void setEncodedAttributes(byte[] var1);

    public abstract void setPatient(PatientLocal var1);

    public abstract PatientLocal getPatient();

    public abstract void setGpsps(Collection var1);

    public abstract Collection getGpsps();

    public Long ejbCreate(Dataset ds, PatientLocal patient) throws CreateException {
        this.setSopIuid(ds.getString(524312));
        this.setAttributes(ds);
        return null;
    }

    public void ejbPostCreate(Dataset ds, PatientLocal patient) throws CreateException {
        this.setPatient(patient);
        log.info((Object)("Created " + this.prompt()));
    }

    public void ejbRemove() throws RemoveException {
        log.info((Object)("Deleting " + this.prompt()));
    }

    public boolean isInProgress() {
        return this.getPpsStatusAsInt() == 0;
    }

    public boolean isCompleted() {
        return this.getPpsStatusAsInt() == 1;
    }

    public boolean isDiscontinued() {
        return this.getPpsStatusAsInt() == 2;
    }

    public String getPpsStatus() {
        return PPSStatus.toString((int)this.getPpsStatusAsInt());
    }

    public void setPpsStatus(String status) {
        this.setPpsStatusAsInt(PPSStatus.toInt((String)status));
    }

    private String prompt() {
        return "GPPPS[pk=" + this.getPk() + ", iuid=" + this.getSopIuid() + ", status=" + this.getPpsStatus() + ", patient->" + this.getPatient() + "]";
    }

    public Dataset getAttributes() {
        return DatasetUtils.fromByteArray((byte[])this.getEncodedAttributes());
    }

    public void setAttributes(Dataset ds) {
        this.setPpsStartDateTime(ds.getDateTime(0x400244, 4194885));
        this.setPpsStatus(ds.getString(0x404002));
        AttributeFilter filter = AttributeFilter.getExcludePatientAttributeFilter();
        byte[] b = DatasetUtils.toByteArray((Dataset)filter.filter(ds), (String)filter.getTransferSyntaxUID());
        if (log.isDebugEnabled()) {
            log.debug((Object)("setEncodedAttributes(byte[" + b.length + "])"));
        }
        this.setEncodedAttributes(b);
    }
}

