/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.entity;

import java.sql.Timestamp;
import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.RemoveException;
import org.apache.log4j.Logger;
import org.dcm4chex.archive.ejb.interfaces.FileDTO;
import org.dcm4chex.archive.ejb.interfaces.FileSystemLocal;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocal;
import org.dcm4chex.archive.ejb.interfaces.MD5;

public abstract class FileBean
implements EntityBean {
    private static final Logger log = Logger.getLogger(FileBean.class);

    public abstract Long getPk();

    public abstract void setPk(Long var1);

    public abstract Timestamp getCreatedTime();

    public abstract void setCreatedTime(Timestamp var1);

    public abstract Timestamp getTimeOfLastMd5Check();

    public abstract void setTimeOfLastMd5Check(Timestamp var1);

    public abstract String getFilePath();

    public abstract void setFilePath(String var1);

    public abstract String getFileTsuid();

    public abstract void setFileTsuid(String var1);

    public abstract String getFileMd5Field();

    public abstract void setFileMd5Field(String var1);

    public abstract int getFileStatus();

    public abstract void setFileStatus(int var1);

    public byte[] getFileMd5() {
        return MD5.toBytes((String)this.getFileMd5Field());
    }

    public void setFileMd5(byte[] md5) {
        this.setFileMd5Field(MD5.toString((byte[])md5));
    }

    public abstract long getFileSize();

    public abstract void setFileSize(long var1);

    public abstract void setInstance(InstanceLocal var1);

    public abstract InstanceLocal getInstance();

    public abstract void setFileSystem(FileSystemLocal var1);

    public abstract FileSystemLocal getFileSystem();

    public boolean isRedundant() {
        InstanceLocal inst = this.getInstance();
        return inst == null || inst.getFiles().size() > 1;
    }

    public FileDTO getFileDTO() {
        FileSystemLocal fs = this.getFileSystem();
        FileDTO retval = new FileDTO();
        retval.setPk(this.getPk().longValue());
        retval.setRetrieveAET(fs.getRetrieveAET());
        retval.setFileSystemPk(fs.getPk().longValue());
        retval.setFileSystemGroupID(fs.getGroupID());
        retval.setDirectoryPath(fs.getDirectoryPath());
        retval.setAvailability(fs.getAvailability());
        retval.setUserInfo(fs.getUserInfo());
        retval.setFilePath(this.getFilePath());
        retval.setFileTsuid(this.getFileTsuid());
        retval.setFileSize(this.getFileSize());
        retval.setFileMd5(this.getFileMd5());
        retval.setFileStatus(this.getFileStatus());
        InstanceLocal inst = this.getInstance();
        if (inst != null) {
            retval.setSopInstanceUID(inst.getSopIuid());
            retval.setSopClassUID(inst.getSopCuid());
        }
        return retval;
    }

    public String asString() {
        return this.prompt();
    }

    private String prompt() {
        return "File[pk=" + this.getPk() + ", filepath=" + this.getFilePath() + ", tsuid=" + this.getFileTsuid() + ", filesystem->" + this.getFileSystem() + ", inst->" + this.getInstance() + "]";
    }

    public Long ejbCreate(String path, String tsuid, long size, byte[] md5, int status, InstanceLocal instance, FileSystemLocal filesystem) throws CreateException {
        this.setFilePath(path);
        this.setFileTsuid(tsuid);
        this.setFileSize(size);
        this.setFileMd5(md5);
        this.setFileStatus(status);
        return null;
    }

    public void ejbPostCreate(String path, String tsuid, long size, byte[] md5, int status, InstanceLocal instance, FileSystemLocal filesystem) throws CreateException {
        this.setInstance(instance);
        this.setFileSystem(filesystem);
        log.info((Object)("Created " + this.prompt()));
    }

    public void ejbRemove() throws RemoveException {
        log.info((Object)("Deleting " + this.prompt()));
    }
}

