/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.entity;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import org.apache.log4j.Logger;
import org.dcm4chex.archive.ejb.interfaces.AEDTO;

public abstract class AEBean
implements EntityBean {
    private static final Logger log = Logger.getLogger(AEBean.class);

    public abstract Long getPk();

    public abstract void getPk(Long var1);

    public abstract String getTitle();

    public abstract void setTitle(String var1);

    public abstract String getHostName();

    public abstract void setHostName(String var1);

    public abstract int getPort();

    public abstract void setPort(int var1);

    public abstract String getCipherSuites();

    public abstract void setCipherSuites(String var1);

    public abstract String getIssuerOfPatientID();

    public abstract void setIssuerOfPatientID(String var1);

    public abstract String getIssuerOfAccessionNumber();

    public abstract void setIssuerOfAccessionNumber(String var1);

    public abstract String getStationName();

    public abstract void setStationName(String var1);

    public abstract String getInstitution();

    public abstract void setInstitution(String var1);

    public abstract String getDepartment();

    public abstract void setDepartment(String var1);

    public abstract boolean getInstalled();

    public abstract void setInstalled(boolean var1);

    public abstract String getUserID();

    public abstract void setUserID(String var1);

    public abstract String getPassword();

    public abstract void setPassword(String var1);

    public abstract String getFileSystemGroupID();

    public abstract void setFileSystemGroupID(String var1);

    public abstract String getGroup();

    public abstract void setGroup(String var1);

    public abstract String getDescription();

    public abstract void setDescription(String var1);

    public abstract String getWadoURL();

    public abstract void setWadoURL(String var1);

    public abstract byte[] getVendorData();

    public abstract void setVendorData(byte[] var1);

    public Long ejbCreate(AEDTO dto) throws CreateException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("create AEBean(" + dto.getTitle() + ")"));
        }
        this.update(dto);
        return null;
    }

    public void ejbPostCreate(AEDTO dto) throws CreateException {
    }

    public void update(AEDTO dto) {
        this.setTitle(dto.getTitle().trim());
        this.setHostName(dto.getHostName());
        this.setPort(dto.getPort());
        this.setCipherSuites(dto.getCipherSuitesAsString());
        this.setIssuerOfPatientID(dto.getIssuerOfPatientID());
        this.setIssuerOfAccessionNumber(dto.getIssuerOfAccessionNumberAsString());
        this.setUserID(dto.getUserID());
        this.setPassword(dto.getPassword());
        this.setFileSystemGroupID(dto.getFileSystemGroupID());
        this.setGroup(dto.getGroup());
        this.setDescription(dto.getDescription());
        this.setWadoURL(dto.getWadoURL());
        this.setStationName(dto.getStationName());
        this.setInstitution(dto.getInstitution());
        this.setDepartment(dto.getDepartment());
        this.setVendorData(dto.getVendorData());
        this.setInstalled(dto.isInstalled());
    }

    public AEDTO toDTO() {
        AEDTO dto = new AEDTO();
        dto.setPk(this.getPk().longValue());
        dto.setTitle(this.getTitle());
        dto.setHostName(this.getHostName());
        dto.setPort(this.getPort());
        dto.setCipherSuitesAsString(this.getCipherSuites());
        dto.setIssuerOfPatientID(this.getIssuerOfPatientID());
        dto.setIssuerOfAccessionNumberAsString(this.getIssuerOfAccessionNumber());
        dto.setUserID(this.getUserID());
        dto.setPassword(this.getPassword());
        dto.setFileSystemGroupID(this.getFileSystemGroupID());
        dto.setGroup(this.getGroup());
        dto.setDescription(this.getDescription());
        dto.setWadoURL(this.getWadoURL());
        dto.setStationName(this.getStationName());
        dto.setInstitution(this.getInstitution());
        dto.setDepartment(this.getDepartment());
        dto.setVendorData(this.getVendorData());
        dto.setInstalled(this.getInstalled());
        return dto;
    }

    public String asString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getProtocol()).append("://").append(this.getTitle()).append('@').append(this.getHostName()).append(':').append(this.getPort());
        return sb.toString();
    }

    private String getProtocol() {
        String cipherSuites = this.getCipherSuites();
        if (cipherSuites == null || cipherSuites.length() == 0) {
            return "dicom";
        }
        if ("SSL_RSA_WITH_NULL_SHA".equals(cipherSuites)) {
            return "dicom-tls.nodes";
        }
        if ("SSL_RSA_WITH_3DES_EDE_CBC_SHA".equals(cipherSuites)) {
            return "dicom-tls.3des";
        }
        if ("TLS_RSA_WITH_AES_128_CBC_SHA,SSL_RSA_WITH_3DES_EDE_CBC_SHA".equals(cipherSuites)) {
            return "dicom-tls.aes";
        }
        return "dicom-tls";
    }
}

