/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.version.undo;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.util.collections.ArrayListStack;
import org.apache.wicket.version.IPageVersionManager;
import org.apache.wicket.version.undo.Change;
import org.apache.wicket.version.undo.ChangeList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndoPageVersionManager
implements IPageVersionManager {
    private static final Logger log = LoggerFactory.getLogger(UndoPageVersionManager.class);
    private static final long serialVersionUID = 1L;
    private ChangeList changeList;
    private final ArrayListStack<ChangeList> changeListStack = new ArrayListStack();
    private int currentVersionNumber = 0;
    private int currentAjaxVersionNumber = 0;
    private final int maxVersions;
    private final Page page;
    private transient boolean ignoreMerge = false;

    public UndoPageVersionManager(Page page, int maxVersions) {
        this.page = page;
        this.maxVersions = maxVersions;
    }

    public void beginVersion(boolean mergeVersion) {
        this.changeList = new ChangeList();
        if (!mergeVersion) {
            ++this.currentVersionNumber;
            this.currentAjaxVersionNumber = 0;
        } else {
            ++this.currentAjaxVersionNumber;
        }
    }

    public void ignoreVersionMerge() {
        this.ignoreMerge = true;
        ++this.currentVersionNumber;
        this.currentAjaxVersionNumber = 0;
    }

    public void componentAdded(Component component) {
        this.changeList.componentAdded(component);
    }

    public void componentModelChanging(Component component) {
        this.changeList.componentModelChanging(component);
    }

    public void componentRemoved(Component component) {
        this.changeList.componentRemoved(component);
    }

    public void componentStateChanging(Change change) {
        this.changeList.componentStateChanging(change);
    }

    public void endVersion(boolean mergeVersion) {
        if (mergeVersion && !this.ignoreMerge) {
            if (this.changeListStack.size() > 0) {
                ChangeList previous = this.changeListStack.peek();
                previous.add(this.changeList);
            }
        } else {
            this.ignoreMerge = false;
            this.changeListStack.push(this.changeList);
            if (this.getVersions() > this.maxVersions) {
                this.expireOldestVersion();
            }
            this.changeListStack.trimToSize();
            if (log.isDebugEnabled()) {
                log.debug("Version " + this.currentVersionNumber + " for page " + this.page + " stored");
            }
        }
    }

    public void expireOldestVersion() {
        this.changeListStack.remove(0);
    }

    public int getCurrentVersionNumber() {
        return this.currentVersionNumber;
    }

    public int getAjaxVersionNumber() {
        return this.currentAjaxVersionNumber;
    }

    public Page getVersion(int versionNumber) {
        if (versionNumber <= this.getCurrentVersionNumber()) {
            while (this.getCurrentVersionNumber() > versionNumber) {
                if (this.undo()) continue;
                return null;
            }
            return this.page;
        }
        return null;
    }

    public Page rollbackPage(int numberOfVersions) {
        return null;
    }

    public int getVersions() {
        return this.changeListStack.size();
    }

    private boolean undo() {
        if (log.isDebugEnabled()) {
            log.debug("UNDO: rollback " + this.page + " to version " + this.currentVersionNumber);
        }
        if (this.changeListStack.isEmpty()) {
            return false;
        }
        ChangeList changeList = this.changeListStack.pop();
        if (changeList == null) {
            return false;
        }
        changeList.undo();
        --this.currentVersionNumber;
        return true;
    }
}

