/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert.converters;

import java.math.BigDecimal;
import java.util.Locale;
import org.apache.wicket.util.convert.converters.AbstractDecimalConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimalConverter
extends AbstractDecimalConverter {
    private static final long serialVersionUID = 1L;

    @Override
    protected Class<?> getTargetType() {
        return BigDecimal.class;
    }

    @Override
    public BigDecimal convertToObject(String value, Locale locale) {
        if (value == null || value.trim().equals("")) {
            return null;
        }
        Number number = this.parse(value, -1.7976931348623157E308, Double.MAX_VALUE, locale);
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Double) {
            return new BigDecimal(number.doubleValue());
        }
        if (number instanceof Long) {
            return new BigDecimal(number.longValue());
        }
        if (number instanceof Float) {
            return new BigDecimal(number.floatValue());
        }
        if (number instanceof Integer) {
            return new BigDecimal(number.intValue());
        }
        return new BigDecimal(value);
    }
}

