/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.resource;

import java.io.IOException;
import org.apache.wicket.Application;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Resource;
import org.apache.wicket.Response;
import org.apache.wicket.SharedResources;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.application.IClassResolver;
import org.apache.wicket.markup.html.PackageResource;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.resource.ISharedResourceRequestTarget;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedResourceRequestTarget
implements ISharedResourceRequestTarget {
    private static final Logger log = LoggerFactory.getLogger(SharedResourceRequestTarget.class);
    private final RequestParameters requestParameters;

    public SharedResourceRequestTarget(RequestParameters requestParameters) {
        this.requestParameters = requestParameters;
        if (requestParameters == null) {
            throw new IllegalArgumentException("requestParameters may not be null");
        }
        if (requestParameters.getResourceKey() == null) {
            throw new IllegalArgumentException("requestParameters.getResourceKey() may not be null");
        }
    }

    public void detach(RequestCycle requestCycle) {
    }

    public boolean equals(Object obj) {
        if (obj instanceof SharedResourceRequestTarget) {
            SharedResourceRequestTarget that = (SharedResourceRequestTarget)obj;
            return this.getRequestParameters().getResourceKey().equals(that.getRequestParameters().getResourceKey());
        }
        return false;
    }

    public final RequestParameters getRequestParameters() {
        return this.requestParameters;
    }

    public final String getResourceKey() {
        return this.requestParameters.getResourceKey();
    }

    public int hashCode() {
        int result = "SharedResourceRequestTarget".hashCode();
        return 17 * (result += this.getRequestParameters().getResourceKey().hashCode());
    }

    public void respond(RequestCycle requestCycle) {
        int ix;
        String resourceKey;
        Application application = requestCycle.getApplication();
        SharedResources sharedResources = application.getSharedResources();
        Resource resource = sharedResources.get(resourceKey = this.getRequestParameters().getResourceKey());
        if (resource == null && (ix = resourceKey.indexOf(47)) != -1) {
            String className = resourceKey.substring(0, ix);
            IClassResolver resolver = application.getApplicationSettings().getClassResolver();
            Class<?> scope = null;
            try {
                scope = Application.get().getSharedResources().getAliasClass(className);
                if (scope == null) {
                    scope = resolver.resolveClass(className);
                }
                CharSequence escapeString = application.getResourceSettings().getParentFolderPlaceholder();
                String path = resourceKey.substring(ix + 1);
                if (!Strings.isEmpty(escapeString)) {
                    path = path.replace(escapeString, "..");
                }
                if (PackageResource.exists(scope, path, null, null)) {
                    resource = PackageResource.get(scope, path);
                }
            }
            catch (Exception e) {
                log.error("unable to lazily register shared resource " + resourceKey, (Throwable)e);
            }
        }
        if (resource == null) {
            String msg = "shared resource " + resourceKey + " not found or not allowed access";
            log.info(msg);
            Response response = requestCycle.getResponse();
            if (response instanceof WebResponse) {
                try {
                    ((WebResponse)response).getHttpServletResponse().sendError(404);
                }
                catch (IOException e) {
                    throw new WicketRuntimeException("Error sending 404 error to client", e);
                }
                return;
            }
            throw new WicketRuntimeException(msg);
        }
        if (this.requestParameters != null) {
            resource.setParameters(this.requestParameters.getParameters());
        }
        resource.onResourceRequested();
    }

    public String toString() {
        return "[SharedResourceRequestTarget@" + this.hashCode() + ", resourceKey=" + this.getRequestParameters().getResourceKey() + "]";
    }
}

