/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.request.urlcompressing;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.util.collections.IntHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlCompressor
implements IClusterable {
    private static final Logger log = LoggerFactory.getLogger(UrlCompressor.class);
    private static final long serialVersionUID = 1L;
    private transient ReferenceQueue<Object> queue = new ReferenceQueue();
    private transient IntHashMap<ComponentAndInterface> directComponentRefs = new IntHashMap();
    private int uid = 1;

    public ComponentAndInterface getComponentAndInterfaceForUID(String uidString) {
        IntKeyWeakReference ref = null;
        while ((ref = (IntKeyWeakReference)this.queue.poll()) != null) {
            this.directComponentRefs.remove(ref.uid);
        }
        try {
            int uid = Integer.parseInt(uidString);
            ComponentAndInterface cai = this.directComponentRefs.get(uid);
            return cai;
        }
        catch (Exception e) {
            log.warn("cant decompress Component/Interface from '" + uidString + "'", (Throwable)e);
            return null;
        }
    }

    public int getNewUID() {
        return this.uid++;
    }

    public int getUIDForComponentAndInterface(Component component, String interfaceName) {
        int uid = 0;
        for (IntHashMap.Entry<ComponentAndInterface> entry : this.directComponentRefs.entrySet()) {
            ComponentAndInterface cai = entry.getValue();
            if (!cai.getInterfaceName().equals(interfaceName) || cai.getComponent() != component) continue;
            uid = entry.getKey();
            break;
        }
        if (uid == 0) {
            uid = this.getNewUID();
            IntKeyWeakReference ref = new IntKeyWeakReference(uid, component, this.queue);
            this.directComponentRefs.put(uid, new ComponentAndInterface(ref, interfaceName));
        }
        return uid;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.queue = new ReferenceQueue();
        this.directComponentRefs = new IntHashMap((int)((double)size * 1.25));
        while (--size >= 0) {
            int uid = s.readInt();
            Component component = (Component)s.readObject();
            String interfaceName = s.readUTF();
            IntKeyWeakReference ref = new IntKeyWeakReference(uid, component, this.queue);
            this.directComponentRefs.put(uid, new ComponentAndInterface(ref, interfaceName));
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        IntKeyWeakReference ref = null;
        while ((ref = (IntKeyWeakReference)this.queue.poll()) != null) {
            this.directComponentRefs.remove(ref.uid);
        }
        s.defaultWriteObject();
        s.writeInt(this.directComponentRefs.size());
        for (IntHashMap.Entry<ComponentAndInterface> entry : this.directComponentRefs.entrySet()) {
            s.writeInt(entry.getKey());
            ComponentAndInterface cai = entry.getValue();
            s.writeObject(cai.getComponent());
            s.writeUTF(cai.getInterfaceName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntKeyWeakReference
    extends WeakReference<Object> {
        private final int uid;

        public IntKeyWeakReference(int uid, Object referent, ReferenceQueue<Object> q) {
            super(referent, q);
            this.uid = uid;
        }
    }

    public static class ComponentAndInterface {
        private static final long serialVersionUID = 1L;
        private final IntKeyWeakReference ref;
        private final String interfaceName;

        private ComponentAndInterface(IntKeyWeakReference ref, String interfaceName) {
            this.ref = ref;
            this.interfaceName = interfaceName;
        }

        public Component getComponent() {
            return (Component)this.ref.get();
        }

        public String getInterfaceName() {
            return this.interfaceName;
        }
    }
}

