/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.request.urlcompressing;

import org.apache.wicket.Component;
import org.apache.wicket.IPageMap;
import org.apache.wicket.IRedirectListener;
import org.apache.wicket.Page;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.behavior.IActivePageBehaviorListener;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.request.WebRequestCodingStrategy;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.component.BookmarkableListenerInterfaceRequestTarget;
import org.apache.wicket.request.target.component.IBookmarkablePageRequestTarget;
import org.apache.wicket.request.target.component.listener.IListenerInterfaceRequestTarget;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;

public class UrlCompressingWebCodingStrategy
extends WebRequestCodingStrategy {
    protected CharSequence encode(RequestCycle requestCycle, IListenerInterfaceRequestTarget requestTarget) {
        RequestListenerInterface rli = requestTarget.getRequestListenerInterface();
        AppendingStringBuffer url = new AppendingStringBuffer(64);
        url.append('?');
        url.append("wicket:interface");
        url.append('=');
        Component component = requestTarget.getTarget();
        Page page = component.getPage();
        IPageMap pageMap = page.getPageMap();
        if (!pageMap.isDefault()) {
            url.append(pageMap.getName());
        }
        url.append(':');
        String listenerName = rli.getName();
        if (page instanceof WebPage && !"IResourceListener".equals(listenerName)) {
            url.append(page.getId());
            url.append(':');
            url.append(((WebPage)page).getUrlCompressor().getUIDForComponentAndInterface(component, listenerName));
            listenerName = null;
        } else {
            url.append(component.getPath());
        }
        url.append(':');
        int versionNumber = component.getPage().getCurrentVersionNumber();
        if (!rli.getRecordsPageVersion()) {
            url.append(-1);
        } else if (versionNumber > 0) {
            url.append(versionNumber);
        }
        url.append(':');
        if (listenerName != null && !IRedirectListener.INTERFACE.getName().equals(listenerName)) {
            url.append(listenerName);
        }
        url.append(':');
        RequestParameters params = requestTarget.getRequestParameters();
        if (params != null && params.getBehaviorId() != null) {
            url.append(params.getBehaviorId());
        }
        url.append(':');
        if (params != null && params.getUrlDepth() != 0) {
            url.append(params.getUrlDepth());
        }
        if (IActivePageBehaviorListener.INTERFACE.getName().equals(rli.getName())) {
            url.append(url.indexOf("?") > -1 ? "&" : "?").append("wicket:ignoreIfNotActive").append("=true");
        }
        return requestCycle.getOriginalResponse().encodeURL(url);
    }

    protected CharSequence encode(RequestCycle requestCycle, IBookmarkablePageRequestTarget requestTarget) {
        if (requestTarget instanceof BookmarkableListenerInterfaceRequestTarget && requestTarget.getPageParameters().containsKey("wicket:interface")) {
            BookmarkableListenerInterfaceRequestTarget t = (BookmarkableListenerInterfaceRequestTarget)requestTarget;
            Page page = t.getPage();
            int version = page.getCurrentVersionNumber();
            String componentPath = t.getComponentPath();
            String interfaceName = t.getInterfaceName();
            String pageMapName = t.getPageMapName();
            AppendingStringBuffer param = new AppendingStringBuffer(4 + componentPath.length() + interfaceName.length());
            if (pageMapName != null) {
                param.append(pageMapName);
            }
            param.append(':');
            if (page instanceof WebPage && !"IResourceListener".equals(interfaceName)) {
                param.append(page.getId());
                Component comp = page.get(Strings.afterFirstPathComponent(componentPath, ':'));
                param.append(':');
                param.append(((WebPage)page).getUrlCompressor().getUIDForComponentAndInterface(comp, interfaceName));
                interfaceName = null;
            } else {
                param.append(componentPath);
            }
            param.append(':');
            if (version != 0) {
                param.append(version);
            }
            param.append(':');
            if (interfaceName != null && !IRedirectListener.INTERFACE.getName().equals(interfaceName)) {
                param.append(interfaceName);
            }
            param.append(':');
            param.append(':');
            t.getPageParameters().put("wicket:interface", (Object)param.toString());
        }
        return super.encode(requestCycle, requestTarget);
    }
}

