/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.resolver;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Response;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.markup.parser.filter.WicketTagIdentifier;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.model.Model;
import org.apache.wicket.response.StringResponse;
import org.apache.wicket.util.lang.PropertyResolver;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.string.interpolator.MapVariableInterpolator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WicketMessageResolver
implements IComponentResolver {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(WicketMessageResolver.class);
    private static final String DEFAULT_VALUE = "DEFAULT_WICKET_MESSAGE_RESOLVER_VALUE";

    public boolean resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        WicketTag wtag;
        if (tag instanceof WicketTag && (wtag = (WicketTag)tag).isMessageTag()) {
            String messageKey = wtag.getAttributes().getString("key");
            if (messageKey == null || messageKey.trim().length() == 0) {
                throw new MarkupException("Wrong format of <wicket:message key='xxx'>: attribute 'key' is missing");
            }
            String id = "_message_" + container.getPage().getAutoIndex();
            MessageContainer label = new MessageContainer(id, messageKey);
            label.setRenderBodyOnly(container.getApplication().getMarkupSettings().getStripWicketTags());
            container.autoAdd(label, markupStream);
            return true;
        }
        return false;
    }

    private static boolean isThrowExceptionIfPropertyNotFound() {
        return Application.get().getResourceSettings().getThrowExceptionOnMissingResource();
    }

    static {
        WicketTagIdentifier.registerWellKnownTagName("message");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageContainer
    extends MarkupContainer {
        private static final long serialVersionUID = 1L;

        public MessageContainer(String id, String messageKey) {
            super(id, new Model<String>(messageKey));
            this.setEscapeModelStrings(false);
        }

        @Override
        protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
            String key = this.getDefaultModelObjectAsString();
            String value = this.getLocalizer().getString(key, (Component)this.getParent(), WicketMessageResolver.DEFAULT_VALUE);
            if (value != null && !WicketMessageResolver.DEFAULT_VALUE.equals(value)) {
                this.renderMessage(markupStream, openTag, key, value);
            } else {
                if (WicketMessageResolver.isThrowExceptionIfPropertyNotFound()) {
                    throw new WicketRuntimeException("Property '" + key + "' not found in property files. Markup: " + markupStream.toString());
                }
                log.warn("No value found for wicket:message tag with key: {}", (Object)key);
                this.renderComponentTagBody(markupStream, openTag);
            }
        }

        private void renderMessage(final MarkupStream markupStream, ComponentTag openTag, final String key, String value) {
            Map<String, CharSequence> childTags = this.findAndRenderChildWicketTags(markupStream, openTag);
            final HashMap variablesReplaced = new HashMap();
            String text = new MapVariableInterpolator(value, childTags){

                protected String getValue(String variableName) {
                    String value = super.getValue(variableName);
                    if (value != null) {
                        variablesReplaced.put(variableName, null);
                    }
                    if (value == null) {
                        value = Strings.toString(PropertyResolver.getValue(variableName, MessageContainer.this.getParent().getDefaultModelObject()));
                    }
                    if (value == null) {
                        value = Strings.toString(PropertyResolver.getValue(variableName, MessageContainer.this.getParent()));
                    }
                    if (value == null) {
                        String msg = "The localized text for <wicket:message key=\"" + key + "\"> has a variable ${" + variableName + "}. However the wicket:message element does not have a child " + "element with a wicket:id=\"" + variableName + "\".";
                        if (WicketMessageResolver.isThrowExceptionIfPropertyNotFound()) {
                            markupStream.throwMarkupException(msg);
                        } else {
                            log.warn(msg);
                            value = "### VARIABLE NOT FOUND: " + variableName + " ###";
                        }
                    }
                    return value;
                }
            }.toString();
            this.getResponse().write(text);
            for (String id : childTags.keySet()) {
                if (variablesReplaced.containsKey(id)) continue;
                String msg = "The <wicket:message key=\"" + key + "\"> has a child element with wicket:id=\"" + id + "\". You must add the variable ${" + id + "} to the localized text for the wicket:message.";
                if (WicketMessageResolver.isThrowExceptionIfPropertyNotFound()) {
                    markupStream.throwMarkupException(msg);
                    continue;
                }
                log.warn(msg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, CharSequence> findAndRenderChildWicketTags(MarkupStream markupStream, ComponentTag openTag) {
            HashMap<String, CharSequence> childTags = new HashMap<String, CharSequence>();
            markupStream.setCurrentIndex(markupStream.getCurrentIndex() - 1);
            ComponentTag tag = markupStream.getTag();
            markupStream.next();
            if (!tag.isOpenClose()) {
                while (markupStream.hasMore() && !markupStream.get().closes(openTag)) {
                    MarkupElement element = markupStream.get();
                    if (element instanceof ComponentTag && !markupStream.atCloseTag()) {
                        String id = ((ComponentTag)element).getId();
                        Response webResponse = this.getResponse();
                        try {
                            StringResponse response = new StringResponse();
                            this.getRequestCycle().setResponse(response);
                            Component component = this.getParent().get(id);
                            if (component != null) {
                                component.render(markupStream);
                                childTags.put(id, response.getBuffer());
                                continue;
                            }
                            markupStream.next();
                            continue;
                        }
                        finally {
                            this.getRequestCycle().setResponse(webResponse);
                            continue;
                        }
                    }
                    markupStream.next();
                }
            }
            return childTags;
        }

        @Override
        public boolean isTransparentResolver() {
            return true;
        }

        @Override
        protected void onComponentTag(ComponentTag tag) {
            if (tag.isOpenClose()) {
                tag.setType(XmlTag.OPEN);
            }
            super.onComponentTag(tag);
        }
    }
}

