/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.util.collections.ArrayListStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HtmlHandler
extends AbstractMarkupFilter {
    private static final Logger log = LoggerFactory.getLogger(HtmlHandler.class);
    private final ArrayListStack<ComponentTag> stack = new ArrayListStack();
    private static final Map<String, Boolean> doesNotRequireCloseTag = new HashMap<String, Boolean>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MarkupElement nextTag() throws ParseException {
        ComponentTag tag = (ComponentTag)this.getParent().nextTag();
        if (tag == null) {
            while (this.stack.size() > 0) {
                ComponentTag top = this.stack.peek();
                if (HtmlHandler.requiresCloseTag(top.getName())) throw new ParseException("Tag " + top + " at " + top.getPos() + " did not have a close tag", top.getPos());
                this.stack.pop();
            }
            return tag;
        }
        if (log.isDebugEnabled()) {
            log.debug("tag: " + tag.toUserDebugString() + ", stack: " + this.stack);
        }
        if (tag.isOpen()) {
            this.stack.push(tag);
            return tag;
        } else if (tag.isClose()) {
            boolean mismatch;
            if (this.stack.size() <= 0) throw new ParseException("Tag " + tag.toUserDebugString() + " does not have a matching open tag", tag.getPos());
            ComponentTag top = this.stack.pop();
            boolean bl = mismatch = !top.hasEqualTagName(tag);
            if (mismatch) {
                top.setHasNoCloseTag(true);
                while (mismatch && !HtmlHandler.requiresCloseTag(top.getName())) {
                    top.setHasNoCloseTag(true);
                    if (this.stack.isEmpty()) break;
                    top = this.stack.pop();
                    mismatch = !top.hasEqualTagName(tag);
                }
                if (mismatch) {
                    throw new ParseException("Tag " + top.toUserDebugString() + " has a mismatched close tag at " + tag.toUserDebugString(), top.getPos());
                }
            }
            tag.setOpenTag(top);
            return tag;
        } else {
            if (!tag.isOpenClose()) return tag;
            tag.setOpenTag(tag);
        }
        return tag;
    }

    public static boolean requiresCloseTag(String name) {
        return doesNotRequireCloseTag.get(name.toLowerCase()) == null;
    }

    static {
        doesNotRequireCloseTag.put("p", Boolean.TRUE);
        doesNotRequireCloseTag.put("br", Boolean.TRUE);
        doesNotRequireCloseTag.put("img", Boolean.TRUE);
        doesNotRequireCloseTag.put("input", Boolean.TRUE);
        doesNotRequireCloseTag.put("hr", Boolean.TRUE);
        doesNotRequireCloseTag.put("link", Boolean.TRUE);
        doesNotRequireCloseTag.put("meta", Boolean.TRUE);
    }
}

