/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.internal;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.util.collections.ReadOnlyIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DirectChildTagIterator
extends ReadOnlyIterator<ComponentTag> {
    private final MarkupStream markupStream;
    private final ComponentTag parent;
    private ComponentTag next;
    private int nextIndex;
    private int currentIndex;
    private final int originalIndex;

    public DirectChildTagIterator(MarkupStream markupStream, ComponentTag parent) {
        this.markupStream = markupStream;
        this.parent = parent;
        this.originalIndex = markupStream.getCurrentIndex();
        while (!markupStream.atTag() && markupStream.hasMore()) {
            markupStream.next();
        }
        this.next = markupStream.getTag();
    }

    public void rewind() {
        this.markupStream.setCurrentIndex(this.originalIndex);
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public ComponentTag next() {
        ComponentTag ret = this.next;
        this.currentIndex = this.nextIndex;
        this.findNext();
        return ret;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    private void findNext() {
        MarkupElement cursor;
        ComponentTag tag = this.next;
        this.next = null;
        if (tag != null && tag.isOpenClose()) {
            tag = null;
        }
        this.markupStream.next();
        while (this.markupStream.hasMore() && !(cursor = this.markupStream.get()).closes(this.parent)) {
            if (tag != null && cursor.closes(tag)) {
                tag = null;
            } else if (tag == null && cursor instanceof ComponentTag) {
                this.next = (ComponentTag)cursor;
                this.nextIndex = this.markupStream.getCurrentIndex();
                break;
            }
            this.markupStream.next();
        }
    }
}

