/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.behavior;

import org.apache.wicket.AttributeModifier;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeAppender
extends AttributeModifier {
    private static final long serialVersionUID = 1L;
    private final String separator;

    public AttributeAppender(String attribute, boolean addAttributeIfNotPresent, IModel<?> appendModel, String separator) {
        super(attribute, addAttributeIfNotPresent, appendModel);
        this.separator = separator;
    }

    public AttributeAppender(String attribute, IModel<?> appendModel, String separator) {
        super(attribute, true, appendModel);
        this.separator = separator;
    }

    @Override
    protected String newValue(String currentValue, String appendValue) {
        AppendingStringBuffer sb;
        int appendValueLen;
        int n = appendValueLen = appendValue == null ? 0 : appendValue.length();
        if (currentValue == null) {
            sb = new AppendingStringBuffer(appendValueLen + this.separator.length());
        } else {
            sb = new AppendingStringBuffer(currentValue.length() + appendValueLen + this.separator.length());
            sb.append(currentValue);
        }
        if (!Strings.isEmpty(currentValue) && !Strings.isEmpty(appendValue)) {
            sb.append(this.separator);
        }
        if (!Strings.isEmpty(appendValue)) {
            sb.append(appendValue);
        }
        return sb.toString();
    }
}

