/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import org.apache.wicket.Application;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.RequestContext;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.IAjaxIndicatorAware;
import org.apache.wicket.ajax.WicketAjaxReference;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WicketEventReference;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.settings.IDebugSettings;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Duration;

public abstract class AbstractDefaultAjaxBehavior
extends AbstractAjaxBehavior {
    private static final long serialVersionUID = 1L;
    public static final ResourceReference INDICATOR = new ResourceReference(AbstractDefaultAjaxBehavior.class, "indicator.gif");
    private static final ResourceReference JAVASCRIPT_DEBUG = new JavascriptResourceReference(AbstractDefaultAjaxBehavior.class, "wicket-ajax-debug.js");

    protected void onBind() {
        this.getComponent().setOutputMarkupId(true);
    }

    public void renderHead(IHeaderResponse response) {
        RequestContext context;
        super.renderHead(response);
        IDebugSettings debugSettings = Application.get().getDebugSettings();
        response.renderJavascriptReference(WicketEventReference.INSTANCE);
        response.renderJavascriptReference(WicketAjaxReference.INSTANCE);
        if (debugSettings.isAjaxDebugModeEnabled()) {
            response.renderJavascriptReference(JAVASCRIPT_DEBUG);
            response.renderJavascript("wicketAjaxDebugEnable=true;", "wicket-ajax-debug-enable");
        }
        if ((context = RequestContext.get()).isPortletRequest()) {
            response.renderJavascript("Wicket.portlet=true", "wicket-ajax-portlet-flag");
        }
    }

    protected IAjaxCallDecorator getAjaxCallDecorator() {
        return null;
    }

    protected CharSequence getCallbackScript() {
        return this.getCallbackScript(false);
    }

    protected CharSequence getCallbackScript(boolean onlyTargetActivePage) {
        return this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl(onlyTargetActivePage) + "'");
    }

    protected CharSequence getPreconditionScript() {
        if (this.getComponent() instanceof Page) {
            return "return true;";
        }
        return "return Wicket.$('" + this.getComponent().getMarkupId() + "') != null;";
    }

    protected CharSequence getFailureScript() {
        return null;
    }

    protected CharSequence getSuccessScript() {
        return null;
    }

    protected CharSequence generateCallbackScript(CharSequence partialCall) {
        String channel;
        CharSequence failure;
        CharSequence onSuccessScript = this.getSuccessScript();
        CharSequence onFailureScript = this.getFailureScript();
        CharSequence precondition = this.getPreconditionScript();
        IAjaxCallDecorator decorator = this.getAjaxCallDecorator();
        String indicatorId = this.findIndicatorId();
        CharSequence success = onSuccessScript == null ? "" : onSuccessScript;
        CharSequence charSequence = failure = onFailureScript == null ? "" : onFailureScript;
        if (decorator != null) {
            success = decorator.decorateOnSuccessScript(success);
        }
        if (!Strings.isEmpty(indicatorId)) {
            String hide = ";wicketHide('" + indicatorId + "');";
            success = success + hide;
            failure = failure + hide;
        }
        if (decorator != null) {
            failure = decorator.decorateOnFailureScript(failure);
        }
        AppendingStringBuffer buff = new AppendingStringBuffer(256);
        buff.append("var ").append("wcall").append("=");
        buff.append(partialCall);
        buff.append(",function() { ").append(success).append("}.bind(this)");
        buff.append(",function() { ").append(failure).append("}.bind(this)");
        if (precondition != null) {
            buff.append(", function() {");
            buff.append(precondition);
            buff.append("}.bind(this)");
        }
        if ((channel = this.getChannelName()) != null) {
            if (precondition == null) {
                buff.append(", null");
            }
            buff.append(", '");
            buff.append(channel);
            buff.append("'");
        }
        buff.append(");");
        CharSequence call = buff;
        if (!Strings.isEmpty(indicatorId)) {
            call = new AppendingStringBuffer("wicketShow('").append(indicatorId).append("');").append(call);
        }
        if (decorator != null) {
            call = decorator.decorateScript(call);
        }
        return call;
    }

    protected String getChannelName() {
        return null;
    }

    protected String findIndicatorId() {
        if (this.getComponent() instanceof IAjaxIndicatorAware) {
            return ((IAjaxIndicatorAware)((Object)this.getComponent())).getAjaxIndicatorMarkupId();
        }
        if (this instanceof IAjaxIndicatorAware) {
            return ((IAjaxIndicatorAware)((Object)this)).getAjaxIndicatorMarkupId();
        }
        for (MarkupContainer parent = this.getComponent().getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof IAjaxIndicatorAware)) continue;
            return ((IAjaxIndicatorAware)((Object)parent)).getAjaxIndicatorMarkupId();
        }
        return null;
    }

    public final void onRequest() {
        WebApplication app = (WebApplication)this.getComponent().getApplication();
        AjaxRequestTarget target = app.newAjaxRequestTarget(this.getComponent().getPage());
        RequestCycle.get().setRequestTarget(target);
        this.respond(target);
    }

    protected abstract void respond(AjaxRequestTarget var1);

    public static final CharSequence throttleScript(CharSequence script, String throttleId, Duration throttleDelay) {
        if (Strings.isEmpty(script)) {
            throw new IllegalArgumentException("script cannot be empty");
        }
        if (Strings.isEmpty(throttleId)) {
            throw new IllegalArgumentException("throttleId cannot be empty");
        }
        if (throttleDelay == null) {
            throw new IllegalArgumentException("throttleDelay cannot be null");
        }
        return new AppendingStringBuffer("wicketThrottler.throttle( '").append(throttleId).append("', ").append(throttleDelay.getMilliseconds()).append(", function() { ").append(script).append("});");
    }
}

