/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.hive.authorization.permissions;

import org.apache.wicket.Component;
import org.apache.wicket.security.actions.WaspAction;
import org.apache.wicket.security.hive.authorization.permissions.ComponentPermission;

public class ComponentSubclassPermission
extends ComponentPermission {
    private static final long serialVersionUID = 4906335298749077918L;

    public ComponentSubclassPermission(Component component, WaspAction action) {
        super(component, action);
    }

    public ComponentSubclassPermission(String componentAlias, WaspAction actions) {
        super(componentAlias, actions);
    }

    protected boolean equals(String[] path1, String[] path2) {
        if (path1.length != path2.length) {
            return false;
        }
        for (int count = 0; count < path1.length; ++count) {
            if ((count != 0 || this.isSubclass(path1[0], path2[0])) && (count <= 0 || path1[count].equals(path2[count]))) continue;
            return false;
        }
        return true;
    }

    protected boolean implies(String[] path1, String[] path2) {
        int i = 0;
        for (int j = 0; i < path1.length && j < path2.length; ++j) {
            if (i == 0 && j == 0 && this.isSubclass(path1[i], path2[j]) || path1[i].equals(path2[j])) {
                ++i;
                continue;
            }
            if (i <= 0) continue;
            return false;
        }
        return path1.length == i;
    }

    private boolean isSubclass(String classname1, String classname2) {
        try {
            Class<?> class1 = Class.forName(classname1);
            Class<?> class2 = Class.forName(classname2);
            return class2.isAssignableFrom(class1);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

