/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.service.common.delegate;

import java.io.Serializable;
import javax.jms.MessageListener;
import javax.management.MBeanException;
import javax.management.ObjectName;
import org.jboss.system.ServiceMBeanSupport;

public class JMSDelegate {
    private ServiceMBeanSupport service;
    private ObjectName jmsServiceName;

    public static int toJMSPriority(int dcmPriority) {
        return dcmPriority == 1 ? 5 : (dcmPriority == 2 ? 3 : 4);
    }

    public JMSDelegate(ServiceMBeanSupport service) {
        this.service = service;
    }

    public final ObjectName getJmsServiceName() {
        return this.jmsServiceName;
    }

    public final void setJmsServiceName(ObjectName jmsServiceName) {
        this.jmsServiceName = jmsServiceName;
    }

    public void startListening(String name, MessageListener listener, int receiverCount) throws Exception {
        try {
            this.service.getServer().invoke(this.jmsServiceName, "startListening", new Object[]{name, listener, new Integer(receiverCount)}, new String[]{String.class.getName(), MessageListener.class.getName(), Integer.TYPE.getName()});
        }
        catch (MBeanException e) {
            throw e.getTargetException();
        }
        catch (Exception e) {
            this.service.getLog().fatal((Object)("Failed to invoke operation startListening on " + this.jmsServiceName), (Throwable)e);
        }
    }

    public void stopListening(String name) throws Exception {
        try {
            this.service.getServer().invoke(this.jmsServiceName, "stopListening", new Object[]{name}, new String[]{String.class.getName()});
        }
        catch (MBeanException e) {
            throw e.getTargetException();
        }
        catch (Exception e) {
            this.service.getLog().fatal((Object)("Failed to invoke operation stopListening on " + this.jmsServiceName), (Throwable)e);
        }
    }

    public void queue(String name, Serializable obj, int prior, long scheduledTime) throws Exception {
        try {
            this.service.getServer().invoke(this.jmsServiceName, "queue", new Object[]{name, obj, new Integer(prior), new Long(scheduledTime)}, new String[]{String.class.getName(), Serializable.class.getName(), Integer.TYPE.getName(), Long.TYPE.getName()});
        }
        catch (MBeanException e) {
            throw e.getTargetException();
        }
        catch (Exception e) {
            this.service.getLog().fatal((Object)("Failed to invoke operation queue on " + this.jmsServiceName), (Throwable)e);
        }
    }

    public void fail(String name, Serializable obj) throws Exception {
        try {
            this.service.getServer().invoke(this.jmsServiceName, "fail", new Object[]{name, obj}, new String[]{String.class.getName(), Serializable.class.getName()});
        }
        catch (MBeanException e) {
            throw e.getTargetException();
        }
        catch (Exception e) {
            this.service.getLog().fatal((Object)("Failed to invoke operation fail on " + this.jmsServiceName), (Throwable)e);
        }
    }
}

